/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core;

import com.predic8.membrane.core.MembraneCommandLine;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.config.spring.CheckableBeanFactory;
import com.predic8.membrane.core.config.spring.TrackingFileSystemXmlApplicationContext;
import com.predic8.membrane.core.resolver.ResolverMap;
import com.predic8.membrane.core.resolver.ResourceRetrievalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionStoreException;

public class RouterCLI {
    private static final Logger LOG = LoggerFactory.getLogger(RouterCLI.class);

    public static void main(String[] args) {
        MembraneCommandLine cl = new MembraneCommandLine();
        try {
            cl.parse(args);
            if (cl.needHelp()) {
                cl.printUsage();
                return;
            }
            try {
                Router.init(RouterCLI.getRulesFile(cl), RouterCLI.class.getClassLoader());
            }
            catch (XmlBeanDefinitionStoreException e) {
                TrackingFileSystemXmlApplicationContext.handleXmlBeanDefinitionStoreException(e);
            }
        }
        catch (CheckableBeanFactory.InvalidConfigurationException e) {
            System.err.println("Fatal error: " + e.getMessage());
            System.exit(1);
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            ex.printStackTrace();
            System.exit(1);
        }
        new RouterCLI().waitForever();
    }

    private synchronized void waitForever() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static String getRulesFile(MembraneCommandLine line) {
        ResolverMap rm = new ResolverMap();
        if (line.hasConfiguration()) {
            String s = line.getConfiguration().replaceAll("\\\\", "/");
            if (s.startsWith("file:") || s.startsWith("/") || s.length() > 3 && s.substring(1, 3).equals(":/")) {
                try {
                    rm.resolve(s);
                    return s;
                }
                catch (ResourceRetrievalException e) {
                    System.err.println("Could not open Membrane's configuration file: " + s + " not found.");
                    System.exit(1);
                }
            }
            return RouterCLI.getRulesFileFromRelativeSpec(rm, s, "");
        }
        String errorNotice = "Please specify the location of Membrane's proxies.xml configuration file using the -c command line option.";
        errorNotice = System.getenv("MEMBRANE_HOME") != null ? errorNotice + " Or create the file in MEMBRANE_HOME/conf (" + System.getenv("MEMBRANE_HOME") + "/conf/proxies.xml)." : errorNotice + " You can also point the MEMBRANE_HOME environment variable to Membrane's distribution root directory and ensure that MEMBRANE_HOME/conf/proxies.xml exists.";
        return RouterCLI.getRulesFileFromRelativeSpec(rm, "conf/proxies.xml", errorNotice);
    }

    private static String getRulesFileFromRelativeSpec(ResolverMap rm, String relativeFile, String errorNotice) {
        String membraneHome = System.getenv("MEMBRANE_HOME");
        String userDir = System.getProperty("user.dir").replaceAll("\\\\", "/");
        if (!userDir.endsWith("/")) {
            userDir = userDir + "/";
        }
        String try1 = ResolverMap.combine(RouterCLI.prefix(userDir), relativeFile);
        try {
            rm.resolve(try1);
            return try1;
        }
        catch (ResourceRetrievalException resourceRetrievalException) {
            String try2 = null;
            if (membraneHome != null) {
                try2 = ResolverMap.combine(RouterCLI.prefix(membraneHome), relativeFile);
                try {
                    rm.resolve(try2);
                    return try2;
                }
                catch (ResourceRetrievalException resourceRetrievalException2) {
                    // empty catch block
                }
            }
            System.err.println("Could not find Membrane's configuration file at " + try1 + (try2 == null ? "" : " and not at " + try2) + " . " + errorNotice);
            System.exit(1);
            throw new RuntimeException();
        }
    }

    private static String prefix(String dir) {
        if (dir.startsWith("/")) {
            return "file://" + dir;
        }
        return dir;
    }
}

