/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchangestore.LimitedMemoryExchangeStore;
import com.predic8.membrane.core.interceptor.DispatchingInterceptor;
import com.predic8.membrane.core.interceptor.ExchangeStoreInterceptor;
import com.predic8.membrane.core.interceptor.HTTPClientInterceptor;
import com.predic8.membrane.core.interceptor.RuleMatchingInterceptor;
import com.predic8.membrane.core.interceptor.UserFeatureInterceptor;
import com.predic8.membrane.core.interceptor.rewrite.ReverseProxyingInterceptor;
import com.predic8.membrane.core.transport.http.HttpTransport;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.Ordered;

@MCElement(name="defaultConfig")
public class DefaultConfig
implements BeanFactoryPostProcessor,
Ordered {
    private int order = 100;

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        BeanDefinitionRegistry beanDefinitionRegistry = (BeanDefinitionRegistry)beanFactory;
        this.defineTransformerFactory(beanDefinitionRegistry);
        this.defineLimitedMemoryExchangeStore(beanDefinitionRegistry);
        this.defineTransport(beanDefinitionRegistry);
        this.defineRouter(beanDefinitionRegistry);
    }

    private void defineRouter(BeanDefinitionRegistry beanDefinitionRegistry) {
        if (!beanDefinitionRegistry.containsBeanDefinition("router")) {
            beanDefinitionRegistry.registerBeanDefinition("router", (BeanDefinition)this.root().clazz(Router.class).addRef("transport", "transport").addRef("exchangeStore", "memoryExchangeStore").build());
        }
    }

    private void defineTransport(BeanDefinitionRegistry beanDefinitionRegistry) {
        if (!beanDefinitionRegistry.containsBeanDefinition("transport")) {
            beanDefinitionRegistry.registerBeanDefinition("transport", (BeanDefinition)this.root().clazz(HttpTransport.class).addRef("interceptors[0]", this.childOf("transport").clazz(RuleMatchingInterceptor.class).build()).addRef("interceptors[1]", this.childOf("transport").clazz(ExchangeStoreInterceptor.class).addRef("exchangeStore", "memoryExchangeStore").build()).addRef("interceptors[2]", this.childOf("transport").clazz(DispatchingInterceptor.class).build()).addRef("interceptors[3]", this.childOf("transport").clazz(ReverseProxyingInterceptor.class).build()).addRef("interceptors[4]", this.childOf("transport").clazz(UserFeatureInterceptor.class).build()).addRef("interceptors[5]", this.childOf("transport").clazz(HTTPClientInterceptor.class).build()).build());
        }
    }

    private BeanDefinitionBuilder childOf(String parentBeanName) {
        return new BeanDefinitionBuilder(parentBeanName);
    }

    private BeanDefinitionBuilder root() {
        return new BeanDefinitionBuilder();
    }

    private void defineLimitedMemoryExchangeStore(BeanDefinitionRegistry beanDefinitionRegistry) {
        if (!beanDefinitionRegistry.containsBeanDefinition("memoryExchangeStore")) {
            beanDefinitionRegistry.registerBeanDefinition("memoryExchangeStore", (BeanDefinition)new RootBeanDefinition(LimitedMemoryExchangeStore.class));
        }
    }

    private void defineTransformerFactory(BeanDefinitionRegistry beanDefinitionRegistry) {
        if (!beanDefinitionRegistry.containsBeanDefinition("transformerFactory")) {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Please define a bean called 'transformerFactory' which extends javax.xml.transform.TransformeFactory to specify which XSLT processor to use.", e);
            }
            RootBeanDefinition def = new RootBeanDefinition(clazz);
            def.setScope("singleton");
            beanDefinitionRegistry.registerBeanDefinition("transformerFactory", (BeanDefinition)def);
        }
    }

    private class BeanDefinitionBuilder {
        private AbstractBeanDefinition cbd;

        public BeanDefinitionBuilder() {
            this.cbd = new RootBeanDefinition();
        }

        public BeanDefinitionBuilder(String parentBeanName) {
            this.cbd = new GenericBeanDefinition();
        }

        public BeanDefinitionBuilder clazz(Class<?> clazz) {
            this.cbd.setBeanClass(clazz);
            return this;
        }

        public BeanDefinitionBuilder addRef(String name, String ref) {
            this.cbd.getPropertyValues().add(name, (Object)new RuntimeBeanReference(ref));
            return this;
        }

        public BeanDefinitionBuilder addRef(String name, AbstractBeanDefinition beanDefinition) {
            this.cbd.getPropertyValues().add(name, (Object)beanDefinition);
            return this;
        }

        public AbstractBeanDefinition build() {
            return this.cbd;
        }
    }
}

