/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser.parsertokens;

import java.io.Serializable;
import org.mariuszgromada.math.mxparser.Argument;
import org.mariuszgromada.math.mxparser.Constant;
import org.mariuszgromada.math.mxparser.Function;
import org.mariuszgromada.math.mxparser.RecursiveArgument;
import org.mariuszgromada.math.mxparser.SerializationUtils;
import org.mariuszgromada.math.mxparser.StringModel;
import org.mariuszgromada.math.mxparser.parsertokens.BinaryRelation;
import org.mariuszgromada.math.mxparser.parsertokens.BitwiseOperator;
import org.mariuszgromada.math.mxparser.parsertokens.BooleanOperator;
import org.mariuszgromada.math.mxparser.parsertokens.CalculusOperator;
import org.mariuszgromada.math.mxparser.parsertokens.ConstantValue;
import org.mariuszgromada.math.mxparser.parsertokens.Function1Arg;
import org.mariuszgromada.math.mxparser.parsertokens.Function2Arg;
import org.mariuszgromada.math.mxparser.parsertokens.Function3Arg;
import org.mariuszgromada.math.mxparser.parsertokens.FunctionVariadic;
import org.mariuszgromada.math.mxparser.parsertokens.Operator;
import org.mariuszgromada.math.mxparser.parsertokens.ParserSymbol;
import org.mariuszgromada.math.mxparser.parsertokens.RandomVariable;
import org.mariuszgromada.math.mxparser.parsertokens.Unit;

public class Token
implements Serializable {
    private static final int serialClassID = 92;
    private static final long serialVersionUID = SerializationUtils.getSerialVersionUID(92);
    public static final int NOT_MATCHED = -1;
    public String tokenStr = "";
    public String keyWord = "";
    public int tokenId = -1;
    public int tokenTypeId = -1;
    public int tokenLevel = -1;
    public double tokenValue = Double.NaN;
    public String looksLike = "";

    public boolean isUnaryLeftOperator() {
        if (this.tokenTypeId == 1) {
            if (this.tokenId == 10) {
                return true;
            }
            if (this.tokenId == 11) {
                return true;
            }
            if (this.tokenId == 12) {
                return true;
            }
        }
        if (this.tokenTypeId == 2 && this.tokenId == 11) {
            return true;
        }
        return this.tokenTypeId == 11 && this.tokenId == 1;
    }

    public boolean isUnaryRightOperator() {
        if (this.tokenTypeId == 1) {
            if (this.tokenId == 6) {
                return true;
            }
            if (this.tokenId == 8) {
                return true;
            }
        }
        return false;
    }

    public boolean isLeftParenthesis() {
        return this.tokenTypeId == 20 && this.tokenId == 1;
    }

    public boolean isRightParenthesis() {
        return this.tokenTypeId == 20 && this.tokenId == 2;
    }

    public boolean isIdentifier() {
        return this.tokenTypeId == 104 || this.tokenTypeId == 9 || this.tokenTypeId == 12 || this.tokenTypeId == 101;
    }

    public boolean isBinaryOperator() {
        if (this.isUnaryLeftOperator()) {
            return false;
        }
        if (this.isUnaryRightOperator()) {
            return false;
        }
        if (this.tokenTypeId == 3) {
            return true;
        }
        if (this.tokenTypeId == 11) {
            return true;
        }
        if (this.tokenTypeId == 2) {
            return true;
        }
        if (this.tokenTypeId == 1) {
            return this.tokenId != 10 && this.tokenId != 11 && this.tokenId != 12 && this.tokenId != 6 && this.tokenId != 8;
        }
        return false;
    }

    public boolean isParameterSeparator() {
        return this.tokenTypeId == 20 && this.tokenId == 3;
    }

    public boolean isNumber() {
        return this.tokenTypeId == 0 && this.tokenId == 1;
    }

    public boolean isSpecialTokenName() {
        if (this.tokenStr.length() == 0) {
            return false;
        }
        return this.tokenStr.charAt(0) == '[';
    }

    public boolean isUnicodeRootOperator() {
        if (this.tokenTypeId == 1) {
            if (this.tokenId == 10) {
                return true;
            }
            if (this.tokenId == 11) {
                return true;
            }
            if (this.tokenId == 12) {
                return true;
            }
        }
        return false;
    }

    public static Token makeMultiplyToken() {
        Token multiplyToken = new Token();
        multiplyToken.tokenTypeId = 1;
        multiplyToken.tokenId = 3;
        multiplyToken.tokenStr = "*";
        return multiplyToken;
    }

    public static String getTokenTypeDescription(int tokenTypeId) {
        switch (tokenTypeId) {
            case 20: {
                return ParserSymbol.TYPE_DESC;
            }
            case 0: {
                return StringModel.getStringResources().NUMBER;
            }
            case 1: {
                return Operator.TYPE_DESC;
            }
            case 2: {
                return BooleanOperator.TYPE_DESC;
            }
            case 3: {
                return BinaryRelation.TYPE_DESC;
            }
            case 4: {
                return Function1Arg.TYPE_DESC;
            }
            case 5: {
                return Function2Arg.TYPE_DESC;
            }
            case 6: {
                return Function3Arg.TYPE_DESC;
            }
            case 7: {
                return FunctionVariadic.TYPE_DESC;
            }
            case 8: {
                return CalculusOperator.TYPE_DESC;
            }
            case 10: {
                return RandomVariable.TYPE_DESC;
            }
            case 9: {
                return ConstantValue.TYPE_DESC;
            }
            case 101: {
                return Argument.TYPE_DESC;
            }
            case 102: {
                return RecursiveArgument.TYPE_DESC_RECURSIVE;
            }
            case 103: {
                return Function.TYPE_DESC;
            }
            case 104: {
                return Constant.TYPE_DESC;
            }
            case 12: {
                return Unit.TYPE_DESC;
            }
            case 11: {
                return BitwiseOperator.TYPE_DESC;
            }
        }
        return "";
    }

    public Token clone() {
        Token token = new Token();
        token.keyWord = this.keyWord;
        token.tokenStr = this.tokenStr;
        token.tokenId = this.tokenId;
        token.tokenLevel = this.tokenLevel;
        token.tokenTypeId = this.tokenTypeId;
        token.tokenValue = this.tokenValue;
        token.looksLike = this.looksLike;
        return token;
    }
}

