/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.writer;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.tools.FileObject;
import org.mapstruct.ap.internal.writer.IndentationCorrectingWriter;
import org.mapstruct.ap.internal.writer.ModelIncludeDirective;
import org.mapstruct.ap.internal.writer.Writable;
import org.mapstruct.ap.shaded.freemarker.cache.StrongCacheStorage;
import org.mapstruct.ap.shaded.freemarker.cache.TemplateLoader;
import org.mapstruct.ap.shaded.freemarker.log.Logger;
import org.mapstruct.ap.shaded.freemarker.template.Configuration;
import org.mapstruct.ap.shaded.freemarker.template.DefaultObjectWrapper;

public class ModelWriter {
    private static final Configuration CONFIGURATION;

    public void writeModel(FileObject sourceFile, Writable model) {
        try (BufferedWriter writer = new BufferedWriter(new IndentationCorrectingWriter(sourceFile.openWriter()));){
            HashMap values = new HashMap();
            values.put(Configuration.class, CONFIGURATION);
            model.write(new DefaultModelElementWriterContext(values), writer);
            writer.flush();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            Logger.selectLoggerLibrary(0);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        CONFIGURATION = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        CONFIGURATION.setTemplateLoader(new SimpleClasspathLoader());
        CONFIGURATION.setObjectWrapper(new DefaultObjectWrapper(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS));
        CONFIGURATION.setSharedVariable("includeModel", new ModelIncludeDirective(CONFIGURATION));
        CONFIGURATION.setCacheStorage(new StrongCacheStorage());
        CONFIGURATION.setTemplateUpdateDelay(Integer.MAX_VALUE);
        CONFIGURATION.setLocalizedLookup(false);
    }

    static class DefaultModelElementWriterContext
    implements Writable.Context {
        private final Map<Class<?>, Object> values;

        DefaultModelElementWriterContext(Map<Class<?>, Object> values) {
            this.values = new HashMap(values);
        }

        @Override
        public <T> T get(Class<T> type) {
            return (T)this.values.get(type);
        }
    }

    private static final class SimpleClasspathLoader
    implements TemplateLoader {
        private SimpleClasspathLoader() {
        }

        @Override
        public Reader getReader(Object name, String encoding) throws IOException {
            URL url = this.getClass().getClassLoader().getResource(String.valueOf(name));
            if (url == null) {
                throw new IllegalStateException(name + " not found on classpath");
            }
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            InputStream is = connection.getInputStream();
            return new InputStreamReader(is, StandardCharsets.UTF_8);
        }

        @Override
        public long getLastModified(Object templateSource) {
            return 0L;
        }

        @Override
        public Object findTemplateSource(String name) throws IOException {
            return name;
        }

        @Override
        public void closeTemplateSource(Object templateSource) throws IOException {
        }
    }
}

