/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.elsa;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import org.mapdb.elsa.SerializerPojo;

public class ElsaObjectInputStream
extends ObjectInputStream {
    protected final DataInput input;
    protected SerializerPojo serializer;

    public ElsaObjectInputStream(InputStream stream) throws IOException {
        this(new DataInputStream(stream), new SerializerPojo());
    }

    public ElsaObjectInputStream(DataInput input, SerializerPojo serializer) throws IOException {
        this.input = input;
        this.serializer = serializer;
    }

    @Override
    protected Object readObjectOverride() throws IOException, ClassNotFoundException {
        return this.serializer.deserialize(this.input, -1);
    }

    @Override
    public void close() throws IOException {
        if (this.input instanceof Closeable) {
            ((Closeable)((Object)this.input)).close();
        }
    }
}

