/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import liquibase.database.Database;
import liquibase.database.core.SnowflakeDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.DropProcedureGenerator;
import liquibase.statement.core.DropProcedureStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Schema;

public class DropProcedureGeneratorSnowflake
extends DropProcedureGenerator {
    @Override
    public boolean supports(DropProcedureStatement statement, Database database) {
        return database instanceof SnowflakeDatabase;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public Sql[] generateSql(DropProcedureStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        if (statement.getCatalogName() != null) {
            return new Sql[]{new UnparsedSql("DROP PROCEDURE " + database.escapeObjectName(statement.getCatalogName(), Catalog.class) + statement.getProcedureName(), new DatabaseObject[0])};
        }
        if (statement.getSchemaName() != null) {
            return new Sql[]{new UnparsedSql("DROP PROCEDURE " + database.escapeObjectName(statement.getSchemaName(), Schema.class) + statement.getProcedureName(), new DatabaseObject[0])};
        }
        return new Sql[]{new UnparsedSql("DROP PROCEDURE " + statement.getProcedureName(), new DatabaseObject[0])};
    }
}

