/*
 * Decompiled with CFR 0.152.
 */
package liquibase.statement;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import liquibase.change.ColumnConfig;
import liquibase.change.core.LoadDataChange;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.database.PreparedStatementFactory;
import liquibase.datatype.DataTypeFactory;
import liquibase.datatype.LiquibaseDataType;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.logging.LogService;
import liquibase.logging.LogType;
import liquibase.logging.Logger;
import liquibase.resource.ResourceAccessor;
import liquibase.resource.UtfBomAwareReader;
import liquibase.statement.ExecutablePreparedStatement;
import liquibase.util.JdbcUtils;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtils;
import liquibase.util.file.FilenameUtils;

public abstract class ExecutablePreparedStatementBase
implements ExecutablePreparedStatement {
    private static final Logger LOG = LogService.getLog(ExecutablePreparedStatementBase.class);
    private static ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    protected Database database;
    private String catalogName;
    private String schemaName;
    private String tableName;
    private List<ColumnConfig> columns;
    private ChangeSet changeSet;
    private Set<Closeable> closeables;
    private ResourceAccessor resourceAccessor;

    protected ExecutablePreparedStatementBase(Database database, String catalogName, String schemaName, String tableName, List<ColumnConfig> columns, ChangeSet changeSet, ResourceAccessor resourceAccessor) {
        this.database = database;
        this.changeSet = changeSet;
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.columns = columns;
        this.changeSet = changeSet;
        this.closeables = new HashSet<Closeable>();
        this.resourceAccessor = resourceAccessor;
    }

    private static InputStream createStream(InputStream in2) {
        return in2 instanceof BufferedInputStream ? in2 : new BufferedInputStream(in2);
    }

    private static Reader createReader(InputStream in2, String encoding) {
        return new BufferedReader(StringUtils.trimToNull(encoding) == null ? new UtfBomAwareReader(in2) : new UtfBomAwareReader(in2, encoding));
    }

    @Override
    public void execute(PreparedStatementFactory factory) throws DatabaseException {
        ArrayList<ColumnConfig> cols = new ArrayList<ColumnConfig>(this.getColumns().size());
        String sql = this.generateSql(cols);
        LOG.info(LogType.WRITE_SQL, sql);
        LOG.debug(LogType.LOG, "Number of columns = " + cols.size());
        PreparedStatement stmt = factory.create(sql);
        try {
            this.attachParams(cols, stmt);
            this.executePreparedStatement(stmt);
        }
        catch (SQLException e2) {
            throw new DatabaseException(e2);
        }
        finally {
            for (Closeable closeable : this.closeables) {
                StreamUtil.closeQuietly(closeable);
            }
            JdbcUtils.closeStatement(stmt);
        }
    }

    protected void executePreparedStatement(PreparedStatement stmt) throws SQLException {
        stmt.execute();
    }

    protected void attachParams(List<ColumnConfig> cols, PreparedStatement stmt) throws SQLException, DatabaseException {
        int i2 = 1;
        for (ColumnConfig col : cols) {
            LOG.debug(LogType.LOG, "Applying column parameter = " + i2 + " for column " + col.getName());
            this.applyColumnParameter(stmt, i2, col);
            ++i2;
        }
    }

    protected abstract String generateSql(List<ColumnConfig> var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void applyColumnParameter(PreparedStatement stmt, int i2, ColumnConfig col) throws SQLException, DatabaseException {
        if (col.getValue() != null) {
            LOG.debug(LogType.LOG, "value is string/UUID/blob = " + col.getValue());
            if (col.getType() != null && col.getType().equalsIgnoreCase(LoadDataChange.LOAD_DATA_TYPE.UUID.name())) {
                stmt.setObject(i2, UUID.fromString(col.getValue()));
                return;
            } else if (LoadDataChange.LOAD_DATA_TYPE.BLOB.name().equalsIgnoreCase(col.getType())) {
                stmt.setBlob(i2, new ByteArrayInputStream(Base64.getDecoder().decode(col.getValue())));
                return;
            } else {
                stmt.setString(i2, col.getValue());
            }
            return;
        } else if (col.getValueBoolean() != null) {
            LOG.debug(LogType.LOG, "value is boolean = " + col.getValueBoolean());
            stmt.setBoolean(i2, col.getValueBoolean());
            return;
        } else if (col.getValueNumeric() != null) {
            LOG.debug(LogType.LOG, "value is numeric = " + col.getValueNumeric());
            Number number = col.getValueNumeric();
            if (number instanceof ColumnConfig.ValueNumeric) {
                ColumnConfig.ValueNumeric valueNumeric = (ColumnConfig.ValueNumeric)number;
                number = valueNumeric.getDelegate();
            }
            if (number instanceof Long) {
                stmt.setLong(i2, number.longValue());
                return;
            } else if (number instanceof Integer) {
                stmt.setInt(i2, number.intValue());
                return;
            } else if (number instanceof Double) {
                stmt.setDouble(i2, number.doubleValue());
                return;
            } else if (number instanceof Float) {
                stmt.setFloat(i2, number.floatValue());
                return;
            } else if (number instanceof BigDecimal) {
                stmt.setBigDecimal(i2, (BigDecimal)number);
                return;
            } else {
                if (!(number instanceof BigInteger)) throw new UnexpectedLiquibaseException(String.format(coreBundle.getString("jdbc.bind.parameter.unknown.numeric.value.type"), col.getName(), col.getValueNumeric().toString(), col.getValueNumeric().getClass().getName()));
                stmt.setInt(i2, number.intValue());
            }
            return;
        } else if (col.getValueDate() != null) {
            LOG.debug(LogType.LOG, "value is date = " + col.getValueDate());
            if (col.getValueDate() instanceof Timestamp) {
                stmt.setTimestamp(i2, (Timestamp)col.getValueDate());
                return;
            } else if (col.getValueDate() instanceof Time) {
                stmt.setTime(i2, (Time)col.getValueDate());
                return;
            } else {
                stmt.setDate(i2, new Date(col.getValueDate().getTime()));
            }
            return;
        } else if (col.getValueBlobFile() != null) {
            LOG.debug(LogType.LOG, "value is blob = " + col.getValueBlobFile());
            try {
                LOBContent<InputStream> lob = this.toBinaryStream(col.getValueBlobFile());
                if (((LOBContent)lob).length <= Integer.MAX_VALUE) {
                    stmt.setBinaryStream(i2, (InputStream)((LOBContent)lob).content, (int)((LOBContent)lob).length);
                    return;
                }
                stmt.setBinaryStream(i2, (InputStream)((LOBContent)lob).content, ((LOBContent)lob).length);
                return;
            }
            catch (IOException e2) {
                throw new DatabaseException(e2.getMessage(), e2);
            }
        } else if (col.getValueClobFile() != null) {
            try {
                LOG.debug(LogType.LOG, "value is clob = " + col.getValueClobFile());
                LOBContent<Reader> lob = this.toCharacterStream(col.getValueClobFile(), col.getEncoding());
                if (((LOBContent)lob).length <= Integer.MAX_VALUE) {
                    stmt.setCharacterStream(i2, (Reader)((LOBContent)lob).content, (int)((LOBContent)lob).length);
                    return;
                }
                stmt.setCharacterStream(i2, (Reader)((LOBContent)lob).content, ((LOBContent)lob).length);
                return;
            }
            catch (IOException e3) {
                throw new DatabaseException(e3.getMessage(), e3);
            }
        } else {
            LOG.debug(LogType.LOG, "value is explicit null");
            if (col.getType() == null) {
                stmt.setNull(i2, 0);
                return;
            }
            if (col.getType().toLowerCase().contains("datetime")) {
                stmt.setNull(i2, 93);
                return;
            } else {
                String[] aliases;
                boolean isSet = false;
                LiquibaseDataType dataType = DataTypeFactory.getInstance().fromDescription(col.getType(), this.database);
                for (String alias : aliases = dataType.getAliases()) {
                    if (!alias.contains("java.sql.Types")) continue;
                    String name = alias.replaceAll("java.sql.Types.", "");
                    try {
                        JDBCType jdbcType = Enum.valueOf(JDBCType.class, name);
                        stmt.setNull(i2, jdbcType.getVendorTypeNumber());
                        return;
                    }
                    catch (Exception exception) {}
                    break;
                }
                if (isSet) return;
                LOG.info(LogType.LOG, String.format("Using java.sql.Types.NULL to set null value for type %s", dataType.getName()));
                stmt.setNull(i2, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LOBContent<InputStream> toBinaryStream(String valueLobFile) throws DatabaseException, IOException {
        InputStream in2 = this.getResourceAsStream(valueLobFile);
        if (in2 == null) {
            throw new DatabaseException("BLOB resource not found: " + valueLobFile);
        }
        try {
            if (in2 instanceof FileInputStream) {
                InputStream bufferedInput = ExecutablePreparedStatementBase.createStream(in2);
                LOBContent<InputStream> lOBContent = new LOBContent<InputStream>(bufferedInput, ((FileInputStream)in2).getChannel().size());
                return lOBContent;
            }
            in2 = ExecutablePreparedStatementBase.createStream(in2);
            int IN_MEMORY_THRESHOLD = 100000;
            if (in2.markSupported()) {
                in2.mark(100000);
            }
            long length = StreamUtil.getContentLength(in2);
            if (in2.markSupported() && length <= 100000L) {
                in2.reset();
            } else {
                StreamUtil.closeQuietly(in2);
                in2 = this.getResourceAsStream(valueLobFile);
                in2 = ExecutablePreparedStatementBase.createStream(in2);
            }
            LOBContent<InputStream> lOBContent = new LOBContent<InputStream>(in2, length);
            return lOBContent;
        }
        finally {
            if (in2 != null) {
                this.closeables.add(in2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LOBContent<Reader> toCharacterStream(String valueLobFile, String encoding) throws IOException, DatabaseException {
        InputStream in2 = this.getResourceAsStream(valueLobFile);
        if (in2 == null) {
            throw new DatabaseException("CLOB resource not found: " + valueLobFile);
        }
        int IN_MEMORY_THRESHOLD = 100000;
        Reader reader = null;
        try {
            reader = ExecutablePreparedStatementBase.createReader(in2, encoding);
            if (reader.markSupported()) {
                reader.mark(100000);
            }
            long length = StreamUtil.getContentLength(reader);
            if (reader.markSupported() && length <= 100000L) {
                reader.reset();
            } else {
                StreamUtil.closeQuietly(reader);
                in2 = this.getResourceAsStream(valueLobFile);
                reader = ExecutablePreparedStatementBase.createReader(in2, encoding);
            }
            LOBContent<Reader> lOBContent = new LOBContent<Reader>(reader, length);
            return lOBContent;
        }
        finally {
            if (reader != null) {
                this.closeables.add(reader);
            }
            if (in2 != null) {
                this.closeables.add(in2);
            }
        }
    }

    private InputStream getResourceAsStream(String valueLobFile) throws IOException {
        String fileName = this.getFileName(valueLobFile);
        Set<InputStream> streams = this.resourceAccessor.getResourcesAsStream(fileName);
        if (streams == null || streams.isEmpty()) {
            return null;
        }
        if (streams.size() > 1) {
            for (InputStream stream : streams) {
                stream.close();
            }
            throw new IOException(streams.size() + " matched " + valueLobFile);
        }
        return streams.iterator().next();
    }

    private String getFileName(String fileName) {
        String relativeBaseFileName = this.changeSet.getChangeLog().getPhysicalFilePath();
        String tempFile = FilenameUtils.concat(FilenameUtils.getFullPath(relativeBaseFileName), fileName);
        fileName = tempFile != null ? tempFile : FilenameUtils.getFullPath(relativeBaseFileName) + fileName;
        return fileName;
    }

    public String getAbsolutePath(String path) {
        String p2 = path;
        File f2 = new File(p2);
        if (!f2.isAbsolute()) {
            String basePath = FilenameUtils.getFullPath(this.changeSet.getChangeLog().getPhysicalFilePath());
            p2 = FilenameUtils.normalize(basePath + p2);
        }
        return p2;
    }

    @Override
    public boolean skipOnUnsupported() {
        return false;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<ColumnConfig> getColumns() {
        return this.columns;
    }

    private class LOBContent<T> {
        private final T content;
        private final long length;

        LOBContent(T content, long length) {
            this.content = content;
            this.length = length;
        }
    }
}

