/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.select;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.expression.Alias;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.Function;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.schema.Column;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PivotVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectItem;

public class Pivot
implements Serializable {
    private List<SelectItem<Function>> functionItems;
    private ExpressionList<Column> forColumns;
    private List<SelectItem<?>> singleInItems;
    private List<SelectItem<ExpressionList>> multiInItems;
    private Alias alias;

    public void accept(PivotVisitor pivotVisitor) {
        pivotVisitor.visit(this);
    }

    public List<SelectItem<?>> getSingleInItems() {
        return this.singleInItems;
    }

    public void setSingleInItems(List<SelectItem<?>> list) {
        this.singleInItems = list;
    }

    public List<SelectItem<ExpressionList>> getMultiInItems() {
        return this.multiInItems;
    }

    public void setMultiInItems(List<SelectItem<ExpressionList>> list) {
        this.multiInItems = list;
    }

    public List<SelectItem<Function>> getFunctionItems() {
        return this.functionItems;
    }

    public void setFunctionItems(List<SelectItem<Function>> list) {
        this.functionItems = list;
    }

    public ExpressionList<Column> getForColumns() {
        return this.forColumns;
    }

    public void setForColumns(ExpressionList<Column> expressionList) {
        this.forColumns = expressionList;
    }

    public List<?> getInItems() {
        if (this.singleInItems == null) {
            return this.multiInItems;
        }
        return this.singleInItems;
    }

    public Alias getAlias() {
        return this.alias;
    }

    public void setAlias(Alias alias) {
        this.alias = alias;
    }

    public String toString() {
        return "PIVOT (" + PlainSelect.getStringList(this.functionItems) + " FOR " + PlainSelect.getStringList(this.forColumns, true, this.forColumns != null && this.forColumns.size() > 1) + " IN " + PlainSelect.getStringList(this.getInItems(), true, true) + ")" + (this.alias != null ? this.alias.toString() : "");
    }

    public Pivot withFunctionItems(List<SelectItem<Function>> list) {
        this.setFunctionItems(list);
        return this;
    }

    public Pivot withForColumns(ExpressionList<Column> expressionList) {
        this.setForColumns(expressionList);
        return this;
    }

    public Pivot withSingleInItems(List<SelectItem<?>> list) {
        this.setSingleInItems(list);
        return this;
    }

    public Pivot withMultiInItems(List<SelectItem<ExpressionList>> list) {
        this.setMultiInItems(list);
        return this;
    }

    public Pivot withAlias(Alias alias) {
        this.setAlias(alias);
        return this;
    }

    public Pivot addFunctionItems(SelectItem<Function> ... selectItemArray) {
        List list = Optional.ofNullable(this.getFunctionItems()).orElseGet(ArrayList::new);
        Collections.addAll(list, selectItemArray);
        return this.withFunctionItems(list);
    }

    public Pivot addFunctionItems(Collection<? extends SelectItem<Function>> collection) {
        List list = Optional.ofNullable(this.getFunctionItems()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withFunctionItems(list);
    }

    public Pivot addForColumns(Column ... columnArray) {
        return this.addForColumns(Arrays.asList(columnArray));
    }

    public Pivot addForColumns(Collection<? extends Column> collection) {
        ExpressionList expressionList = Optional.ofNullable(this.getForColumns()).orElseGet(() -> new ExpressionList((Expression[])new Column[0]));
        expressionList.addAll(collection);
        return this.withForColumns(expressionList);
    }

    public Pivot addSingleInItems(SelectItem<?> ... selectItemArray) {
        List list = Optional.ofNullable(this.getSingleInItems()).orElseGet(ArrayList::new);
        Collections.addAll(list, selectItemArray);
        return this.withSingleInItems(list);
    }

    public Pivot addSingleInItems(Collection<? extends SelectItem<?>> collection) {
        List list = Optional.ofNullable(this.getSingleInItems()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withSingleInItems(list);
    }

    public Pivot addMultiInItems(SelectItem<ExpressionList> ... selectItemArray) {
        List list = Optional.ofNullable(this.getMultiInItems()).orElseGet(ArrayList::new);
        Collections.addAll(list, selectItemArray);
        return this.withMultiInItems(list);
    }

    public Pivot addMultiInItems(Collection<? extends SelectItem<ExpressionList>> collection) {
        List list = Optional.ofNullable(this.getMultiInItems()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withMultiInItems(list);
    }
}

