/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.insert;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.OracleHint;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.schema.Column;
import liquibase.repackaged.net.sf.jsqlparser.schema.Table;
import liquibase.repackaged.net.sf.jsqlparser.statement.OutputClause;
import liquibase.repackaged.net.sf.jsqlparser.statement.ReturningClause;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.StatementVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.insert.InsertConflictAction;
import liquibase.repackaged.net.sf.jsqlparser.statement.insert.InsertConflictTarget;
import liquibase.repackaged.net.sf.jsqlparser.statement.insert.InsertModifierPriority;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Select;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SetOperationList;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Values;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.WithItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.update.UpdateSet;

public class Insert
implements Statement {
    private Table table;
    private OracleHint oracleHint = null;
    private ExpressionList<Column> columns;
    private Select select;
    private List<UpdateSet> duplicateUpdateSets = null;
    private InsertModifierPriority modifierPriority = null;
    private boolean modifierIgnore = false;
    private ReturningClause returningClause;
    private List<UpdateSet> setUpdateSets = null;
    private List<WithItem> withItemsList;
    private OutputClause outputClause;
    private InsertConflictTarget conflictTarget;
    private InsertConflictAction conflictAction;

    public List<UpdateSet> getDuplicateUpdateSets() {
        return this.duplicateUpdateSets;
    }

    public List<UpdateSet> getSetUpdateSets() {
        return this.setUpdateSets;
    }

    public Insert withDuplicateUpdateSets(List<UpdateSet> list) {
        this.duplicateUpdateSets = list;
        return this;
    }

    public Insert withSetUpdateSets(List<UpdateSet> list) {
        this.setUpdateSets = list;
        return this;
    }

    public OutputClause getOutputClause() {
        return this.outputClause;
    }

    public void setOutputClause(OutputClause outputClause) {
        this.outputClause = outputClause;
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public OracleHint getOracleHint() {
        return this.oracleHint;
    }

    public void setOracleHint(OracleHint oracleHint) {
        this.oracleHint = oracleHint;
    }

    public ExpressionList<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(ExpressionList<Column> expressionList) {
        this.columns = expressionList;
    }

    @Deprecated
    public boolean isUseValues() {
        return this.select != null && this.select instanceof Values;
    }

    public ReturningClause getReturningClause() {
        return this.returningClause;
    }

    public Insert setReturningClause(ReturningClause returningClause) {
        this.returningClause = returningClause;
        return this;
    }

    public Select getSelect() {
        return this.select;
    }

    public void setSelect(Select select) {
        this.select = select;
    }

    public Values getValues() {
        return this.select.getValues();
    }

    public PlainSelect getPlainSelect() {
        return this.select.getPlainSelect();
    }

    public SetOperationList getSetOperationList() {
        return this.select.getSetOperationList();
    }

    @Deprecated
    public boolean isUseSelectBrackets() {
        return false;
    }

    @Deprecated
    public boolean isUseDuplicate() {
        return this.duplicateUpdateSets != null && !this.duplicateUpdateSets.isEmpty();
    }

    public InsertModifierPriority getModifierPriority() {
        return this.modifierPriority;
    }

    public void setModifierPriority(InsertModifierPriority insertModifierPriority) {
        this.modifierPriority = insertModifierPriority;
    }

    public boolean isModifierIgnore() {
        return this.modifierIgnore;
    }

    public void setModifierIgnore(boolean bl2) {
        this.modifierIgnore = bl2;
    }

    @Deprecated
    public boolean isUseSet() {
        return this.setUpdateSets != null && !this.setUpdateSets.isEmpty();
    }

    public List<WithItem> getWithItemsList() {
        return this.withItemsList;
    }

    public void setWithItemsList(List<WithItem> list) {
        this.withItemsList = list;
    }

    public InsertConflictTarget getConflictTarget() {
        return this.conflictTarget;
    }

    public void setConflictTarget(InsertConflictTarget insertConflictTarget) {
        this.conflictTarget = insertConflictTarget;
    }

    public Insert withConflictTarget(InsertConflictTarget insertConflictTarget) {
        this.setConflictTarget(insertConflictTarget);
        return this;
    }

    public InsertConflictAction getConflictAction() {
        return this.conflictAction;
    }

    public void setConflictAction(InsertConflictAction insertConflictAction) {
        this.conflictAction = insertConflictAction;
    }

    public Insert withConflictAction(InsertConflictAction insertConflictAction) {
        this.setConflictAction(insertConflictAction);
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.withItemsList != null && !this.withItemsList.isEmpty()) {
            stringBuilder.append("WITH ");
            Iterator<WithItem> iterator = this.withItemsList.iterator();
            while (iterator.hasNext()) {
                WithItem withItem = iterator.next();
                stringBuilder.append(withItem);
                if (iterator.hasNext()) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(" ");
            }
        }
        stringBuilder.append("INSERT ");
        if (this.modifierPriority != null) {
            stringBuilder.append(this.modifierPriority.name()).append(" ");
        }
        if (this.modifierIgnore) {
            stringBuilder.append("IGNORE ");
        }
        stringBuilder.append("INTO ");
        stringBuilder.append(this.table).append(" ");
        if (this.columns != null) {
            stringBuilder.append("(");
            for (int i2 = 0; i2 < this.columns.size(); ++i2) {
                if (i2 > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(((Column)this.columns.get(i2)).getColumnName());
            }
            stringBuilder.append(") ");
        }
        if (this.outputClause != null) {
            stringBuilder.append(this.outputClause);
        }
        if (this.select != null) {
            stringBuilder.append(this.select);
        }
        if (this.setUpdateSets != null && !this.setUpdateSets.isEmpty()) {
            stringBuilder.append("SET ");
            stringBuilder = UpdateSet.appendUpdateSetsTo(stringBuilder, this.setUpdateSets);
        }
        if (this.duplicateUpdateSets != null && !this.duplicateUpdateSets.isEmpty()) {
            stringBuilder.append(" ON DUPLICATE KEY UPDATE ");
            stringBuilder = UpdateSet.appendUpdateSetsTo(stringBuilder, this.duplicateUpdateSets);
        }
        if (this.conflictAction != null) {
            stringBuilder.append(" ON CONFLICT");
            if (this.conflictTarget != null) {
                this.conflictTarget.appendTo(stringBuilder);
            }
            this.conflictAction.appendTo(stringBuilder);
        }
        if (this.returningClause != null) {
            this.returningClause.appendTo(stringBuilder);
        }
        return stringBuilder.toString();
    }

    public Insert withWithItemsList(List<WithItem> list) {
        this.withItemsList = list;
        return this;
    }

    public Insert withSelect(Select select) {
        this.setSelect(select);
        return this;
    }

    public Insert withModifierPriority(InsertModifierPriority insertModifierPriority) {
        this.setModifierPriority(insertModifierPriority);
        return this;
    }

    public Insert withModifierIgnore(boolean bl2) {
        this.setModifierIgnore(bl2);
        return this;
    }

    public Insert withTable(Table table) {
        this.setTable(table);
        return this;
    }

    public Insert withColumns(ExpressionList<Column> expressionList) {
        this.setColumns(expressionList);
        return this;
    }

    public Insert addColumns(Column ... columnArray) {
        return this.addColumns(Arrays.asList(columnArray));
    }

    public Insert addColumns(Collection<Column> collection) {
        ExpressionList expressionList = Optional.ofNullable(this.getColumns()).orElseGet(() -> new ExpressionList((Expression[])new Column[0]));
        expressionList.addAll(collection);
        return this.withColumns(expressionList);
    }
}

