/*
 * Decompiled with CFR 0.152.
 */
package liquibase.pro.packaged;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import liquibase.pro.packaged.pA;
import liquibase.pro.packaged.pB;
import liquibase.pro.packaged.pC;
import liquibase.pro.packaged.pD;
import liquibase.pro.packaged.pF;
import liquibase.pro.packaged.pG;
import liquibase.pro.packaged.pq;
import liquibase.pro.packaged.pt;
import liquibase.pro.packaged.pu;
import liquibase.pro.packaged.pv;
import liquibase.pro.packaged.px;
import liquibase.pro.packaged.pz;

public final class ps<K, V>
extends AbstractMap<K, V>
implements Serializable,
ConcurrentMap<K, V> {
    static final int NCPU = Runtime.getRuntime().availableProcessors();
    static final long MAXIMUM_CAPACITY = 9223372034707292160L;
    static final int NUMBER_OF_READ_BUFFERS = Math.min(4, ps.ceilingNextPowerOfTwo(NCPU));
    static final int READ_BUFFERS_MASK = NUMBER_OF_READ_BUFFERS - 1;
    static final int READ_BUFFER_THRESHOLD = 4;
    static final int READ_BUFFER_DRAIN_THRESHOLD = 8;
    static final int READ_BUFFER_SIZE = 16;
    static final int READ_BUFFER_INDEX_MASK = 15;
    static final int WRITE_BUFFER_DRAIN_THRESHOLD = 16;
    final ConcurrentMap<K, pA<K, V>> data;
    final int concurrencyLevel;
    final long[] readBufferReadCount;
    final pq<pA<K, V>> evictionDeque;
    final AtomicLong weightedSize;
    final AtomicLong capacity;
    final Lock evictionLock;
    final Queue<Runnable> writeBuffer;
    final AtomicLongArray readBufferWriteCount;
    final AtomicLongArray readBufferDrainAtWriteCount;
    final AtomicReferenceArray<pA<K, V>> readBuffers;
    final AtomicReference<pv> drainStatus;
    transient Set<K> keySet;
    transient Collection<V> values;
    transient Set<Map.Entry<K, V>> entrySet;
    static final long serialVersionUID = 1L;

    static int ceilingNextPowerOfTwo(int n2) {
        return 1 << 32 - Integer.numberOfLeadingZeros(n2 - 1);
    }

    private static int readBufferIndex(int n2, int n3) {
        return (n2 << 4) + n3;
    }

    ps(pu<K, V> pu2) {
        this.concurrencyLevel = pu2.concurrencyLevel;
        this.capacity = new AtomicLong(Math.min(pu2.capacity, 9223372034707292160L));
        this.data = new ConcurrentHashMap<K, pA<K, V>>(pu2.initialCapacity, 0.75f, this.concurrencyLevel);
        this.evictionLock = new ReentrantLock();
        this.weightedSize = new AtomicLong();
        this.evictionDeque = new pq();
        this.writeBuffer = new ConcurrentLinkedQueue<Runnable>();
        this.drainStatus = new AtomicReference<pv>(pv.IDLE);
        this.readBufferReadCount = new long[NUMBER_OF_READ_BUFFERS];
        this.readBufferWriteCount = new AtomicLongArray(NUMBER_OF_READ_BUFFERS);
        this.readBufferDrainAtWriteCount = new AtomicLongArray(NUMBER_OF_READ_BUFFERS);
        this.readBuffers = new AtomicReferenceArray(NUMBER_OF_READ_BUFFERS << 4);
    }

    static void checkNotNull(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
    }

    static void checkArgument(boolean bl2) {
        if (!bl2) {
            throw new IllegalArgumentException();
        }
    }

    static void checkState(boolean bl2) {
        if (!bl2) {
            throw new IllegalStateException();
        }
    }

    public final long capacity() {
        return this.capacity.get();
    }

    public final void setCapacity(long l2) {
        ps.checkArgument(l2 >= 0L);
        this.evictionLock.lock();
        try {
            this.capacity.lazySet(Math.min(l2, 9223372034707292160L));
            this.drainBuffers();
            this.evict();
            return;
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    final boolean hasOverflowed() {
        return this.weightedSize.get() > this.capacity.get();
    }

    final void evict() {
        while (this.hasOverflowed()) {
            pA pA2 = (pA)this.evictionDeque.poll();
            if (pA2 == null) {
                return;
            }
            this.data.remove(pA2.key, pA2);
            this.makeDead(pA2);
        }
    }

    final void afterRead(pA<K, V> pA2) {
        int n2 = ps.readBufferIndex();
        long l2 = this.recordRead(n2, pA2);
        this.drainOnReadIfNeeded(n2, l2);
    }

    static int readBufferIndex() {
        return (int)Thread.currentThread().getId() & READ_BUFFERS_MASK;
    }

    final long recordRead(int n2, pA<K, V> pA2) {
        long l2 = this.readBufferWriteCount.get(n2);
        this.readBufferWriteCount.lazySet(n2, l2 + 1L);
        int n3 = (int)(l2 & 0xFL);
        this.readBuffers.lazySet(ps.readBufferIndex(n2, n3), pA2);
        return l2;
    }

    final void drainOnReadIfNeeded(int n2, long l2) {
        int n3 = n2 = l2 - this.readBufferDrainAtWriteCount.get(n2) < 4L ? 1 : 0;
        if (this.drainStatus.get().shouldDrainBuffers(n2 != 0)) {
            this.tryToDrainBuffers();
        }
    }

    final void afterWrite(Runnable runnable) {
        this.writeBuffer.add(runnable);
        this.drainStatus.lazySet(pv.REQUIRED);
        this.tryToDrainBuffers();
    }

    final void tryToDrainBuffers() {
        if (this.evictionLock.tryLock()) {
            try {
                this.drainStatus.lazySet(pv.PROCESSING);
                this.drainBuffers();
                return;
            }
            finally {
                this.drainStatus.compareAndSet(pv.PROCESSING, pv.IDLE);
                this.evictionLock.unlock();
            }
        }
    }

    final void drainBuffers() {
        this.drainReadBuffers();
        this.drainWriteBuffer();
    }

    final void drainReadBuffers() {
        int n2;
        int n3 = n2 + NUMBER_OF_READ_BUFFERS;
        for (n2 = (int)Thread.currentThread().getId(); n2 < n3; ++n2) {
            this.drainReadBuffer(n2 & READ_BUFFERS_MASK);
        }
    }

    final void drainReadBuffer(int n2) {
        long l2 = this.readBufferWriteCount.get(n2);
        for (int i2 = 0; i2 < 8; ++i2) {
            int n3 = (int)(this.readBufferReadCount[n2] & 0xFL);
            pA<K, V> pA2 = this.readBuffers.get(n3 = ps.readBufferIndex(n2, n3));
            if (pA2 == null) break;
            this.readBuffers.lazySet(n3, null);
            this.applyRead(pA2);
            int n4 = n2;
            this.readBufferReadCount[n4] = this.readBufferReadCount[n4] + 1L;
        }
        this.readBufferDrainAtWriteCount.lazySet(n2, l2);
    }

    final void applyRead(pA<K, V> pA2) {
        if (this.evictionDeque.contains(pA2)) {
            this.evictionDeque.moveToBack(pA2);
        }
    }

    final void drainWriteBuffer() {
        Runnable runnable;
        for (int i2 = 0; i2 < 16 && (runnable = this.writeBuffer.poll()) != null; ++i2) {
            runnable.run();
        }
    }

    final boolean tryToRetire(pA<K, V> pA2, pG<V> pG2) {
        if (pG2.isAlive()) {
            pG pG3 = new pG(pG2.value, -pG2.weight);
            return pA2.compareAndSet(pG2, pG3);
        }
        return false;
    }

    final void makeRetired(pA<K, V> pA2) {
        pG pG2;
        pG pG3;
        do {
            if ((pG3 = (pG)pA2.get()).isAlive()) continue;
            return;
        } while (!pA2.compareAndSet(pG3, pG2 = new pG(pG3.value, -pG3.weight)));
    }

    final void makeDead(pA<K, V> pA2) {
        pG pG2;
        pG pG3;
        while (!pA2.compareAndSet(pG3 = (pG)pA2.get(), pG2 = new pG(pG3.value, 0))) {
        }
        this.weightedSize.lazySet(this.weightedSize.get() - (long)Math.abs(pG3.weight));
    }

    @Override
    public final boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public final int size() {
        return this.data.size();
    }

    @Override
    public final void clear() {
        this.evictionLock.lock();
        try {
            Runnable runnable;
            pA pA2;
            while ((pA2 = (pA)this.evictionDeque.poll()) != null) {
                this.data.remove(pA2.key, pA2);
                this.makeDead(pA2);
            }
            for (int i2 = 0; i2 < this.readBuffers.length(); ++i2) {
                this.readBuffers.lazySet(i2, null);
            }
            while ((runnable = this.writeBuffer.poll()) != null) {
                runnable.run();
            }
            return;
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    @Override
    public final boolean containsKey(Object object) {
        return this.data.containsKey(object);
    }

    @Override
    public final boolean containsValue(Object object) {
        ps.checkNotNull(object);
        Iterator iterator = this.data.values().iterator();
        while (iterator.hasNext()) {
            if (!((pA)iterator.next()).getValue().equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final V get(Object object) {
        if ((object = (pA)this.data.get(object)) == null) {
            return null;
        }
        this.afterRead((pA<K, V>)object);
        return ((pA)object).getValue();
    }

    @Override
    public final V put(K k2, V v2) {
        return this.put(k2, v2, false);
    }

    @Override
    public final V putIfAbsent(K k2, V v2) {
        return this.put(k2, v2, true);
    }

    final V put(K object, V object2, boolean bl2) {
        pG pG2;
        pA<K, pG> pA2;
        ps.checkNotNull(object);
        ps.checkNotNull(object2);
        object2 = new pG<V>(object2, 1);
        object = new pA(object, object2);
        block0: while (true) {
            if ((pA2 = this.data.putIfAbsent(((pA)object).key, object)) == null) {
                this.afterWrite(new pt(this, (pA)object, 1));
                return null;
            }
            if (bl2) {
                this.afterRead(pA2);
                return pA2.getValue();
            }
            do {
                if (!(pG2 = (pG)pA2.get()).isAlive()) continue block0;
            } while (!pA2.compareAndSet(pG2, (pG)object2));
            break;
        }
        int n2 = 1 - pG2.weight;
        if (n2 == 0) {
            this.afterRead(pA2);
        } else {
            this.afterWrite(new pD(this, pA2, n2));
        }
        return pG2.value;
    }

    @Override
    public final V remove(Object object) {
        if ((object = (pA)this.data.remove(object)) == null) {
            return null;
        }
        this.makeRetired((pA<K, V>)object);
        this.afterWrite(new pB(this, (pA)object));
        return ((pA)object).getValue();
    }

    @Override
    public final boolean remove(Object object, Object object2) {
        pA pA2 = (pA)this.data.get(object);
        if (pA2 == null || object2 == null) {
            return false;
        }
        pG pG2 = (pG)pA2.get();
        while (pG2.contains(object2)) {
            if (this.tryToRetire(pA2, pG2)) {
                if (!this.data.remove(object, pA2)) break;
                this.afterWrite(new pB(this, pA2));
                return true;
            }
            pG2 = (pG)pA2.get();
            if (pG2.isAlive()) continue;
        }
        return false;
    }

    @Override
    public final V replace(K object, V object2) {
        pG pG2;
        ps.checkNotNull(object);
        ps.checkNotNull(object2);
        object2 = new pG<V>(object2, 1);
        object = (pA)this.data.get(object);
        if (object == null) {
            return null;
        }
        do {
            if ((pG2 = (pG)((AtomicReference)object).get()).isAlive()) continue;
            return null;
        } while (!((AtomicReference)object).compareAndSet(pG2, object2));
        int n2 = 1 - pG2.weight;
        if (n2 == 0) {
            this.afterRead((pA<K, V>)object);
        } else {
            this.afterWrite(new pD(this, (pA)object, n2));
        }
        return pG2.value;
    }

    @Override
    public final boolean replace(K object, V v2, V object2) {
        pG pG2;
        ps.checkNotNull(object);
        ps.checkNotNull(v2);
        ps.checkNotNull(object2);
        object2 = new pG<V>(object2, 1);
        object = (pA)this.data.get(object);
        if (object == null) {
            return false;
        }
        do {
            if ((pG2 = (pG)((AtomicReference)object).get()).isAlive() && pG2.contains(v2)) continue;
            return false;
        } while (!((AtomicReference)object).compareAndSet(pG2, object2));
        int n2 = 1 - pG2.weight;
        if (n2 == 0) {
            this.afterRead((pA<K, V>)object);
        } else {
            this.afterWrite(new pD(this, (pA)object, n2));
        }
        return true;
    }

    @Override
    public final Set<K> keySet() {
        Set<K> set = this.keySet;
        if (set == null) {
            this.keySet = new pz(this);
            return this.keySet;
        }
        return set;
    }

    @Override
    public final Collection<V> values() {
        Collection<V> collection = this.values;
        if (collection == null) {
            this.values = new pF(this);
            return this.values;
        }
        return collection;
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> set = this.entrySet;
        if (set == null) {
            this.entrySet = new px(this);
            return this.entrySet;
        }
        return set;
    }

    final Object writeReplace() {
        return new pC(this);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        throw new InvalidObjectException("Proxy required");
    }
}

