/*
 * Decompiled with CFR 0.152.
 */
package liquibase.pro.packaged;

import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import liquibase.pro.packaged.as;
import liquibase.pro.packaged.ay;
import liquibase.pro.packaged.az;
import liquibase.pro.packaged.dC;
import liquibase.pro.packaged.dG;
import liquibase.pro.packaged.dJ;
import liquibase.pro.packaged.eJ;
import liquibase.pro.packaged.eh;
import liquibase.pro.packaged.ev;
import liquibase.pro.packaged.oH;
import liquibase.pro.packaged.oI;
import liquibase.pro.packaged.oO;
import liquibase.pro.packaged.oX;

public final class oG {
    private static final Class<?> CLS_OBJECT = Object.class;
    private static final Annotation[] NO_ANNOTATIONS = new Annotation[0];
    private static final oH[] NO_CTORS = new oH[0];
    private static final Iterator<?> EMPTY_ITERATOR = Collections.emptyIterator();

    public static <T> Iterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static List<dG> findSuperTypes(dG dG2, Class<?> clazz, boolean bl2) {
        if (dG2 == null || dG2.hasRawClass(clazz) || dG2.hasRawClass(Object.class)) {
            return Collections.emptyList();
        }
        ArrayList<dG> arrayList = new ArrayList<dG>(8);
        oG._addSuperTypes(dG2, clazz, arrayList, bl2);
        return arrayList;
    }

    public static List<Class<?>> findRawSuperTypes(Class<?> clazz, Class<?> clazz2, boolean bl2) {
        if (clazz == null || clazz == clazz2 || clazz == Object.class) {
            return Collections.emptyList();
        }
        ArrayList arrayList = new ArrayList(8);
        oG._addRawSuperTypes(clazz, clazz2, arrayList, bl2);
        return arrayList;
    }

    public static List<Class<?>> findSuperClasses(Class<?> clazz, Class<?> clazz2, boolean bl2) {
        ArrayList arrayList = new ArrayList(8);
        if (clazz != null && clazz != clazz2) {
            if (bl2) {
                arrayList.add(clazz);
            }
            while ((clazz = clazz.getSuperclass()) != null && clazz != clazz2) {
                arrayList.add(clazz);
            }
        }
        return arrayList;
    }

    @Deprecated
    public static List<Class<?>> findSuperTypes(Class<?> clazz, Class<?> clazz2) {
        return oG.findSuperTypes(clazz, clazz2, new ArrayList(8));
    }

    @Deprecated
    public static List<Class<?>> findSuperTypes(Class<?> clazz, Class<?> clazz2, List<Class<?>> list) {
        oG._addRawSuperTypes(clazz, clazz2, list, false);
        return list;
    }

    private static void _addSuperTypes(dG dG2, Class<?> clazz, Collection<dG> collection, boolean bl2) {
        while (dG2 != null) {
            Class<?> clazz2 = dG2.getRawClass();
            if (clazz2 == clazz || clazz2 == Object.class) {
                return;
            }
            if (bl2) {
                if (collection.contains(dG2)) {
                    return;
                }
                collection.add(dG2);
            }
            Iterator<dG> iterator = dG2.getInterfaces().iterator();
            while (iterator.hasNext()) {
                oG._addSuperTypes(iterator.next(), clazz, collection, true);
            }
            bl2 = true;
            dG2 = dG2.getSuperClass();
        }
        return;
    }

    private static void _addRawSuperTypes(Class<?> clazz, Class<?> clazz2, Collection<Class<?>> collection, boolean bl2) {
        while (clazz != clazz2 && clazz != null && clazz != Object.class) {
            if (bl2) {
                if (collection.contains(clazz)) {
                    return;
                }
                collection.add(clazz);
            }
            Class<?>[] classArray = oG._interfaces(clazz);
            int n2 = classArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                oG._addRawSuperTypes(classArray[i2], clazz2, collection, true);
            }
            bl2 = true;
            clazz = clazz.getSuperclass();
        }
        return;
    }

    public static String canBeABeanType(Class<?> clazz) {
        if (clazz.isAnnotation()) {
            return "annotation";
        }
        if (clazz.isArray()) {
            return "array";
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return "enum";
        }
        if (clazz.isPrimitive()) {
            return "primitive";
        }
        return null;
    }

    public static String isLocalType(Class<?> clazz, boolean bl2) {
        try {
            boolean bl3 = Modifier.isStatic(clazz.getModifiers());
            if (!bl3 && oG.hasEnclosingMethod(clazz)) {
                return "local/anonymous";
            }
            if (!bl2 && !bl3 && oG.getEnclosingClass(clazz) != null) {
                return "non-static member class";
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NullPointerException nullPointerException) {}
        return null;
    }

    public static Class<?> getOuterClass(Class<?> clazz) {
        if (!Modifier.isStatic(clazz.getModifiers())) {
            try {
                if (oG.hasEnclosingMethod(clazz)) {
                    return null;
                }
                return oG.getEnclosingClass(clazz);
            }
            catch (SecurityException securityException) {}
        }
        return null;
    }

    public static boolean isProxyType(Class<?> object) {
        return ((String)(object = ((Class)object).getName())).startsWith("net.sf.cglib.proxy.") || ((String)object).startsWith("org.hibernate.proxy.");
    }

    public static boolean isConcrete(Class<?> clazz) {
        return (clazz.getModifiers() & 0x600) == 0;
    }

    public static boolean isConcrete(Member member) {
        return (member.getModifiers() & 0x600) == 0;
    }

    public static boolean isCollectionMapOrArray(Class<?> clazz) {
        if (clazz.isArray()) {
            return true;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return true;
        }
        return Map.class.isAssignableFrom(clazz);
    }

    public static boolean isBogusClass(Class<?> clazz) {
        return clazz == Void.class || clazz == Void.TYPE || clazz == eJ.class;
    }

    public static boolean isRecordType(Class<?> clazz) {
        return (clazz = clazz.getSuperclass()) != null && "java.lang.Record".equals(clazz.getName());
    }

    public static boolean isObjectOrPrimitive(Class<?> clazz) {
        return clazz == CLS_OBJECT || clazz.isPrimitive();
    }

    public static boolean hasClass(Object object, Class<?> clazz) {
        return object != null && object.getClass() == clazz;
    }

    public static void verifyMustOverride(Class<?> clazz, Object object, String string) {
        if (object.getClass() != clazz) {
            throw new IllegalStateException(String.format("Sub-class %s (of class %s) must override method '%s'", object.getClass().getName(), clazz.getName(), string));
        }
    }

    @Deprecated
    public static boolean hasGetterSignature(Method method) {
        if (Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray != null && classArray.length != 0) {
            return false;
        }
        return Void.TYPE != method.getReturnType();
    }

    public static Throwable throwIfError(Throwable throwable) {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        return throwable;
    }

    public static Throwable throwIfRTE(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        return throwable;
    }

    public static Throwable throwIfIOE(Throwable throwable) {
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        return throwable;
    }

    public static Throwable getRootCause(Throwable throwable) {
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return throwable;
    }

    public static Throwable throwRootCauseIfIOE(Throwable throwable) {
        return oG.throwIfIOE(oG.getRootCause(throwable));
    }

    public static void throwAsIAE(Throwable throwable) {
        Throwable throwable2 = throwable;
        oG.throwAsIAE(throwable2, throwable2.getMessage());
    }

    public static void throwAsIAE(Throwable throwable, String string) {
        oG.throwIfRTE(throwable);
        oG.throwIfError(throwable);
        throw new IllegalArgumentException(string, throwable);
    }

    public static <T> T throwAsMappingException(dC dC2, IOException iOException) {
        if (iOException instanceof dJ) {
            throw (dJ)iOException;
        }
        throw dJ.from(dC2, iOException.getMessage()).withCause(iOException);
    }

    public static void unwrapAndThrowAsIAE(Throwable throwable) {
        oG.throwAsIAE(oG.getRootCause(throwable));
    }

    public static void unwrapAndThrowAsIAE(Throwable throwable, String string) {
        oG.throwAsIAE(oG.getRootCause(throwable), string);
    }

    public static void closeOnFailAndThrowAsIOE(ay ay2, Exception exception) {
        ay2.disable(az.AUTO_CLOSE_JSON_CONTENT);
        try {
            ay2.close();
        }
        catch (Exception exception2) {
            exception.addSuppressed(exception2);
        }
        oG.throwIfIOE(exception);
        oG.throwIfRTE(exception);
        throw new RuntimeException(exception);
    }

    public static void closeOnFailAndThrowAsIOE(ay ay2, Closeable closeable, Exception exception) {
        if (ay2 != null) {
            ay2.disable(az.AUTO_CLOSE_JSON_CONTENT);
            try {
                ay2.close();
            }
            catch (Exception exception2) {
                exception.addSuppressed(exception2);
            }
        }
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception3) {
                exception.addSuppressed(exception3);
            }
        }
        oG.throwIfIOE(exception);
        oG.throwIfRTE(exception);
        throw new RuntimeException(exception);
    }

    public static <T> T createInstance(Class<T> clazz, boolean bl2) {
        Constructor<T> constructor = oG.findConstructor(clazz, bl2);
        if (constructor == null) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " has no default (no arg) constructor");
        }
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            constructor = exception;
            oG.unwrapAndThrowAsIAE(exception, "Failed to instantiate class " + clazz.getName() + ", problem: " + ((Throwable)((Object)constructor)).getMessage());
            return null;
        }
    }

    public static <T> Constructor<T> findConstructor(Class<T> clazz, boolean bl2) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            if (bl2) {
                oG.checkAndFixAccess(constructor, bl2);
            } else if (!Modifier.isPublic(constructor.getModifiers())) {
                throw new IllegalArgumentException("Default constructor for " + clazz.getName() + " is not accessible (non-public?): not allowed to try modify access via Reflection: cannot instantiate type");
            }
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            oG.unwrapAndThrowAsIAE(exception, "Failed to find default constructor of class " + clazz.getName() + ", problem: " + exception2.getMessage());
        }
        return null;
    }

    public static Class<?> classOf(Object object) {
        if (object == null) {
            return null;
        }
        return object.getClass();
    }

    public static Class<?> rawClass(dG dG2) {
        if (dG2 == null) {
            return null;
        }
        return dG2.getRawClass();
    }

    public static <T> T nonNull(T t2, T t3) {
        if (t2 == null) {
            return t3;
        }
        return t2;
    }

    public static String nullOrToString(Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public static String nonNullString(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    public static String quotedOr(Object object, String string) {
        if (object == null) {
            return string;
        }
        return String.format("\"%s\"", object);
    }

    public static String getClassDescription(Object object) {
        if (object == null) {
            return "unknown";
        }
        return oG.nameOf(object instanceof Class ? (Class<?>)object : object.getClass());
    }

    public static String getTypeDescription(dG dG2) {
        if (dG2 == null) {
            return "[null]";
        }
        StringBuilder stringBuilder = new StringBuilder(80).append('`');
        stringBuilder.append(dG2.toCanonical());
        return stringBuilder.append('`').toString();
    }

    public static String classNameOf(Object object) {
        if (object == null) {
            return "[null]";
        }
        return oG.nameOf(object instanceof Class ? (Class<?>)object : object.getClass());
    }

    public static String nameOf(Class<?> object) {
        if (object == null) {
            return "[null]";
        }
        int n2 = 0;
        while (((Class)object).isArray()) {
            ++n2;
            object = ((Class)object).getComponentType();
        }
        Object object2 = object = ((Class)object).isPrimitive() ? ((Class)object).getSimpleName() : ((Class)object).getName();
        if (n2 > 0) {
            object = new StringBuilder((String)object);
            do {
                ((StringBuilder)object).append("[]");
            } while (--n2 > 0);
            object = ((StringBuilder)object).toString();
        }
        return oG.backticked((String)object);
    }

    public static String nameOf(oX oX2) {
        if (oX2 == null) {
            return "[null]";
        }
        return oG.apostrophed(oX2.getName());
    }

    public static String name(String string) {
        if (string == null) {
            return "[null]";
        }
        return oG.apostrophed(string);
    }

    public static String name(eh eh2) {
        if (eh2 == null) {
            return "[null]";
        }
        return oG.apostrophed(eh2.getSimpleName());
    }

    public static String backticked(String string) {
        if (string == null) {
            return "[null]";
        }
        return new StringBuilder(string.length() + 2).append('`').append(string).append('`').toString();
    }

    public static String apostrophed(String string) {
        if (string == null) {
            return "[null]";
        }
        return new StringBuilder(string.length() + 2).append('\'').append(string).append('\'').toString();
    }

    public static String exceptionMessage(Throwable throwable) {
        if (throwable instanceof as) {
            return ((as)throwable).getOriginalMessage();
        }
        if (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
            return throwable.getCause().getMessage();
        }
        return throwable.getMessage();
    }

    public static Object defaultValue(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return 0;
        }
        if (clazz == Long.TYPE) {
            return 0L;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (clazz == Double.TYPE) {
            return 0.0;
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (clazz == Byte.TYPE) {
            return (byte)0;
        }
        if (clazz == Short.TYPE) {
            return (short)0;
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        throw new IllegalArgumentException("Class " + clazz.getName() + " is not a primitive type");
    }

    public static Class<?> wrapperType(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        throw new IllegalArgumentException("Class " + clazz.getName() + " is not a primitive type");
    }

    public static Class<?> primitiveType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Character.class) {
            return Character.TYPE;
        }
        return null;
    }

    @Deprecated
    public static void checkAndFixAccess(Member member) {
        oG.checkAndFixAccess(member, false);
    }

    public static void checkAndFixAccess(Member member, boolean bl2) {
        AccessibleObject accessibleObject = (AccessibleObject)((Object)member);
        try {
            Class<?> clazz = member.getDeclaringClass();
            if (!(Modifier.isPublic(member.getModifiers()) && Modifier.isPublic(clazz.getModifiers())) || bl2 && !oG.isJDKClass(clazz)) {
                accessibleObject.setAccessible(true);
            }
            return;
        }
        catch (SecurityException securityException) {
            if (!accessibleObject.isAccessible()) {
                Class<?> clazz = member.getDeclaringClass();
                throw new IllegalArgumentException("Cannot access " + member + " (from class " + clazz.getName() + "; failed to set access: " + securityException.getMessage());
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            if ("InaccessibleObjectException".equals(runtimeException.getClass().getSimpleName())) {
                throw new IllegalArgumentException(String.format("Failed to call `setAccess()` on %s '%s' (of class %s) due to `%s`, problem: %s", member.getClass().getSimpleName(), member.getName(), oG.nameOf(member.getDeclaringClass()), runtimeException.getClass().getName(), runtimeException.getMessage()), runtimeException);
            }
            throw runtimeException;
        }
    }

    public static boolean isEnumType(Class<?> clazz) {
        return Enum.class.isAssignableFrom(clazz);
    }

    public static Class<? extends Enum<?>> findEnumType(EnumSet<?> enumSet) {
        if (!enumSet.isEmpty()) {
            return oG.findEnumType((Enum)enumSet.iterator().next());
        }
        return oI.instance.enumTypeFor(enumSet);
    }

    public static Class<? extends Enum<?>> findEnumType(EnumMap<?, ?> enumMap) {
        if (!enumMap.isEmpty()) {
            return oG.findEnumType((Enum)enumMap.keySet().iterator().next());
        }
        return oI.instance.enumTypeFor(enumMap);
    }

    public static Class<? extends Enum<?>> findEnumType(Enum<?> enum_) {
        return enum_.getDeclaringClass();
    }

    public static Class<? extends Enum<?>> findEnumType(Class<?> clazz) {
        if (clazz.getSuperclass() != Enum.class) {
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }

    public static <T extends Annotation> Enum<?> findFirstAnnotatedEnumValue(Class<Enum<?>> clazz, Class<T> clazz2) {
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.isEnumConstant() || field.getAnnotation(clazz2) == null) continue;
            String string = field.getName();
            for (Enum<?> enum_ : clazz.getEnumConstants()) {
                if (!string.equals(enum_.name())) continue;
                return enum_;
            }
        }
        return null;
    }

    public static boolean isJacksonStdImpl(Object object) {
        return object == null || oG.isJacksonStdImpl(object.getClass());
    }

    public static boolean isJacksonStdImpl(Class<?> clazz) {
        return clazz.getAnnotation(ev.class) != null;
    }

    public static boolean isJDKClass(Class<?> object) {
        return ((String)(object = ((Class)object).getName())).startsWith("java.") || ((String)object).startsWith("javax.");
    }

    public static boolean isJDK17OrAbove() {
        try {
            return oG.getJDKMajorVersion() >= 17;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            oO.rethrowIfFatal(throwable);
            System.err.println("Failed to determine JDK major version, assuming pre-JDK-17; problem: ".concat(String.valueOf(throwable2)));
            return false;
        }
    }

    public static int getJDKMajorVersion() {
        String string;
        try {
            string = System.getProperty("java.version");
        }
        catch (SecurityException securityException) {
            throw new IllegalStateException("Could not access 'java.version': cannot determine JDK major version");
        }
        if (string.startsWith("1.")) {
            return 8;
        }
        int n2 = string.indexOf(".");
        String string2 = n2 < 0 ? string : string.substring(0, n2);
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalStateException("Invalid JDK version String '" + string + "' cannot determine JDK major version");
        }
    }

    public static boolean isNonStaticInnerClass(Class<?> clazz) {
        return !Modifier.isStatic(clazz.getModifiers()) && oG.getEnclosingClass(clazz) != null;
    }

    @Deprecated
    public static String getPackageName(Class<?> annotatedElement) {
        if ((annotatedElement = ((Class)annotatedElement).getPackage()) == null) {
            return null;
        }
        return ((Package)annotatedElement).getName();
    }

    public static boolean hasEnclosingMethod(Class<?> clazz) {
        return !oG.isObjectOrPrimitive(clazz) && clazz.getEnclosingMethod() != null;
    }

    @Deprecated
    public static Field[] getDeclaredFields(Class<?> clazz) {
        return clazz.getDeclaredFields();
    }

    @Deprecated
    public static Method[] getDeclaredMethods(Class<?> clazz) {
        return clazz.getDeclaredMethods();
    }

    public static Annotation[] findClassAnnotations(Class<?> clazz) {
        if (oG.isObjectOrPrimitive(clazz)) {
            return NO_ANNOTATIONS;
        }
        return clazz.getDeclaredAnnotations();
    }

    public static Method[] getClassMethods(Class<?> clazz) {
        try {
            return clazz.getDeclaredMethods();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            Object object = Thread.currentThread().getContextClassLoader();
            if (object == null) {
                return oG._failGetClassMethods(clazz, noClassDefFoundError);
            }
            try {
                object = ((ClassLoader)object).loadClass(clazz.getName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                noClassDefFoundError.addSuppressed(classNotFoundException);
                return oG._failGetClassMethods(clazz, noClassDefFoundError);
            }
            try {
                return ((Class)object).getDeclaredMethods();
            }
            catch (Exception exception) {
                return oG._failGetClassMethods(clazz, exception);
            }
        }
        catch (Exception exception) {
            return oG._failGetClassMethods(clazz, exception);
        }
    }

    private static Method[] _failGetClassMethods(Class<?> clazz, Throwable throwable) {
        throw new IllegalArgumentException(String.format("Failed on call to `getDeclaredMethods()` on class `%s`, problem: (%s) %s", clazz.getName(), throwable.getClass().getName(), throwable.getMessage()), throwable);
    }

    public static oH[] getConstructors(Class<?> constructorArray) {
        if (constructorArray.isInterface() || oG.isObjectOrPrimitive(constructorArray)) {
            return NO_CTORS;
        }
        constructorArray = constructorArray.getDeclaredConstructors();
        int n2 = constructorArray.length;
        oH[] oHArray = new oH[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            oHArray[i2] = new oH(constructorArray[i2]);
        }
        return oHArray;
    }

    public static Class<?> getDeclaringClass(Class<?> clazz) {
        if (oG.isObjectOrPrimitive(clazz)) {
            return null;
        }
        return clazz.getDeclaringClass();
    }

    public static Type getGenericSuperclass(Class<?> clazz) {
        return clazz.getGenericSuperclass();
    }

    public static Type[] getGenericInterfaces(Class<?> clazz) {
        return clazz.getGenericInterfaces();
    }

    public static Class<?> getEnclosingClass(Class<?> clazz) {
        if (oG.isObjectOrPrimitive(clazz)) {
            return null;
        }
        return clazz.getEnclosingClass();
    }

    private static Class<?>[] _interfaces(Class<?> clazz) {
        return clazz.getInterfaces();
    }
}

