/*
 * Decompiled with CFR 0.152.
 */
package liquibase.pro.packaged;

import java.io.OutputStream;
import java.util.LinkedList;
import liquibase.pro.packaged.cV;

public final class cX
extends OutputStream {
    public static final byte[] NO_BYTES = new byte[0];
    private static final int INITIAL_BLOCK_SIZE = 500;
    private static final int MAX_BLOCK_SIZE = 131072;
    static final int DEFAULT_BLOCK_ARRAY_SIZE = 40;
    private final cV _bufferRecycler;
    private final LinkedList<byte[]> _pastBlocks = new LinkedList();
    private int _pastLen;
    private byte[] _currBlock;
    private int _currBlockPtr;

    public cX() {
        this(null);
    }

    public cX(cV cV2) {
        this(cV2, 500);
    }

    public cX(int n2) {
        this(null, n2);
    }

    public cX(cV cV2, int n2) {
        this._bufferRecycler = cV2;
        if (n2 > 131072) {
            n2 = 131072;
        }
        this._currBlock = cV2 == null ? new byte[n2] : cV2.allocByteBuffer(2);
    }

    private cX(cV cV2, byte[] byArray, int n2) {
        this._bufferRecycler = null;
        this._currBlock = byArray;
        this._currBlockPtr = n2;
    }

    public static cX fromInitial(byte[] byArray, int n2) {
        return new cX(null, byArray, n2);
    }

    public final void reset() {
        this._pastLen = 0;
        this._currBlockPtr = 0;
        if (!this._pastBlocks.isEmpty()) {
            this._pastBlocks.clear();
        }
    }

    public final int size() {
        return this._pastLen + this._currBlockPtr;
    }

    public final void release() {
        this.reset();
        if (this._bufferRecycler != null && this._currBlock != null) {
            this._bufferRecycler.releaseByteBuffer(2, this._currBlock);
            this._currBlock = null;
        }
    }

    public final void append(int n2) {
        if (this._currBlockPtr >= this._currBlock.length) {
            this._allocMore();
        }
        this._currBlock[this._currBlockPtr++] = (byte)n2;
    }

    public final void appendTwoBytes(int n2) {
        if (this._currBlockPtr + 1 < this._currBlock.length) {
            this._currBlock[this._currBlockPtr++] = (byte)(n2 >> 8);
            this._currBlock[this._currBlockPtr++] = (byte)n2;
            return;
        }
        this.append(n2 >> 8);
        this.append(n2);
    }

    public final void appendThreeBytes(int n2) {
        if (this._currBlockPtr + 2 < this._currBlock.length) {
            this._currBlock[this._currBlockPtr++] = (byte)(n2 >> 16);
            this._currBlock[this._currBlockPtr++] = (byte)(n2 >> 8);
            this._currBlock[this._currBlockPtr++] = (byte)n2;
            return;
        }
        this.append(n2 >> 16);
        this.append(n2 >> 8);
        this.append(n2);
    }

    public final void appendFourBytes(int n2) {
        if (this._currBlockPtr + 3 < this._currBlock.length) {
            this._currBlock[this._currBlockPtr++] = (byte)(n2 >> 24);
            this._currBlock[this._currBlockPtr++] = (byte)(n2 >> 16);
            this._currBlock[this._currBlockPtr++] = (byte)(n2 >> 8);
            this._currBlock[this._currBlockPtr++] = (byte)n2;
            return;
        }
        this.append(n2 >> 24);
        this.append(n2 >> 16);
        this.append(n2 >> 8);
        this.append(n2);
    }

    public final byte[] toByteArray() {
        int n2 = this._pastLen + this._currBlockPtr;
        if (n2 == 0) {
            return NO_BYTES;
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (byte[] byArray2 : this._pastBlocks) {
            int n4 = byArray2.length;
            System.arraycopy(byArray2, 0, byArray, n3, n4);
            n3 += n4;
        }
        System.arraycopy(this._currBlock, 0, byArray, n3, this._currBlockPtr);
        if ((n3 += this._currBlockPtr) != n2) {
            throw new RuntimeException("Internal error: total len assumed to be " + n2 + ", copied " + n3 + " bytes");
        }
        if (!this._pastBlocks.isEmpty()) {
            this.reset();
        }
        return byArray;
    }

    public final byte[] resetAndGetFirstSegment() {
        this.reset();
        return this._currBlock;
    }

    public final byte[] finishCurrentSegment() {
        this._allocMore();
        return this._currBlock;
    }

    public final byte[] completeAndCoalesce(int n2) {
        this._currBlockPtr = n2;
        return this.toByteArray();
    }

    public final byte[] getCurrentSegment() {
        return this._currBlock;
    }

    public final void setCurrentSegmentLength(int n2) {
        this._currBlockPtr = n2;
    }

    public final int getCurrentSegmentLength() {
        return this._currBlockPtr;
    }

    @Override
    public final void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public final void write(byte[] byArray, int n2, int n3) {
        while (true) {
            int n4;
            if ((n4 = Math.min(this._currBlock.length - this._currBlockPtr, n3)) > 0) {
                System.arraycopy(byArray, n2, this._currBlock, this._currBlockPtr, n4);
                n2 += n4;
                this._currBlockPtr += n4;
                n3 -= n4;
            }
            if (n3 <= 0) break;
            this._allocMore();
        }
    }

    @Override
    public final void write(int n2) {
        this.append(n2);
    }

    @Override
    public final void close() {
    }

    @Override
    public final void flush() {
    }

    private void _allocMore() {
        int n2 = this._pastLen + this._currBlock.length;
        if (n2 < 0) {
            throw new IllegalStateException("Maximum Java array size (2GB) exceeded by `ByteArrayBuilder`");
        }
        this._pastLen = n2;
        n2 = Math.max(this._pastLen >> 1, 1000);
        if (n2 > 131072) {
            n2 = 131072;
        }
        this._pastBlocks.add(this._currBlock);
        this._currBlock = new byte[n2];
        this._currBlockPtr = 0;
    }
}

