/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.storedproc;

import com.datical.liquibase.ext.storedlogic.AbstractUnexpectedStoredLogicChangeGenerator;
import liquibase.change.Change;
import liquibase.change.core.DropProcedureChange;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.StoredProcedure;

public class UnexpectedStoredProcedureChangeGenerator
extends AbstractUnexpectedStoredLogicChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (StoredProcedure.class.isAssignableFrom(clazz)) {
            return 101;
        }
        return -1;
    }

    public Change[] fixUnexpected(DatabaseObject databaseObject, DiffOutputControl diffOutputControl, Database database, Database database2, ChangeGeneratorChain changeGeneratorChain) {
        database = new DropProcedureChange();
        if (diffOutputControl.getIncludeCatalog()) {
            database.setCatalogName(databaseObject.getSchema().getCatalogName());
        }
        if (diffOutputControl.getIncludeSchema()) {
            database.setSchemaName(databaseObject.getSchema().getName());
        }
        database.setProcedureName(databaseObject.getName());
        return new Change[]{database};
    }
}

