/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.reports;

import com.datical.liquibase.ext.config.DriftConfiguration;
import com.datical.liquibase.ext.reports.DatabaseObjectReportValue;
import java.util.Date;
import java.util.List;
import liquibase.database.jvm.JdbcConnection;

public class DriftReportParameters {
    private final String reportName;
    private final Date date;
    private final String targetUrl;
    private final String sourceUrl;
    private final String createdByUser;
    private final String hostName;
    private final List<DatabaseObjectReportValue> missing;
    private final List<DatabaseObjectReportValue> unexpected;
    private final List<DatabaseObjectReportValue> changed;
    private final String jsonMissing;
    private final String jsonUnexpected;
    private final String jsonChanged;
    private final String numberMissing;
    private final String numberUnexpected;
    private final String numberChanged;
    private final boolean showMissing;
    private final boolean showUnexpected;
    private final boolean showChanged;
    private final String path;
    private final String commandArgs;
    private final String reportMode;
    private final String reportNameParameterName;
    private final String reportPathParameterName;
    private final String reportFormatParameterName;
    private final String visibleTargetUrl;
    private final String visibleSourceUrl;

    public DriftReportParameters(String string, String string2, String string3, String string4, String string5, String string6, String string7, List<DatabaseObjectReportValue> list, List<DatabaseObjectReportValue> list2, List<DatabaseObjectReportValue> list3, String string8, String string9, String string10, String string11, String string12, String string13, boolean bl2, boolean bl3, boolean bl4, String string14, String string15, String string16, String string17, String string18, String string19) {
        this.reportName = string;
        this.reportMode = string16;
        this.reportNameParameterName = string17;
        this.reportPathParameterName = string18;
        this.reportFormatParameterName = string19;
        this.date = new Date();
        this.targetUrl = string2;
        this.sourceUrl = string3;
        this.createdByUser = string6;
        this.hostName = string7;
        this.missing = list;
        this.unexpected = list2;
        this.changed = list3;
        this.jsonMissing = string8;
        this.jsonUnexpected = string9;
        this.jsonChanged = string10;
        this.numberMissing = string11;
        this.numberUnexpected = string12;
        this.numberChanged = string13;
        this.showMissing = bl2;
        this.showUnexpected = bl3;
        this.showChanged = bl4;
        this.commandArgs = string15;
        this.path = string14;
        this.visibleTargetUrl = string4;
        this.visibleSourceUrl = string5;
    }

    public boolean getShowMissing() {
        return this.showMissing;
    }

    public boolean getShowUnexpected() {
        return this.showUnexpected;
    }

    public boolean getShowChanged() {
        return this.showChanged;
    }

    public String getTargetUrl() {
        return JdbcConnection.sanitizeUrl((String)this.targetUrl);
    }

    public String getSourceUrl() {
        return JdbcConnection.sanitizeUrl((String)this.sourceUrl);
    }

    public int getMissingSeverity() {
        return DriftConfiguration.determineSeverity((Integer)DriftConfiguration.MISSING_SEVERITY.getCurrentValue());
    }

    public int getChangedSeverity() {
        return DriftConfiguration.determineSeverity((Integer)DriftConfiguration.CHANGED_SEVERITY.getCurrentValue());
    }

    public int getUnexpectedSeverity() {
        return DriftConfiguration.determineSeverity((Integer)DriftConfiguration.UNEXPECTED_SEVERITY.getCurrentValue());
    }

    public String getPath() {
        if (this.path != null) {
            if (this.path.equals(".")) {
                return "./";
            }
        } else {
            return "";
        }
        return this.path;
    }

    public String getReportName() {
        return this.reportName;
    }

    public Date getDate() {
        return this.date;
    }

    public String getCreatedByUser() {
        return this.createdByUser;
    }

    public String getHostName() {
        return this.hostName;
    }

    public List<DatabaseObjectReportValue> getMissing() {
        return this.missing;
    }

    public List<DatabaseObjectReportValue> getUnexpected() {
        return this.unexpected;
    }

    public List<DatabaseObjectReportValue> getChanged() {
        return this.changed;
    }

    public String getJsonMissing() {
        return this.jsonMissing;
    }

    public String getJsonUnexpected() {
        return this.jsonUnexpected;
    }

    public String getJsonChanged() {
        return this.jsonChanged;
    }

    public String getNumberMissing() {
        return this.numberMissing;
    }

    public String getNumberUnexpected() {
        return this.numberUnexpected;
    }

    public String getNumberChanged() {
        return this.numberChanged;
    }

    public String getCommandArgs() {
        return this.commandArgs;
    }

    public String getReportMode() {
        return this.reportMode;
    }

    public String getReportNameParameterName() {
        return this.reportNameParameterName;
    }

    public String getReportPathParameterName() {
        return this.reportPathParameterName;
    }

    public String getReportFormatParameterName() {
        return this.reportFormatParameterName;
    }

    public String getVisibleTargetUrl() {
        return this.visibleTargetUrl;
    }

    public String getVisibleSourceUrl() {
        return this.visibleSourceUrl;
    }
}

