/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.logging.structured;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import liquibase.license.LicenseServiceUtils;
import liquibase.logging.mdc.CustomMdcObject;
import liquibase.logging.mdc.MdcManager;
import liquibase.logging.mdc.MdcObject;

public class StructuredMdcManager
implements MdcManager {
    private static final ThreadLocal<Map<String, Object>> mdc = ThreadLocal.withInitial(LinkedHashMap::new);

    public MdcObject put(String string, String string2) {
        return this.put(string, (Object)string2);
    }

    public MdcObject put(String string, Map<String, Object> map) {
        return this.put(string, (Object)map);
    }

    public MdcObject put(String string, CustomMdcObject customMdcObject) {
        return this.put(string, (Object)customMdcObject);
    }

    private MdcObject put(String string, Object object) {
        mdc.get().put(string, object);
        return new MdcObject(string, object);
    }

    public void remove(String string) {
        mdc.get().remove(string);
    }

    public void clear() {
        mdc.remove();
    }

    public int getPriority() {
        if (LicenseServiceUtils.isProLicenseValid()) {
            return 10;
        }
        return -1;
    }

    public Map<String, Object> getAll() {
        return Collections.unmodifiableMap(mdc.get());
    }
}

