/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.command.AbstractRollbackOneCommand$1;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.change.core.RawSQLChange;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.AlreadyRanChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ContextChangeSetFilter;
import liquibase.changelog.filter.DbmsChangeSetFilter;
import liquibase.changelog.filter.IgnoreChangeSetFilter;
import liquibase.changelog.filter.LabelChangeSetFilter;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.changelog.visitor.RollbackVisitor;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandScope;
import liquibase.command.core.helpers.DatabaseChangelogCommandStep;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.logging.mdc.MdcObject;
import liquibase.logging.mdc.customobjects.ChangesetsRolledback;
import liquibase.resource.Resource;
import liquibase.util.StreamUtil;

public abstract class AbstractRollbackOneCommand
extends AbstractCommandStep {
    public static final String EMPTY_ROLLBACK_SCRIPT_MESSAGE = "No rollback logic defined in empty rollback script. Changesets have been removed from the DATABASECHANGELOG table but no other logic was performed.";

    public void validate(CommandScope commandScope) {
        commandScope.addArgumentValue(DatabaseChangelogCommandStep.UPDATE_NULL_CHECKSUMS, (Object)Boolean.FALSE);
    }

    protected ChangeLogIterator createChangeLogIterator(List<RanChangeSet> list, ChangeSetFilter changeSetFilter, DatabaseChangeLog databaseChangeLog, Contexts contexts, LabelExpression labelExpression, Database database) {
        return new ChangeLogIterator(list, databaseChangeLog, new ChangeSetFilter[]{changeSetFilter, new AlreadyRanChangeSetFilter(list), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new IgnoreChangeSetFilter(), new DbmsChangeSetFilter(database)});
    }

    protected RollbackVisitor createRollbackVisitor(List<ChangesetsRolledback.ChangeSet> list, Database database, ChangeExecListener changeExecListener) {
        return new RollbackVisitor(database, changeExecListener, list);
    }

    protected RawSQLChange buildRawSQLChange(String string) {
        string = new RawSQLChange(string);
        string.setSplitStatements(Boolean.TRUE);
        string.setStripComments(Boolean.TRUE);
        return string;
    }

    protected void removeRunStatus(ChangeLogIterator changeLogIterator, Contexts contexts, LabelExpression labelExpression, Database database) {
        changeLogIterator.run((ChangeSetVisitor)new AbstractRollbackOneCommand$1(this), new RuntimeEnvironment(database, contexts, labelExpression));
    }

    protected String getRollbackScriptContents(String string, String string2, ChangeLogParameters changeLogParameters, DatabaseChangeLog databaseChangeLog) {
        try {
            Resource resource = Scope.getCurrentScope().getResourceAccessor().get(string);
            if (resource == null) {
                throw new LiquibaseException(String.format("WARNING: The rollback script '%s' was not located. Please check your parameters. No rollback was performed.", string));
            }
            string = StreamUtil.readStreamAsString((InputStream)resource.openInputStream());
        }
        catch (IOException iOException) {
            throw new LiquibaseException("Error reading rollbackScript " + string2 + ": " + iOException.getMessage());
        }
        return changeLogParameters.expandExpressions(string, databaseChangeLog);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void logSuccess(DatabaseChangeLog object) {
        MdcObject mdcObject;
        block22: {
            mdcObject = Scope.getCurrentScope().getMdcManager().put("deploymentOutcome", "success");
            Throwable throwable = null;
            try {
                object = Scope.getCurrentScope().addMdcValue("changelogFile", object.getLogicalFilePath());
                Throwable throwable2 = null;
                try {
                    Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Rollback command completed successfully.");
                }
                catch (Throwable throwable3) {
                    Throwable throwable4 = throwable3;
                    throwable2 = throwable3;
                    throw throwable4;
                }
                finally {
                    if (object != null) {
                        if (throwable2 != null) {
                            try {
                                object.close();
                            }
                            catch (Throwable throwable5) {
                                throwable2.addSuppressed(throwable5);
                            }
                        } else {
                            object.close();
                        }
                    }
                }
                if (mdcObject == null) return;
                if (throwable == null) break block22;
            }
            catch (Throwable throwable4) {
                try {
                    object = throwable4;
                    throwable = throwable4;
                    throw object;
                }
                catch (Throwable throwable8) {
                    if (mdcObject == null) throw throwable8;
                    if (throwable == null) {
                        mdcObject.close();
                        throw throwable8;
                    }
                    try {
                        mdcObject.close();
                        throw throwable8;
                    }
                    catch (Throwable throwable9) {
                        throwable.addSuppressed(throwable9);
                        throw throwable8;
                    }
                }
            }
            try {
                mdcObject.close();
                return;
            }
            catch (Throwable throwable6) {
                throwable.addSuppressed(throwable6);
                return;
            }
        }
        mdcObject.close();
    }
}

