/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config.model;

import com.datical.liquibase.ext.checks.config.CheckSettingsConfigYaml;
import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.FileAccessorDTO;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.BasicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.command.checks.AbstractChecksCommandStep;
import com.datical.liquibase.ext.logging.structured.StructuredLogFormatter;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.exception.CommandExecutionException;
import liquibase.resource.Resource;
import liquibase.util.StringUtil;

public class CheckSettingsConfig {
    private String version;
    private Date fileModified;
    private Date fileCreated;
    private List<AbstractConfigurableRule> rules;
    private List<AbstractConfigurableRule> unrecognizedRules = new ArrayList<AbstractConfigurableRule>();
    private String warningMessage;
    private Resource resource;

    public CheckSettingsConfig(List<AbstractConfigurableRule> list, Resource resource) {
        this.rules = list;
        this.resource = resource;
    }

    public AbstractConfigurableRule getRuleById(UUID uUID) {
        for (AbstractConfigurableRule abstractConfigurableRule : this.rules) {
            if (!abstractConfigurableRule.getId().equals(uUID)) continue;
            return abstractConfigurableRule;
        }
        return null;
    }

    public List<AbstractConfigurableRule> getExecutableRulesByRuleId(UUID uUID) {
        return this.rules.stream().filter(abstractConfigurableRule -> abstractConfigurableRule.getId().equals(uUID) || abstractConfigurableRule instanceof DynamicRule && uUID.equals(((DynamicRule)abstractConfigurableRule).getParentRuleId())).sorted(Comparator.comparing(abstractConfigurableRule -> ((DynamicRule)abstractConfigurableRule).getShortName())).collect(Collectors.toList());
    }

    public DynamicRule getDynamicRuleByShortName(String string) {
        return this.rules.stream().filter(abstractConfigurableRule -> abstractConfigurableRule instanceof DynamicRule && ((DynamicRule)abstractConfigurableRule).getShortName().equalsIgnoreCase(string)).findFirst().orElse(null);
    }

    public AbstractConfigurableRule getRuleByShortName(String string) {
        try {
            AbstractLiquibaseRule abstractLiquibaseRule = AbstractChecksCommandStep.findRuleByShortName(string);
            return this.rules.stream().filter(abstractConfigurableRule -> abstractConfigurableRule.getId().equals(abstractLiquibaseRule.getId())).findFirst().orElse(null);
        }
        catch (CommandExecutionException commandExecutionException) {
            return this.getDynamicRuleByShortName(string);
        }
    }

    public DynamicRule getDynamicConfigurableRuleByShortName(String string, String string2) {
        DynamicRule dynamicRule = this.getDynamicRuleByShortName(string);
        if (dynamicRule == null) {
            if (!AbstractChecksCommandStep.findRuleByShortName(string).isConfigurable()) {
                throw new CommandExecutionException(System.lineSeparator() + System.lineSeparator() + "Check '" + string + "' " + string2 + "." + System.lineSeparator() + "Run 'liquibase checks show' to see a list of all available checks and customization options for checks.");
            }
            throw new CommandExecutionException("Check appears to be configurable, but cannot be located in the check settings configuration file.");
        }
        return dynamicRule;
    }

    public String getUnrecognizedRulesWarningMessage() {
        if (this.unrecognizedRules != null && !this.unrecognizedRules.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder("Unknown Checks Skipped (Upgrade Liquibase to use more official checks):" + System.lineSeparator());
            for (AbstractConfigurableRule abstractConfigurableRule : this.unrecognizedRules) {
                stringBuilder.append("  ");
                if (abstractConfigurableRule.isConfigurable()) {
                    stringBuilder.append(((DynamicRule)abstractConfigurableRule).getShortName());
                } else {
                    stringBuilder.append(abstractConfigurableRule.getId());
                }
                stringBuilder.append(System.lineSeparator());
            }
            stringBuilder.append(System.lineSeparator());
            return stringBuilder.toString();
        }
        return "";
    }

    public static CheckSettingsConfig generateDefaultConfigFromRules(List<AbstractLiquibaseRule> object, Resource resource) {
        ArrayList<AbstractConfigurableRule> arrayList = new ArrayList<AbstractConfigurableRule>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            AbstractLiquibaseRule abstractLiquibaseRule = (AbstractLiquibaseRule)object.next();
            arrayList.add(AbstractConfigurableRule.fromRuleImplementation(abstractLiquibaseRule));
        }
        object = new CheckSettingsConfig(arrayList, resource);
        ((CheckSettingsConfig)object).setVersion("1.1");
        return object;
    }

    public static Optional<AbstractConfigurableRule> findRuleById(List<AbstractConfigurableRule> list, UUID uUID) {
        return list.stream().filter(abstractConfigurableRule -> uUID.equals(abstractConfigurableRule.getId())).findFirst();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (CheckSettingsConfig)object;
        return Objects.equals(this.rules, ((CheckSettingsConfig)object).rules);
    }

    public int hashCode() {
        return Objects.hash(this.rules);
    }

    public void outputWarningMessage() {
        if (StringUtil.isNotEmpty((String)this.warningMessage)) {
            Scope.getCurrentScope().getLog(this.getClass()).warning(this.warningMessage);
            Scope.getCurrentScope().getUI().sendMessage("WARNING: " + this.warningMessage);
        }
    }

    public void setWarningMessage(String string) {
        this.warningMessage = string;
    }

    public static CheckSettingsConfig fromFileAccessorDTO(FileAccessorDTO iterator) {
        Object object;
        Map map = (Map)new CheckSettingsConfigYaml().load(FileAccessorDTO.stripClassIdentifiers(((FileAccessorDTO)((Object)iterator)).contents));
        CheckSettingsConfig checkSettingsConfig = new CheckSettingsConfig();
        checkSettingsConfig.setWarningMessage(((FileAccessorDTO)((Object)iterator)).warningMessage);
        checkSettingsConfig.resource = ((FileAccessorDTO)((Object)iterator)).resource;
        iterator = StructuredLogFormatter.findKeyInMapIgnoreCase("rules", map);
        iterator = map.get(iterator);
        if (iterator != null) {
            iterator = (List)((Object)iterator);
            object = new ArrayList(iterator.size());
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Iterator iterator2 = (Map)iterator.next();
                Boolean bl2 = (Boolean)iterator2.get(StructuredLogFormatter.findKeyInMapIgnoreCase("enabled", (Map<String, Object>)((Object)iterator2)));
                String string = (String)iterator2.get(StructuredLogFormatter.findKeyInMapIgnoreCase("description", (Map<String, Object>)((Object)iterator2)));
                String string2 = (String)iterator2.get(StructuredLogFormatter.findKeyInMapIgnoreCase("id", (Map<String, Object>)((Object)iterator2)));
                String string3 = (String)iterator2.get(StructuredLogFormatter.findKeyInMapIgnoreCase("name", (Map<String, Object>)((Object)iterator2)));
                Object object2 = StructuredLogFormatter.findKeyInMapIgnoreCase("parentRuleId", (Map<String, Object>)((Object)iterator2));
                String string4 = (String)iterator2.get(object2);
                Object v2 = iterator2.get(StructuredLogFormatter.findKeyInMapIgnoreCase("severity", (Map<String, Object>)((Object)iterator2)));
                String string5 = (String)iterator2.get(StructuredLogFormatter.findKeyInMapIgnoreCase("shortName", (Map<String, Object>)((Object)iterator2)));
                Object object3 = StructuredLogFormatter.findKeyInMapIgnoreCase("parameters", (Map<String, Object>)((Object)iterator2));
                if (object2 != null && object3 != null) {
                    iterator2 = (List)iterator2.get(object3);
                    object2 = new ArrayList(iterator2.size());
                    iterator2 = iterator2.iterator();
                    while (iterator2.hasNext()) {
                        object3 = (Map)iterator2.next();
                        String string6 = (String)object3.get(StructuredLogFormatter.findKeyInMapIgnoreCase("parameter", (Map<String, Object>)object3));
                        object3 = object3.get(StructuredLogFormatter.findKeyInMapIgnoreCase("value", (Map<String, Object>)object3));
                        try {
                            object2.add(new DynamicRuleParameter(DynamicRuleParameterEnum.valueOf(string6), object3));
                        }
                        catch (Exception exception) {
                            Scope.getCurrentScope().getLog(CheckSettingsConfig.class).warning("Rule parameter '" + string6 + "' not found. Skipping.");
                        }
                    }
                    object.add(new DynamicRule(bl2, SeverityEnum.fromYamlFile(v2), UUID.fromString(string2), string5, string3, string, string4 == null ? null : UUID.fromString(string4), (List<DynamicRuleParameter>)object2));
                    continue;
                }
                object.add(new BasicRule(bl2, SeverityEnum.fromYamlFile(v2), UUID.fromString(string2), string5, string3, string));
            }
            checkSettingsConfig.setRules((List<AbstractConfigurableRule>)object);
        }
        iterator = StructuredLogFormatter.findKeyInMapIgnoreCase("version", map);
        checkSettingsConfig.setVersion((String)map.get(iterator));
        try {
            object = StructuredLogFormatter.findKeyInMapIgnoreCase("fileCreated", map);
            checkSettingsConfig.setFileCreated((Date)map.get(object));
        }
        catch (Exception exception) {
            Scope.getCurrentScope().getLog(CheckSettingsConfig.class).warning("Failed to read fileCreated key from checks file.", (Throwable)exception);
        }
        try {
            object = StructuredLogFormatter.findKeyInMapIgnoreCase("fileModified", map);
            checkSettingsConfig.setFileModified((Date)map.get(object));
        }
        catch (Exception exception) {
            Scope.getCurrentScope().getLog(CheckSettingsConfig.class).warning("Failed to read fileModified key from checks file.", (Throwable)exception);
        }
        return checkSettingsConfig;
    }

    public String toYaml() {
        return FileAccessorDTO.stripClassIdentifiers(new CheckSettingsConfigYaml().dumpAsMap(this));
    }

    public String getVersion() {
        return this.version;
    }

    public Date getFileModified() {
        return this.fileModified;
    }

    public Date getFileCreated() {
        return this.fileCreated;
    }

    public List<AbstractConfigurableRule> getRules() {
        return this.rules;
    }

    public List<AbstractConfigurableRule> getUnrecognizedRules() {
        return this.unrecognizedRules;
    }

    public String getWarningMessage() {
        return this.warningMessage;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public void setFileModified(Date date) {
        this.fileModified = date;
    }

    public void setFileCreated(Date date) {
        this.fileCreated = date;
    }

    public void setRules(List<AbstractConfigurableRule> list) {
        this.rules = list;
    }

    public void setUnrecognizedRules(List<AbstractConfigurableRule> list) {
        this.unrecognizedRules = list;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public CheckSettingsConfig() {
    }
}

