/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.changelog.filter;

import liquibase.changelog.ChangeSet;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilterResult;

public class ChangeSetAuthorFilter
implements ChangeSetFilter {
    private final String author;

    public ChangeSetAuthorFilter(String string) {
        this.author = string;
    }

    public ChangeSetFilterResult accepts(ChangeSet changeSet) {
        String string = changeSet.toString();
        if (this.author.endsWith("*")) {
            String string2 = this.author.substring(0, this.author.length() - 1);
            if (changeSet.getAuthor().startsWith(string2)) {
                return new ChangeSetFilterResult(true, "Changeset to run is ".concat(String.valueOf(string)), this.getClass(), this.getMdcName(), this.getDisplayName());
            }
            return new ChangeSetFilterResult(false, String.format("Changeset '%s' will not execute because author '%s' does not match prefix '%s'", string, changeSet.getAuthor(), string2), this.getClass(), this.getMdcName(), this.getDisplayName());
        }
        if (this.author.equalsIgnoreCase(changeSet.getAuthor())) {
            return new ChangeSetFilterResult(true, "Changeset to run is ".concat(String.valueOf(string)), this.getClass(), this.getMdcName(), this.getDisplayName());
        }
        return new ChangeSetFilterResult(false, String.format("Changeset '%s' will not execute because author '%s' does not match '%s'", string, changeSet.getAuthor(), this.author), this.getClass(), this.getMdcName(), this.getDisplayName());
    }
}

