/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.percona;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ReflectionUtils {
    public static Class<?> findClass(ClassLoader loader, String ... names) {
        for (String clazzName : names) {
            Class<?> clazz = ReflectionUtils.loadClass(clazzName, loader);
            if (clazz == null) continue;
            return clazz;
        }
        return null;
    }

    public static Class<?> loadClass(String name, ClassLoader loader) {
        try {
            return loader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static <T> T invokeMethod(String className, Object instance, String methodName) {
        Class<?> clazz = ReflectionUtils.loadClass(className, instance.getClass().getClassLoader());
        return ReflectionUtils.invokeMethod(clazz, instance, methodName);
    }

    public static <T> T invokeMethod(Class<?> clazz, Object instance, String methodName) {
        try {
            if (clazz != null && clazz.isInstance(instance)) {
                Method method = ReflectionUtils.findMethod(clazz, methodName);
                method.setAccessible(true);
                Object result = method.invoke(instance, new Object[0]);
                return (T)result;
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Method findMethod(Class<?> clazz, String name) throws NoSuchMethodException, SecurityException {
        try {
            return clazz.getMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return clazz.getDeclaredMethod(name, new Class[0]);
        }
    }

    public static <T> T readField(Class<?> clazz, Object instance, String name) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field field = clazz.getDeclaredField(name);
        field.setAccessible(true);
        Object result = field.get(instance);
        return (T)result;
    }
}

