/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.percona;

public class PerconaToolkitVersion {
    private final int major;
    private final int minor;
    private final int patch;

    public PerconaToolkitVersion(String version) {
        if (version == null) {
            this.major = 0;
            this.minor = 0;
            this.patch = 0;
        } else {
            String[] parts = version.split("\\.");
            if (parts.length != 3) {
                throw new IllegalArgumentException("Invalid Version Format: " + version);
            }
            this.major = Integer.parseInt(parts[0]);
            this.minor = Integer.parseInt(parts[1]);
            this.patch = Integer.parseInt(parts[2]);
        }
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch;
    }

    public boolean isGreaterOrEqualThan(String otherVersion) {
        PerconaToolkitVersion other = new PerconaToolkitVersion(otherVersion);
        if (this.major > other.major) {
            return true;
        }
        if (this.major == other.major && this.minor > other.minor) {
            return true;
        }
        return this.major == other.major && this.minor == other.minor && this.patch >= other.patch;
    }
}

