/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.percona;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.core.DropUniqueConstraintChange;
import liquibase.database.Database;
import liquibase.ext.percona.PerconaChange;
import liquibase.ext.percona.PerconaChangeUtil;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="dropUniqueConstraint", description="Drops an existing unique constraint", priority=51, appliesTo={"uniqueConstraint"})
public class PerconaDropUniqueConstraintChange
extends DropUniqueConstraintChange
implements PerconaChange {
    public static final String NAME = "dropUniqueConstraint";
    public static final int PRIORITY = 51;
    private Boolean usePercona;
    private String perconaOptions;

    public SqlStatement[] generateStatements(Database database) {
        return PerconaChangeUtil.generateStatements(this, database, super.generateStatements(database));
    }

    @Override
    public String generateAlterStatement(Database database) {
        StringBuilder alter = new StringBuilder();
        alter.append("DROP KEY ");
        alter.append(database.escapeConstraintName(this.getConstraintName()));
        return alter.toString();
    }

    @Override
    public String getTargetTableName() {
        return this.getTableName();
    }

    @Override
    public String getTargetDatabaseName() {
        return this.getCatalogName();
    }

    @Override
    public String getChangeName() {
        return NAME;
    }

    @Override
    @DatabaseChangeProperty(requiredForDatabase={})
    public Boolean getUsePercona() {
        return this.usePercona;
    }

    @Override
    public void setUsePercona(Boolean usePercona) {
        this.usePercona = usePercona;
    }

    @Override
    @DatabaseChangeProperty(requiredForDatabase={})
    public String getPerconaOptions() {
        return this.perconaOptions;
    }

    @Override
    public void setPerconaOptions(String perconaOptions) {
        this.perconaOptions = perconaOptions;
    }

    public Set<String> getSerializableFields() {
        HashSet fields = new HashSet(super.getSerializableFields());
        fields.remove("usePercona");
        fields.remove("perconaOptions");
        return Collections.unmodifiableSet(fields);
    }
}

