/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.percona;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.core.AddForeignKeyConstraintChange;
import liquibase.database.Database;
import liquibase.ext.percona.PerconaChange;
import liquibase.ext.percona.PerconaChangeUtil;
import liquibase.ext.percona.PerconaDropForeignKeyConstraintChange;
import liquibase.statement.SqlStatement;
import liquibase.util.StringUtil;

@DatabaseChange(name="addForeignKeyConstraint", description="Adds a foreign key constraint to an existing column", priority=51, appliesTo={"column"})
public class PerconaAddForeignKeyConstraintChange
extends AddForeignKeyConstraintChange
implements PerconaChange {
    public static final String NAME = "addForeignKeyConstraint";
    public static final int PRIORITY = 51;
    private Boolean usePercona;
    private String perconaOptions;

    public SqlStatement[] generateStatements(Database database) {
        return PerconaChangeUtil.generateStatements(this, database, super.generateStatements(database));
    }

    @Override
    public String generateAlterStatement(Database database) {
        StringBuilder alter = new StringBuilder();
        alter.append("ADD CONSTRAINT ");
        if (StringUtil.isNotEmpty((String)this.getConstraintName())) {
            alter.append(database.escapeConstraintName(this.getConstraintName())).append(" ");
        }
        alter.append("FOREIGN KEY ");
        alter.append("(");
        List baseColumns = StringUtil.splitAndTrim((String)this.getBaseColumnNames(), (String)",");
        if (baseColumns == null) {
            baseColumns = Collections.emptyList();
        }
        alter.append(database.escapeColumnNameList(StringUtil.join(baseColumns, (String)", ")));
        alter.append(") ");
        alter.append("REFERENCES ");
        String referencedTable = PerconaChangeUtil.resolveReferencedPerconaTableName(this.getBaseTableName(), this.getReferencedTableName());
        alter.append(database.escapeTableName(this.getReferencedTableCatalogName(), this.getReferencedTableSchemaName(), referencedTable)).append(" ");
        alter.append("(");
        List referencedColumns = StringUtil.splitAndTrim((String)this.getReferencedColumnNames(), (String)",");
        if (referencedColumns == null) {
            referencedColumns = Collections.emptyList();
        }
        alter.append(database.escapeColumnNameList(StringUtil.join(referencedColumns, (String)", ")));
        alter.append(")");
        if (this.getOnDelete() != null) {
            alter.append(" ON DELETE ").append(this.getOnDelete());
        }
        if (this.getOnUpdate() != null) {
            alter.append(" ON UPDATE ").append(this.getOnUpdate());
        }
        if (this.getDeferrable() != null && this.getDeferrable().booleanValue()) {
            alter.append(" DEFERRABLE");
        }
        if (this.getInitiallyDeferred() != null && this.getInitiallyDeferred().booleanValue()) {
            alter.append(" INITIALLY DEFERRED");
        }
        return alter.toString();
    }

    protected Change[] createInverses() {
        PerconaDropForeignKeyConstraintChange inverse = new PerconaDropForeignKeyConstraintChange();
        inverse.setBaseTableCatalogName(this.getBaseTableCatalogName());
        inverse.setBaseTableSchemaName(this.getBaseTableSchemaName());
        inverse.setBaseTableName(this.getBaseTableName());
        inverse.setConstraintName(this.getConstraintName());
        return new Change[]{inverse};
    }

    @Override
    public String getTargetTableName() {
        return this.getBaseTableName();
    }

    @Override
    public String getTargetDatabaseName() {
        return this.getBaseTableCatalogName();
    }

    @Override
    public String getChangeName() {
        return NAME;
    }

    @Override
    @DatabaseChangeProperty(requiredForDatabase={})
    public Boolean getUsePercona() {
        return this.usePercona;
    }

    @Override
    public void setUsePercona(Boolean usePercona) {
        this.usePercona = usePercona;
    }

    @Override
    @DatabaseChangeProperty(requiredForDatabase={})
    public String getPerconaOptions() {
        return this.perconaOptions;
    }

    @Override
    public void setPerconaOptions(String perconaOptions) {
        this.perconaOptions = perconaOptions;
    }

    public Set<String> getSerializableFields() {
        HashSet fields = new HashSet(super.getSerializableFields());
        fields.remove("usePercona");
        fields.remove("perconaOptions");
        return Collections.unmodifiableSet(fields);
    }
}

