/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.percona;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.ext.percona.Configuration;
import liquibase.ext.percona.DatabaseConnectionUtil;
import liquibase.ext.percona.PerconaToolkitVersion;
import liquibase.logging.Logger;
import liquibase.sql.Sql;
import liquibase.statement.core.RuntimeStatement;
import liquibase.util.StreamUtil;

public class PTOnlineSchemaChangeStatement
extends RuntimeStatement {
    public static final String COMMAND = "pt-online-schema-change";
    static PerconaToolkitVersion perconaToolkitVersion = null;
    static Boolean available = null;
    private static Logger log = Scope.getCurrentScope().getLog(PTOnlineSchemaChangeStatement.class);
    private String databaseName;
    private String tableName;
    private String alterStatement;
    private Optional<String> perconaOptions;

    public PTOnlineSchemaChangeStatement(String databaseName, String tableName, String alterStatement, Optional<String> perconaOptions) {
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.alterStatement = alterStatement;
        this.perconaOptions = perconaOptions;
    }

    private List<String> tokenize(String options) {
        StringTokenizer stringTokenizer = new StringTokenizer(options);
        LinkedList<String> result = new LinkedList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            result.add(stringTokenizer.nextToken());
        }
        return this.joinQuotedArguments(result);
    }

    private List<String> joinQuotedArguments(List<String> tokenizedArguments) {
        String joinCharacters = " ";
        LinkedList<String> filtered = new LinkedList<String>();
        boolean inQuotes = false;
        for (int i = 0; i < tokenizedArguments.size(); ++i) {
            String arg = tokenizedArguments.get(i);
            if (!inQuotes) {
                if (arg.startsWith("\"")) {
                    inQuotes = true;
                    arg = arg.substring(1);
                } else if (arg.contains("=\"")) {
                    inQuotes = true;
                    arg = arg.replaceFirst("=\"", "=");
                }
                if (arg.endsWith("\"")) {
                    inQuotes = false;
                    arg = arg.substring(0, arg.length() - 1);
                }
                filtered.add(arg);
                continue;
            }
            if (arg.endsWith("\"")) {
                inQuotes = false;
                arg = arg.substring(0, arg.length() - 1);
            }
            String last = (String)filtered.get(filtered.size() - 1);
            filtered.set(filtered.size() - 1, last + " " + arg);
        }
        return filtered;
    }

    List<String> buildCommand(Database database) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(PTOnlineSchemaChangeStatement.getFullToolkitPath());
        if (this.perconaOptions.isPresent()) {
            commands.addAll(this.tokenize(this.perconaOptions.get()));
        } else if (!Configuration.getAdditionalOptions().isEmpty()) {
            commands.addAll(this.tokenize(Configuration.getAdditionalOptions()));
        }
        commands.add("--alter=" + this.alterStatement);
        StringBuilder dsn = new StringBuilder(200);
        if (database.getConnection() != null) {
            DatabaseConnectionUtil connection = new DatabaseConnectionUtil(database.getConnection());
            dsn.append("h=").append(connection.getHost());
            dsn.append(",P=").append(connection.getPort());
            dsn.append(",u=").append(connection.getUser());
            dsn.append(',');
            String pw = connection.getPassword();
            if (pw != null) {
                commands.add("--password=" + pw);
            }
        }
        if (this.databaseName != null) {
            dsn.append("D=").append(this.databaseName);
        } else {
            dsn.append("D=").append(database.getLiquibaseCatalogName());
        }
        dsn.append(",t=").append(this.tableName);
        commands.add("--execute");
        commands.add(dsn.toString());
        return commands;
    }

    public String printCommand(Database database) {
        List<String> command = this.buildCommand(database);
        return this.filterCommands(command);
    }

    private String filterCommands(List<String> command) {
        StringBuilder sb = new StringBuilder();
        for (String s : command) {
            sb.append(" ");
            if (s.startsWith("--password")) {
                sb.append("--password=***");
                continue;
            }
            if (s.contains(" ")) {
                sb.append(s.substring(0, s.indexOf(61) + 1)).append("\"").append(s.substring(s.indexOf(61) + 1)).append("\"");
                continue;
            }
            sb.append(s);
        }
        return sb.substring(1).toString();
    }

    public Sql[] generate(Database database) {
        List<String> cmndline = this.buildCommand(database);
        log.info("Executing: " + this.filterCommands(cmndline));
        KeepAliveThread keepAlive = new KeepAliveThread(database);
        if (Configuration.isKeepAlive()) {
            keepAlive.start();
        }
        ProcessBuilder pb = new ProcessBuilder(cmndline);
        if (Configuration.isPerconaToolkitDebug()) {
            pb.environment().put("PTDEBUG", "1");
        }
        pb.redirectErrorStream(true);
        Process p = null;
        try (final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            FilterOutputStream tee = new FilterOutputStream(outputStream){

                @Override
                public void write(int b) throws IOException {
                    if (b == 10) {
                        log.info(outputStream.toString(Charset.defaultCharset().toString()));
                        outputStream.reset();
                    } else {
                        super.write(b);
                    }
                }
            };
            p = pb.start();
            try (InputStream in = p.getInputStream();
                 InputStream err = p.getErrorStream();
                 OutputStream out = p.getOutputStream();){
                IOThread reader = new IOThread(in, tee);
                IOThread reader2 = new IOThread(err, tee);
                reader.start();
                reader2.start();
                int exitCode = p.waitFor();
                reader.join(5000L);
                reader2.join(5000L);
                keepAlive.interrupt();
                log.info(outputStream.toString(Charset.defaultCharset().toString()));
                if (exitCode != 0) {
                    throw new RuntimeException("Percona exited with " + exitCode);
                }
            }
        }
        catch (IOException e) {
            throw new UnexpectedLiquibaseException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new UnexpectedLiquibaseException((Throwable)e);
        }
        finally {
            if (p != null) {
                p.destroy();
            }
        }
        return null;
    }

    public String toString() {
        return PTOnlineSchemaChangeStatement.class.getSimpleName() + "[database: " + this.databaseName + ", table: " + this.tableName + ", alterStatement: " + this.alterStatement + "]";
    }

    public static synchronized PerconaToolkitVersion getVersion() {
        if (available == null) {
            PTOnlineSchemaChangeStatement.checkIsAvailableAndGetVersion();
        }
        return perconaToolkitVersion != null ? perconaToolkitVersion : new PerconaToolkitVersion(null);
    }

    public static synchronized boolean isAvailable() {
        if (available != null) {
            return available;
        }
        PTOnlineSchemaChangeStatement.checkIsAvailableAndGetVersion();
        return available;
    }

    private static String getFullToolkitPath() {
        String toolkitPath = Configuration.getPerconaToolkitPath();
        if (toolkitPath.isEmpty()) {
            return COMMAND;
        }
        if (toolkitPath.endsWith(File.separator)) {
            return toolkitPath + COMMAND;
        }
        return toolkitPath + File.separator + COMMAND;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkIsAvailableAndGetVersion() {
        ProcessBuilder pb = new ProcessBuilder(PTOnlineSchemaChangeStatement.getFullToolkitPath(), "--version");
        pb.redirectErrorStream(true);
        Process p = null;
        try {
            p = pb.start();
            try (InputStream err = p.getErrorStream();
                 InputStream in = p.getInputStream();
                 OutputStream out = p.getOutputStream();){
                Matcher matcher;
                p.waitFor();
                String output = StreamUtil.readStreamAsString((InputStream)in);
                if (output != null && (matcher = Pattern.compile("(\\d+\\.\\d+\\.\\d+)").matcher(output)).find()) {
                    perconaToolkitVersion = new PerconaToolkitVersion(matcher.group(1));
                }
                available = true;
                log.info("Using percona toolkit: " + perconaToolkitVersion);
            }
        }
        catch (IOException e) {
            available = false;
        }
        catch (InterruptedException e) {
            available = false;
        }
        finally {
            if (p != null) {
                p.destroy();
            }
        }
    }

    private static class IOThread
    extends Thread {
        private Logger log = Scope.getCurrentScope().getLog(IOThread.class);
        private InputStream from;
        private OutputStream to;

        public IOThread(InputStream from, OutputStream to) {
            this.setDaemon(true);
            this.from = from;
            this.to = to;
        }

        @Override
        public void run() {
            try {
                StreamUtil.copy((InputStream)this.from, (OutputStream)this.to);
            }
            catch (IOException e) {
                this.log.fine("While copying streams", (Throwable)e);
            }
        }
    }

    private static class KeepAliveThread
    extends Thread {
        private final Database database;

        public KeepAliveThread(Database database) {
            this.database = database;
        }

        @Override
        public void run() {
            boolean running = true;
            JdbcConnection connection = (JdbcConnection)this.database.getConnection();
            long keepAlive = 28800L;
            try (Statement stmt = connection.createStatement();){
                stmt.execute("show variables where variable_name = 'wait_timeout'");
                try (ResultSet rs = stmt.getResultSet();){
                    if (rs.next()) {
                        keepAlive = rs.getLong(2);
                    } else {
                        log.warning("Couldn't determine wait_timeout for keepAlive, using default");
                    }
                }
            }
            catch (SQLException | DatabaseException e) {
                log.warning("Couldn't determine wait_timeout for keepAlive, using default", e);
            }
            long sleepTimeInMillis = TimeUnit.SECONDS.toMillis(keepAlive) / 2L;
            sleepTimeInMillis = Math.max(500L, sleepTimeInMillis);
            log.info("KeepAlive every " + sleepTimeInMillis + " millis");
            while (running) {
                try {
                    Statement stmt = connection.createStatement();
                    try {
                        log.fine("Pinging database...");
                        stmt.execute("SELECT 1");
                        Thread.sleep(sleepTimeInMillis);
                    }
                    finally {
                        if (stmt == null) continue;
                        stmt.close();
                    }
                }
                catch (SQLException | DatabaseException e) {
                    log.severe("Couldn't ping database", e);
                    running = false;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    running = false;
                }
            }
            log.info("KeepAlive thread finished");
        }
    }
}

