/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.percona;

public final class Configuration {
    public static final String FAIL_IF_NO_PT = "liquibase.percona.failIfNoPT";
    public static final String NO_ALTER_SQL_DRY_MODE = "liquibase.percona.noAlterSqlDryMode";
    public static final String SKIP_CHANGES = "liquibase.percona.skipChanges";
    public static final String ADDITIONAL_OPTIONS = "liquibase.percona.options";
    public static final String DEFAULT_ON = "liquibase.percona.defaultOn";
    public static final String LIQUIBASE_PASSWORD = "liquibase.password";
    public static final String PERCONA_TOOLKIT_PATH = "liquibase.percona.path";
    public static final String PERCONA_TOOLKIT_DEBUG = "liquibase.percona.ptdebug";
    public static final String KEEPALIVE = "liquibase.percona.keepAlive";
    private static final String DEFAULT_ADDITIONAL_OPTIONS = "--alter-foreign-keys-method=auto --nocheck-unique-key-change";

    public static boolean failIfNoPT() {
        return Boolean.getBoolean(FAIL_IF_NO_PT);
    }

    public static boolean noAlterSqlDryMode() {
        return Boolean.getBoolean(NO_ALTER_SQL_DRY_MODE);
    }

    public static boolean skipChange(String change) {
        return System.getProperty(SKIP_CHANGES, "").contains(change);
    }

    public static String getAdditionalOptions() {
        return System.getProperty(ADDITIONAL_OPTIONS, DEFAULT_ADDITIONAL_OPTIONS);
    }

    public static boolean getDefaultOn() {
        return Boolean.parseBoolean(System.getProperty(DEFAULT_ON, "true"));
    }

    public static String getLiquibasePassword() {
        return System.getProperty(LIQUIBASE_PASSWORD);
    }

    public static String getPerconaToolkitPath() {
        return System.getProperty(PERCONA_TOOLKIT_PATH, "");
    }

    public static boolean isPerconaToolkitDebug() {
        return Boolean.parseBoolean(System.getProperty(PERCONA_TOOLKIT_DEBUG, "false"));
    }

    public static boolean isKeepAlive() {
        return Boolean.parseBoolean(System.getProperty(KEEPALIVE, "true"));
    }
}

