/*
 * Decompiled with CFR 0.152.
 */
package org.libheiffx;

import com.drew.imaging.heif.HeifMetadataReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdk.incubator.foreign.Addressable;
import jdk.incubator.foreign.MemoryAddress;
import jdk.incubator.foreign.MemoryLayout;
import jdk.incubator.foreign.MemorySegment;
import jdk.incubator.foreign.ResourceScope;
import jdk.incubator.foreign.SegmentAllocator;
import jdk.incubator.foreign.SymbolLookup;
import jdk.incubator.foreign.ValueLayout;
import org.libheif.linuxosx.heif_error;
import org.libheif.linuxosx.heif_h;
import org.libheiffx.HEIFImageLoader;
import org.libheiffx.NativeUtils;

public class LibheifImage {
    private final String imageFileURL;
    private int imageWidth;
    private int imageHeight;
    private int imageBits;
    private int imageColors;
    private int stride;
    private static String[] loadLibraryFromJar;
    private static String operatingSystem;
    private HEIFImageLoader loader;
    private String cameraModel;
    private LocalDateTime shootingDateTime;
    private static SymbolLookup loaderLookup;

    public LibheifImage(String imageFile) {
        this.imageFileURL = imageFile;
    }

    LibheifImage(HEIFImageLoader loader) {
        this.imageFileURL = null;
        this.loader = loader;
    }

    public static void loadLibs(String tempDir) throws IOException {
        Logger.getLogger(LibheifImage.class.getName()).log(Level.FINEST, null, "Init native libs...");
        operatingSystem = System.getProperty("os.name").toUpperCase();
        Logger.getLogger(LibheifImage.class.getName()).log(Level.FINEST, null, "OS was: " + operatingSystem);
        if (operatingSystem.contains("WIN")) {
            loadLibraryFromJar = NativeUtils.loadLibraryFromJar(tempDir, "/lib/win-x86_64/libde265.dll", "/lib/win-x86_64/heif.dll");
        } else if (operatingSystem.contains("MAC")) {
            loadLibraryFromJar = NativeUtils.loadLibraryFromJar(tempDir, "/lib/osx/libc++.1.dylib", "/lib/osx/libde265.0.dylib", "/lib/osx/libx265.199.dylib", "/lib/osx/libSystem.B.dylib", "/lib/osx/libiconv.2.dylib", "/lib/osx/libresolv.9.dylib", "/lib/osx/libheif.1.dylib");
        } else if (operatingSystem.contains("NUX")) {
            loadLibraryFromJar = NativeUtils.loadLibraryFromJar(tempDir, "/lib/linux-x86_64/libheif.so");
        }
        Logger.getLogger(LibheifImage.class.getName()).log(Level.FINEST, null, "loadLibraryFromJar: " + Arrays.toString(loadLibraryFromJar) + " , tempdir: " + tempDir);
        for (String part : loadLibraryFromJar) {
            new File(part).deleteOnExit();
        }
        Logger.getLogger(LibheifImage.class.getName()).log(Level.FINEST, null, "Init native libs...finished");
        for (String strTemp : loadLibraryFromJar) {
            System.load(strTemp);
            loaderLookup = SymbolLookup.loaderLookup();
        }
    }

    public byte[] readPixelDataFromStream(byte[] sourceFileAsByteArray) throws IOException {
        if (sourceFileAsByteArray == null) {
            Logger.getLogger(LibheifImage.class.getName()).log(Level.SEVERE, null, "sourceFileAsByteArray == null!");
            throw new IllegalArgumentException("sourceFileAsByteArray == null!");
        }
        if (loadLibraryFromJar == null) {
            Logger.getLogger(LibheifImage.class.getName()).log(Level.SEVERE, null, "Please call loadLibs as static method first!");
            throw new IllegalArgumentException("Please call loadLibs as static method first!");
        }
        try (ResourceScope scope = ResourceScope.newSharedScope();){
            if (operatingSystem.contains("WIN")) {
                Object addOffset;
                MemoryAddress heif_context_alloc = org.libheif.win.heif_h.heif_context_alloc();
                MemorySegment inputStreamBytes = MemorySegment.ofArray((byte[])sourceFileAsByteArray);
                MemorySegment allocateNative = SegmentAllocator.nativeAllocator((ResourceScope)scope).allocateArray(org.libheif.win.heif_h.C_CHAR, sourceFileAsByteArray);
                MemorySegment errorOpening = org.libheif.win.heif_h.heif_context_read_from_memory_without_copy(scope, (Addressable)heif_context_alloc.address(), (Addressable)allocateNative.address(), inputStreamBytes.byteSize(), (Addressable)MemoryAddress.NULL);
                int errorcode = org.libheif.win.heif_error.code$get(errorOpening);
                if (errorcode > 0) {
                    throw new IOException("Cannot open image file because reading of file data is not possible  (" + errorcode + ")!");
                }
                int heif_context_get_number_of_top_level_images = org.libheif.win.heif_h.heif_context_get_number_of_top_level_images((Addressable)heif_context_alloc);
                MemorySegment primary_image_handle_seg = MemorySegment.allocateNative((MemoryLayout)org.libheif.win.heif_h.C_POINTER, (ResourceScope)scope);
                MemorySegment errorhandle = org.libheif.win.heif_h.heif_context_get_primary_image_handle(scope, (Addressable)heif_context_alloc, (Addressable)primary_image_handle_seg.address());
                errorcode = org.libheif.win.heif_error.code$get(errorhandle);
                if (errorcode > 0) {
                    throw new IOException("Cannot open image file because codec is not supported (" + errorcode + ")!");
                }
                MemoryAddress primary_image_handle = primary_image_handle_seg.get(ValueLayout.ADDRESS, 0L);
                MemorySegment heif_image_seg = MemorySegment.allocateNative((MemoryLayout)org.libheif.win.heif_h.C_POINTER, (ResourceScope)scope);
                org.libheif.win.heif_h.heif_decode_image(scope, (Addressable)primary_image_handle, (Addressable)heif_image_seg.address(), org.libheif.win.heif_h.heif_colorspace_RGB(), org.libheif.win.heif_h.heif_chroma_interleaved_RGBA(), (Addressable)MemoryAddress.NULL);
                MemoryAddress heif_image = heif_image_seg.get(ValueLayout.ADDRESS, 0L);
                this.imageHeight = org.libheif.win.heif_h.heif_image_get_height((Addressable)heif_image, org.libheif.win.heif_h.heif_channel_interleaved());
                this.imageWidth = org.libheif.win.heif_h.heif_image_get_width((Addressable)heif_image, org.libheif.win.heif_h.heif_channel_interleaved());
                this.imageBits = org.libheif.win.heif_h.heif_image_get_bits_per_pixel((Addressable)heif_image, org.libheif.win.heif_h.heif_channel_interleaved());
                this.imageColors = 4;
                MemorySegment strideSegm = MemorySegment.allocateNative((MemoryLayout)org.libheif.win.heif_h.C_INT, (ResourceScope)scope);
                MemoryAddress image_data = org.libheif.win.heif_h.heif_image_get_plane_readonly((Addressable)heif_image, org.libheif.win.heif_h.heif_channel_interleaved(), (Addressable)strideSegm.address());
                this.stride = strideSegm.toArray(ValueLayout.JAVA_INT)[0];
                int pos = 0;
                int[] data = new int[this.imageHeight * this.imageWidth];
                for (int i = 0; i < this.imageHeight; ++i) {
                    addOffset = image_data.address().addOffset((long)(this.stride * i));
                    MemorySegment asSegmentRestricted = MemorySegment.ofAddress((MemoryAddress)addOffset, (long)this.stride, (ResourceScope)scope);
                    int[] toIntArray = asSegmentRestricted.toArray(ValueLayout.JAVA_INT);
                    for (int j = 0; j < toIntArray.length; ++j) {
                        int rgba = toIntArray[j];
                        int r = rgba & 0xFF;
                        int g = rgba >> 8 & 0xFF;
                        int b = rgba >> 16 & 0xFF;
                        int a = rgba >> 24 & 0xFF;
                        int finalValue = a << 24 | r << 16 | g << 8 | b;
                        data[pos] = rgba;
                        ++pos;
                    }
                }
                byte[] retData = new byte[this.imageWidth * this.imageHeight * this.getNumBands()];
                this.IntToByte(retData, data, this.imageWidth * this.imageHeight);
                org.libheif.win.heif_h.heif_context_free((Addressable)heif_context_alloc);
                data = null;
                heif_context_alloc = null;
                addOffset = retData;
                return addOffset;
            }
            MemoryAddress heif_context_alloc = heif_h.heif_context_alloc();
            MemorySegment inputStreamBytes = MemorySegment.ofArray((byte[])sourceFileAsByteArray);
            MemorySegment allocateNative = SegmentAllocator.nativeAllocator((ResourceScope)scope).allocateArray(heif_h.C_CHAR, sourceFileAsByteArray);
            MemorySegment errorOpening = heif_h.heif_context_read_from_memory_without_copy(scope, (Addressable)heif_context_alloc.address(), (Addressable)allocateNative.address(), inputStreamBytes.byteSize(), (Addressable)MemoryAddress.NULL);
            int errorcode = heif_error.code$get(errorOpening);
            if (errorcode > 0) {
                throw new IOException("Cannot open image file because reading of file data is not possible  (" + errorcode + ")!");
            }
            int heif_context_get_number_of_top_level_images = heif_h.heif_context_get_number_of_top_level_images((Addressable)heif_context_alloc);
            MemorySegment primary_image_handle_seg = MemorySegment.allocateNative((MemoryLayout)heif_h.C_POINTER, (ResourceScope)scope);
            MemorySegment errorhandle = heif_h.heif_context_get_primary_image_handle(scope, (Addressable)heif_context_alloc, (Addressable)primary_image_handle_seg.address());
            errorcode = heif_error.code$get(errorhandle);
            if (errorcode > 0) {
                throw new IOException("Cannot open image file because codec is not supported (" + errorcode + ")!");
            }
            MemoryAddress primary_image_handle = primary_image_handle_seg.get(ValueLayout.ADDRESS, 0L);
            int heif_image_get_primary_height = heif_h.heif_image_get_primary_height((Addressable)primary_image_handle);
            MemorySegment heif_image_seg = MemorySegment.allocateNative((MemoryLayout)heif_h.C_POINTER, (ResourceScope)scope);
            heif_h.heif_decode_image(scope, (Addressable)primary_image_handle, (Addressable)heif_image_seg.address(), heif_h.heif_colorspace_RGB(), heif_h.heif_chroma_interleaved_RGBA(), (Addressable)MemoryAddress.NULL);
            MemoryAddress heif_image = heif_image_seg.get(ValueLayout.ADDRESS, 0L);
            this.imageHeight = heif_h.heif_image_get_height((Addressable)heif_image, heif_h.heif_channel_interleaved());
            this.imageWidth = heif_h.heif_image_get_width((Addressable)heif_image, heif_h.heif_channel_interleaved());
            this.imageBits = heif_h.heif_image_get_bits_per_pixel((Addressable)heif_image, heif_h.heif_channel_interleaved());
            this.imageColors = 4;
            MemorySegment strideSegm = MemorySegment.allocateNative((MemoryLayout)heif_h.C_INT, (ResourceScope)scope);
            MemoryAddress image_data = heif_h.heif_image_get_plane_readonly((Addressable)heif_image, heif_h.heif_channel_interleaved(), (Addressable)strideSegm.address());
            this.stride = strideSegm.toArray(ValueLayout.JAVA_INT)[0];
            int pos = 0;
            int[] data = new int[this.imageHeight * this.imageWidth];
            for (int i = 0; i < this.imageHeight; ++i) {
                MemoryAddress addOffset = image_data.address().addOffset((long)(this.stride * i));
                MemorySegment asSegmentRestricted = MemorySegment.ofAddress((MemoryAddress)addOffset, (long)this.stride, (ResourceScope)scope);
                int[] toIntArray = asSegmentRestricted.toArray(ValueLayout.JAVA_INT);
                for (int j = 0; j < toIntArray.length; ++j) {
                    int rgba = toIntArray[j];
                    int r = rgba & 0xFF;
                    int g = rgba >> 8 & 0xFF;
                    int b = rgba >> 16 & 0xFF;
                    int a = rgba >> 24 & 0xFF;
                    int finalValue = a << 24 | r << 16 | g << 8 | b;
                    data[pos] = rgba;
                    ++pos;
                }
            }
            byte[] retData = new byte[this.imageWidth * this.imageHeight * this.getNumBands()];
            this.IntToByte(retData, data, this.imageWidth * this.imageHeight);
            heif_h.heif_context_free((Addressable)heif_context_alloc);
            data = null;
            heif_context_alloc = null;
            byte[] byArray = retData;
            return byArray;
        }
    }

    private int IntToByte(byte[] arrayDst, int[] arrayOrg, int maxOrg) {
        int maxDst = maxOrg * this.getNumBands();
        if (arrayDst == null) {
            return 0;
        }
        if (arrayOrg == null) {
            return 0;
        }
        if (arrayDst.length < maxDst) {
            return 0;
        }
        if (arrayOrg.length < maxOrg) {
            return 0;
        }
        int idxDst = 0;
        for (int i = 0; i < maxOrg; ++i) {
            arrayDst[idxDst] = (byte)arrayOrg[i];
            arrayDst[++idxDst] = (byte)(arrayOrg[i] >> 8);
            arrayDst[++idxDst] = (byte)(arrayOrg[i] >> 16);
            arrayDst[++idxDst] = (byte)(arrayOrg[i] >> 24);
            ++idxDst;
        }
        return idxDst;
    }

    public synchronized int[] readPixelData() throws IOException {
        if (this.imageFileURL == null) {
            Logger.getLogger(LibheifImage.class.getName()).log(Level.FINEST, null, "imageFileURL == null! " + this.imageFileURL);
            throw new IllegalArgumentException("imageFileURL == null!");
        }
        if (loadLibraryFromJar == null) {
            Logger.getLogger(LibheifImage.class.getName()).log(Level.FINEST, null, "Please call loadLibs as static method first!");
            throw new IllegalArgumentException("Please call loadLibs as static method first!");
        }
        try (ResourceScope scope = ResourceScope.newSharedScope();){
            if (operatingSystem.contains("WIN")) {
                MemoryAddress heif_context_alloc = org.libheif.win.heif_h.heif_context_alloc();
                MemorySegment errorOpening = org.libheif.win.heif_h.heif_context_read_from_file(scope, (Addressable)heif_context_alloc, (Addressable)SegmentAllocator.nativeAllocator((ResourceScope)scope).allocateUtf8String(this.imageFileURL).address(), (Addressable)MemoryAddress.NULL);
                int errorcode = org.libheif.win.heif_error.code$get(errorOpening);
                if (errorcode > 0) {
                    throw new IOException("Cannot open image file because reading of file data is not possible  (" + errorcode + ")!");
                }
                int heif_context_get_number_of_top_level_images = org.libheif.win.heif_h.heif_context_get_number_of_top_level_images((Addressable)heif_context_alloc);
                MemorySegment primary_image_handle_seg = MemorySegment.allocateNative((MemoryLayout)org.libheif.win.heif_h.C_POINTER, (ResourceScope)scope);
                MemorySegment errorhandle = org.libheif.win.heif_h.heif_context_get_primary_image_handle(scope, (Addressable)heif_context_alloc, (Addressable)primary_image_handle_seg.address());
                errorcode = org.libheif.win.heif_error.code$get(errorhandle);
                if (errorcode > 0) {
                    throw new IOException("Cannot open image file because codec is not supported (" + errorcode + ")!");
                }
                MemoryAddress primary_image_handle = primary_image_handle_seg.get(ValueLayout.ADDRESS, 0L);
                MemorySegment heif_image_seg = MemorySegment.allocateNative((MemoryLayout)org.libheif.win.heif_h.C_POINTER, (ResourceScope)scope);
                org.libheif.win.heif_h.heif_decode_image(scope, (Addressable)primary_image_handle, (Addressable)heif_image_seg.address(), org.libheif.win.heif_h.heif_colorspace_RGB(), org.libheif.win.heif_h.heif_chroma_interleaved_RGBA(), (Addressable)MemoryAddress.NULL);
                MemoryAddress heif_image = heif_image_seg.get(ValueLayout.ADDRESS, 0L);
                this.imageHeight = org.libheif.win.heif_h.heif_image_get_height((Addressable)heif_image, org.libheif.win.heif_h.heif_channel_interleaved());
                this.imageWidth = org.libheif.win.heif_h.heif_image_get_width((Addressable)heif_image, org.libheif.win.heif_h.heif_channel_interleaved());
                this.imageBits = org.libheif.win.heif_h.heif_image_get_bits_per_pixel((Addressable)heif_image, org.libheif.win.heif_h.heif_channel_interleaved());
                this.imageColors = 4;
                MemorySegment strideSegm = MemorySegment.allocateNative((MemoryLayout)org.libheif.win.heif_h.C_INT, (ResourceScope)scope);
                MemoryAddress image_data = org.libheif.win.heif_h.heif_image_get_plane_readonly((Addressable)heif_image, org.libheif.win.heif_h.heif_channel_interleaved(), (Addressable)strideSegm.address());
                this.stride = strideSegm.toArray(ValueLayout.JAVA_INT)[0];
                int pos = 0;
                int[] data = new int[this.imageHeight * this.imageWidth];
                for (int i = 0; i < this.imageHeight; ++i) {
                    MemoryAddress addOffset = image_data.address().addOffset((long)(this.stride * i));
                    MemorySegment asSegmentRestricted = MemorySegment.ofAddress((MemoryAddress)addOffset, (long)this.stride, (ResourceScope)scope);
                    int[] toIntArray = asSegmentRestricted.toArray(ValueLayout.JAVA_INT);
                    for (int j = 0; j < toIntArray.length; ++j) {
                        int rgba = toIntArray[j];
                        int r = rgba & 0xFF;
                        int g = rgba >> 8 & 0xFF;
                        int b = rgba >> 16 & 0xFF;
                        int a = rgba >> 24 & 0xFF;
                        data[pos] = a << 24 | r << 16 | g << 8 | b;
                        ++pos;
                    }
                }
                org.libheif.win.heif_h.heif_context_free((Addressable)heif_context_alloc);
                heif_context_alloc = null;
                int[] i = data;
                return i;
            }
            MemoryAddress heif_context_alloc = heif_h.heif_context_alloc();
            MemorySegment errorOpening = heif_h.heif_context_read_from_file(scope, (Addressable)heif_context_alloc, (Addressable)SegmentAllocator.nativeAllocator((ResourceScope)scope).allocateUtf8String(this.imageFileURL).address(), (Addressable)MemoryAddress.NULL);
            int errorcode = heif_error.code$get(errorOpening);
            if (errorcode > 0) {
                throw new IOException("Cannot open image file because reading of file data is not possible  (" + errorcode + ")!");
            }
            heif_h.heif_context_get_number_of_top_level_images((Addressable)heif_context_alloc);
            MemorySegment primary_image_handle_seg = MemorySegment.allocateNative((MemoryLayout)heif_h.C_POINTER, (ResourceScope)scope);
            MemorySegment errorhandle = heif_h.heif_context_get_primary_image_handle(scope, (Addressable)heif_context_alloc, (Addressable)primary_image_handle_seg.address());
            errorcode = heif_error.code$get(errorhandle);
            if (errorcode > 0) {
                throw new IOException("Cannot open image file because codec is not supported (" + errorcode + ")!");
            }
            MemoryAddress primary_image_handle = primary_image_handle_seg.get(ValueLayout.ADDRESS, 0L);
            int heif_image_get_primary_height = heif_h.heif_image_get_primary_height((Addressable)primary_image_handle);
            MemoryAddress heif_image = heif_h.heif_decode_image_alloc((Addressable)primary_image_handle, heif_h.heif_colorspace_RGB(), heif_h.heif_chroma_interleaved_RGBA(), (Addressable)MemoryAddress.NULL);
            this.imageHeight = heif_h.heif_image_get_height((Addressable)heif_image, heif_h.heif_channel_interleaved());
            this.imageWidth = heif_h.heif_image_get_width((Addressable)heif_image, heif_h.heif_channel_interleaved());
            this.imageBits = heif_h.heif_image_get_bits_per_pixel((Addressable)heif_image, heif_h.heif_channel_interleaved());
            this.imageColors = 4;
            MemorySegment strideSegm = MemorySegment.allocateNative((MemoryLayout)heif_h.C_INT, (ResourceScope)scope);
            MemoryAddress image_data = heif_h.heif_image_get_plane_readonly((Addressable)heif_image, heif_h.heif_channel_interleaved(), (Addressable)strideSegm.address());
            this.stride = strideSegm.toArray(ValueLayout.JAVA_INT)[0];
            int pos = 0;
            int[] data = new int[this.imageHeight * this.imageWidth];
            for (int i = 0; i < this.imageHeight; ++i) {
                MemoryAddress addOffset = image_data.address().addOffset((long)(this.stride * i));
                MemorySegment asSegmentRestricted = MemorySegment.ofAddress((MemoryAddress)addOffset, (long)this.stride, (ResourceScope)scope);
                int[] toIntArray = asSegmentRestricted.toArray(ValueLayout.JAVA_INT);
                for (int j = 0; j < toIntArray.length; ++j) {
                    int rgba = toIntArray[j];
                    int r = rgba & 0xFF;
                    int g = rgba >> 8 & 0xFF;
                    int b = rgba >> 16 & 0xFF;
                    int a = rgba >> 24 & 0xFF;
                    data[pos] = a << 24 | r << 16 | g << 8 | b;
                    ++pos;
                }
            }
            heif_h.heif_context_free((Addressable)heif_context_alloc);
            heif_context_alloc = null;
            int[] nArray = data;
            return nArray;
        }
    }

    private synchronized int[] convertToINT(byte[] rawBytes) {
        int[] raw = new int[rawBytes.length * 4 / 3];
        for (int j = 0; j < rawBytes.length / 3; ++j) {
            raw[j] = 0xFF000000 | (rawBytes[3 * j + 0] & 0xFF) << 16 | (rawBytes[3 * j + 1] & 0xFF) << 8 | rawBytes[3 * j + 2] & 0xFF;
        }
        return raw;
    }

    public HashMap<String, String> getMetaData() throws IOException {
        if (this.imageFileURL == null) {
            Logger.getLogger(LibheifImage.class.getName()).log(Level.FINEST, null, "imageFileURL == null! " + this.imageFileURL);
            throw new IllegalArgumentException("imageFileURL == null!");
        }
        if (loadLibraryFromJar == null) {
            Logger.getLogger(LibheifImage.class.getName()).log(Level.FINEST, null, "Please call loadLibs as static method first!");
            throw new IllegalArgumentException("Please call loadLibs as static method first!");
        }
        for (String strTemp : loadLibraryFromJar) {
            System.load(strTemp);
            SymbolLookup.loaderLookup();
        }
        HashMap<String, String> retMap = new HashMap<String, String>();
        FileInputStream in = new FileInputStream(new File(this.imageFileURL));
        Metadata metadata = HeifMetadataReader.readMetadata(in);
        String invalidTagNames = "Red TRC;Green TRC;Blue TRC";
        for (Directory directory : metadata.getDirectories()) {
            for (Tag tag : directory.getTags()) {
                if (invalidTagNames.contains(tag.getTagName())) continue;
                retMap.put(tag.getTagName(), tag.getDescription());
            }
        }
        return retMap;
    }

    public String getImageFileURL() {
        return this.imageFileURL;
    }

    public int getImageWidth() {
        Logger.getLogger(LibheifImage.class.getName()).log(Level.FINEST, null, "Native image width " + this.imageWidth);
        return this.imageWidth;
    }

    public int getImageHeight() {
        Logger.getLogger(LibheifImage.class.getName()).log(Level.FINEST, null, "Native image height " + this.imageHeight);
        return this.imageHeight;
    }

    public int getImageBits() {
        Logger.getLogger(LibheifImage.class.getName()).log(Level.FINEST, null, "Native image bits " + this.imageBits);
        return this.imageBits;
    }

    public int getImageColors() {
        Logger.getLogger(LibheifImage.class.getName()).log(Level.FINEST, null, "Native image colors " + this.imageColors);
        return this.imageColors;
    }

    public int getStride() {
        return this.stride;
    }

    public int getNumBands() {
        return this.imageBits / 8;
    }

    public String getCameraModel() {
        return this.cameraModel;
    }

    public LocalDateTime getShootingDateTime() {
        return this.shootingDateTime;
    }

    public String toString() {
        return "LibHeifImage{imageFileURL=" + this.imageFileURL + ", imageWidth=" + this.imageWidth + ", imageHeight=" + this.imageHeight + ", imageBits=" + this.imageBits + ", imageColors=" + this.imageColors + ", stride=" + this.stride + "}";
    }
}

