/*
 * Decompiled with CFR 0.152.
 */
package org.libheiffx;

import com.sun.javafx.iio.ImageFormatDescription;
import com.sun.javafx.iio.ImageLoader;
import com.sun.javafx.iio.ImageLoaderFactory;
import com.sun.javafx.iio.ImageStorage;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.libheiffx.HEIFDescriptor;
import org.libheiffx.HEIFImageLoader;
import org.libheiffx.LibheifImage;
import org.libheiffx.dimension.DefaultDimensionProvider;
import org.libheiffx.dimension.DimensionProvider;

public class HEIFImageLoaderFactory
implements ImageLoaderFactory {
    private static final HEIFImageLoaderFactory instance = new HEIFImageLoaderFactory();
    private static String tempDir;
    private static DimensionProvider dimensionProvider;

    public static final void install(String tempdir) {
        tempDir = tempdir;
        HEIFImageLoaderFactory.install(new DefaultDimensionProvider());
    }

    public static final void install() {
        tempDir = null;
        HEIFImageLoaderFactory.install(new DefaultDimensionProvider());
    }

    public static final void install(DimensionProvider dimensionProvider) {
        try {
            LibheifImage.loadLibs(tempDir);
        }
        catch (IOException ex) {
            Logger.getLogger(HEIFImageLoaderFactory.class.getName()).log(Level.SEVERE, null, ex);
        }
        HEIFImageLoaderFactory.dimensionProvider = dimensionProvider;
        ImageStorage.addImageLoaderFactory((ImageLoaderFactory)instance);
    }

    public static final ImageLoaderFactory getInstance() {
        return instance;
    }

    public ImageFormatDescription getFormatDescription() {
        return HEIFDescriptor.getInstance();
    }

    public ImageLoader createImageLoader(InputStream input) throws IOException {
        return new HEIFImageLoader(input, dimensionProvider);
    }
}

