/*
 * Decompiled with CFR 0.152.
 */
package org.libheif.win;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import jdk.incubator.foreign.Addressable;
import jdk.incubator.foreign.CLinker;
import jdk.incubator.foreign.FunctionDescriptor;
import jdk.incubator.foreign.GroupLayout;
import jdk.incubator.foreign.MemoryAddress;
import jdk.incubator.foreign.MemoryLayout;
import jdk.incubator.foreign.MemorySegment;
import jdk.incubator.foreign.NativeSymbol;
import jdk.incubator.foreign.ResourceScope;
import jdk.incubator.foreign.SegmentAllocator;
import jdk.incubator.foreign.SymbolLookup;
import jdk.incubator.foreign.ValueLayout;

final class RuntimeHelper {
    private static final CLinker LINKER = CLinker.systemCLinker();
    private static final ClassLoader LOADER = RuntimeHelper.class.getClassLoader();
    private static final MethodHandles.Lookup MH_LOOKUP = MethodHandles.lookup();
    private static final SymbolLookup SYMBOL_LOOKUP;
    static final SegmentAllocator CONSTANT_ALLOCATOR;
    private static final SegmentAllocator THROWING_ALLOCATOR;

    private RuntimeHelper() {
    }

    static <T> T requireNonNull(T obj, String symbolName) {
        if (obj == null) {
            throw new UnsatisfiedLinkError("unresolved symbol: " + symbolName);
        }
        return obj;
    }

    static final MemorySegment lookupGlobalVariable(String name, MemoryLayout layout) {
        return SYMBOL_LOOKUP.lookup(name).map(symbol -> MemorySegment.ofAddress((MemoryAddress)symbol.address(), (long)layout.byteSize(), (ResourceScope)ResourceScope.newSharedScope())).orElse(null);
    }

    static final MethodHandle downcallHandle(String name, FunctionDescriptor fdesc, boolean variadic) {
        return SYMBOL_LOOKUP.lookup(name).map(addr -> variadic ? VarargsInvoker.make(addr, fdesc) : LINKER.downcallHandle(addr, fdesc)).orElse(null);
    }

    static final MethodHandle downcallHandle(FunctionDescriptor fdesc, boolean variadic) {
        if (variadic) {
            throw new AssertionError((Object)"Cannot get here!");
        }
        return LINKER.downcallHandle(fdesc);
    }

    static final <Z> NativeSymbol upcallStub(Class<Z> fi, Z z, FunctionDescriptor fdesc, String mtypeDesc, ResourceScope scope) {
        try {
            MethodHandle handle = MH_LOOKUP.findVirtual(fi, "apply", MethodType.fromMethodDescriptorString(mtypeDesc, LOADER));
            handle = handle.bindTo(z);
            return LINKER.upcallStub(handle, fdesc, scope);
        }
        catch (Throwable ex) {
            throw new AssertionError((Object)ex);
        }
    }

    static MemorySegment asArray(MemoryAddress addr, MemoryLayout layout, int numElements, ResourceScope scope) {
        return MemorySegment.ofAddress((MemoryAddress)addr, (long)((long)numElements * layout.byteSize()), (ResourceScope)scope);
    }

    static {
        CONSTANT_ALLOCATOR = (size, align) -> MemorySegment.allocateNative((long)size, (long)align, (ResourceScope)ResourceScope.newImplicitScope());
        SymbolLookup loaderLookup = SymbolLookup.loaderLookup();
        SYMBOL_LOOKUP = name -> loaderLookup.lookup(name).or(() -> LINKER.lookup(name));
        THROWING_ALLOCATOR = (x, y) -> {
            throw new AssertionError((Object)"should not reach here");
        };
    }

    private static class VarargsInvoker {
        private static final MethodHandle INVOKE_MH;
        private final NativeSymbol symbol;
        private final FunctionDescriptor function;

        private VarargsInvoker(NativeSymbol symbol, FunctionDescriptor function) {
            this.symbol = symbol;
            this.function = function;
        }

        static MethodHandle make(NativeSymbol symbol, FunctionDescriptor function) {
            VarargsInvoker invoker = new VarargsInvoker(symbol, function);
            MethodHandle handle = INVOKE_MH.bindTo(invoker).asCollector(Object[].class, function.argumentLayouts().size() + 1);
            MethodType mtype = MethodType.methodType(function.returnLayout().isPresent() ? VarargsInvoker.carrier((MemoryLayout)function.returnLayout().get(), true) : Void.TYPE);
            for (MemoryLayout layout : function.argumentLayouts()) {
                mtype = mtype.appendParameterTypes(VarargsInvoker.carrier(layout, false));
            }
            if ((mtype = mtype.appendParameterTypes(Object[].class)).returnType().equals(MemorySegment.class)) {
                mtype = mtype.insertParameterTypes(0, SegmentAllocator.class);
            } else {
                handle = MethodHandles.insertArguments(handle, 0, THROWING_ALLOCATOR);
            }
            return handle.asType(mtype);
        }

        static Class<?> carrier(MemoryLayout layout, boolean ret) {
            if (layout instanceof ValueLayout) {
                ValueLayout valueLayout = (ValueLayout)layout;
                return ret || valueLayout.carrier() != MemoryAddress.class ? valueLayout.carrier() : Addressable.class;
            }
            if (layout instanceof GroupLayout) {
                return MemorySegment.class;
            }
            throw new AssertionError((Object)"Cannot get here!");
        }

        private Object invoke(SegmentAllocator allocator, Object[] args) throws Throwable {
            int nNamedArgs = this.function.argumentLayouts().size();
            assert (args.length == nNamedArgs + 1);
            Object[] unnamedArgs = (Object[])args[args.length - 1];
            int argsCount = nNamedArgs + unnamedArgs.length;
            Class[] argTypes = new Class[argsCount];
            MemoryLayout[] argLayouts = new MemoryLayout[nNamedArgs + unnamedArgs.length];
            int pos = 0;
            for (pos = 0; pos < nNamedArgs; ++pos) {
                argLayouts[pos] = (MemoryLayout)this.function.argumentLayouts().get(pos);
            }
            assert (pos == nNamedArgs);
            for (Object o : unnamedArgs) {
                argLayouts[pos] = this.variadicLayout(this.normalize(o.getClass()));
                ++pos;
            }
            assert (pos == argsCount);
            FunctionDescriptor f = this.function.returnLayout().isEmpty() ? FunctionDescriptor.ofVoid((MemoryLayout[])argLayouts) : FunctionDescriptor.of((MemoryLayout)((MemoryLayout)this.function.returnLayout().get()), (MemoryLayout[])argLayouts);
            MethodHandle mh = LINKER.downcallHandle(this.symbol, f);
            if (mh.type().returnType() == MemorySegment.class) {
                mh = mh.bindTo(allocator);
            }
            Object[] allArgs = new Object[nNamedArgs + unnamedArgs.length];
            System.arraycopy(args, 0, allArgs, 0, nNamedArgs);
            System.arraycopy(unnamedArgs, 0, allArgs, nNamedArgs, unnamedArgs.length);
            return mh.asSpreader(Object[].class, argsCount).invoke(allArgs);
        }

        private static Class<?> unboxIfNeeded(Class<?> clazz) {
            if (clazz == Boolean.class) {
                return Boolean.TYPE;
            }
            if (clazz == Void.class) {
                return Void.TYPE;
            }
            if (clazz == Byte.class) {
                return Byte.TYPE;
            }
            if (clazz == Character.class) {
                return Character.TYPE;
            }
            if (clazz == Short.class) {
                return Short.TYPE;
            }
            if (clazz == Integer.class) {
                return Integer.TYPE;
            }
            if (clazz == Long.class) {
                return Long.TYPE;
            }
            if (clazz == Float.class) {
                return Float.TYPE;
            }
            if (clazz == Double.class) {
                return Double.TYPE;
            }
            return clazz;
        }

        private Class<?> promote(Class<?> c) {
            if (c == Byte.TYPE || c == Character.TYPE || c == Short.TYPE || c == Integer.TYPE) {
                return Long.TYPE;
            }
            if (c == Float.TYPE) {
                return Double.TYPE;
            }
            return c;
        }

        private Class<?> normalize(Class<?> c) {
            if ((c = VarargsInvoker.unboxIfNeeded(c)).isPrimitive()) {
                return this.promote(c);
            }
            if (MemoryAddress.class.isAssignableFrom(c)) {
                return MemoryAddress.class;
            }
            if (MemorySegment.class.isAssignableFrom(c)) {
                return MemorySegment.class;
            }
            throw new IllegalArgumentException("Invalid type for ABI: " + c.getTypeName());
        }

        private MemoryLayout variadicLayout(Class<?> c) {
            if (c == Long.TYPE) {
                return ValueLayout.JAVA_LONG;
            }
            if (c == Double.TYPE) {
                return ValueLayout.JAVA_DOUBLE;
            }
            if (MemoryAddress.class.isAssignableFrom(c)) {
                return ValueLayout.ADDRESS;
            }
            throw new IllegalArgumentException("Unhandled variadic argument class: " + c);
        }

        static {
            try {
                INVOKE_MH = MethodHandles.lookup().findVirtual(VarargsInvoker.class, "invoke", MethodType.methodType(Object.class, SegmentAllocator.class, Object[].class));
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

