/*
 * Decompiled with CFR 0.152.
 */
package org.laxture.sbp.internal;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.pf4j.ClassLoadingStrategy;
import org.pf4j.PluginClassLoader;
import org.pf4j.PluginDependency;
import org.pf4j.PluginDescriptor;
import org.pf4j.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringBootPluginClassLoader
extends PluginClassLoader {
    private static final Logger log = LoggerFactory.getLogger(SpringBootPluginClassLoader.class);
    private List<String> pluginFirstClasses;
    private List<String> pluginOnlyResources;
    private PluginManager pluginManager;
    private PluginDescriptor pluginDescriptor;

    public SpringBootPluginClassLoader(PluginManager pluginManager, PluginDescriptor pluginDescriptor, ClassLoader parent) {
        super(pluginManager, pluginDescriptor, parent, ClassLoadingStrategy.APD);
        this.pluginManager = pluginManager;
        this.pluginDescriptor = pluginDescriptor;
    }

    public void setPluginFirstClasses(@NonNull List<String> pluginFirstClasses) {
        if (pluginFirstClasses == null) {
            throw new NullPointerException("pluginFirstClasses is marked non-null but is null");
        }
        this.pluginFirstClasses = pluginFirstClasses.stream().map(pluginFirstClass -> pluginFirstClass.replaceAll(".", "[$0]").replace("[*]", ".*?").replace("[?]", ".?")).collect(Collectors.toList());
    }

    public void setPluginOnlyResources(@NonNull List<String> pluginOnlyResources) {
        if (pluginOnlyResources == null) {
            throw new NullPointerException("pluginOnlyResources is marked non-null but is null");
        }
        this.pluginOnlyResources = pluginOnlyResources.stream().map(pluginFirstClass -> pluginFirstClass.replaceAll(".", "[$0]").replace("[*]", ".*?").replace("[?]", ".?")).collect(Collectors.toList());
    }

    public URL getResource(String name) {
        if (name.endsWith(".class")) {
            return super.getResource(name);
        }
        URL url = this.findResource(name);
        if (url != null) {
            log.trace("Found resource '{}' in plugin classpath", (Object)name);
            return url;
        }
        log.trace("Couldn't find resource '{}' in plugin classpath. Delegating to parent", (Object)name);
        return super.getResource(name);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        if (name.endsWith(".class")) {
            return super.getResources(name);
        }
        return this.isPluginOnlyResources(name) ? this.findResources(name) : super.getResources(name);
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        if (this.isPluginFirstClass(className)) {
            try {
                return this.loadClassFromPlugin(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return super.loadClass(className);
    }

    private boolean isPluginFirstClass(String name) {
        if (this.pluginFirstClasses == null || this.pluginFirstClasses.size() <= 0) {
            return false;
        }
        for (String pluginFirstClass : this.pluginFirstClasses) {
            if (!name.matches(pluginFirstClass)) continue;
            return true;
        }
        return false;
    }

    private boolean isPluginOnlyResources(String name) {
        if (this.pluginOnlyResources == null || this.pluginOnlyResources.size() <= 0) {
            return false;
        }
        for (String pluginOnlyResource : this.pluginOnlyResources) {
            if (!name.matches(pluginOnlyResource)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> loadClassFromPlugin(String className) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(className);
        synchronized (object) {
            log.trace("Received request to load class '{}'", (Object)className);
            Class loadedClass = this.findLoadedClass(className);
            if (loadedClass != null) {
                log.trace("Found loaded class '{}'", (Object)className);
                return loadedClass;
            }
            try {
                loadedClass = this.findClass(className);
                log.trace("Found class '{}' in plugin classpath", (Object)className);
                return loadedClass;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return this.loadClassFromDependencies(className);
            }
        }
    }

    protected Class<?> getLoadedClass(String className) {
        return this.findLoadedClass(className);
    }

    protected Class<?> loadClassFromDependencies(String className) {
        log.trace("Search in dependencies for class '{}'", (Object)className);
        List dependencies = this.pluginDescriptor.getDependencies();
        for (PluginDependency dependency : dependencies) {
            ClassLoader classLoader = this.pluginManager.getPluginClassLoader(dependency.getPluginId());
            if (classLoader == null && dependency.isOptional()) continue;
            try {
                if (classLoader instanceof SpringBootPluginClassLoader) {
                    Class<?> clazz = ((SpringBootPluginClassLoader)((Object)classLoader)).getLoadedClass(className);
                    if (clazz != null) {
                        return clazz;
                    }
                    clazz = ((SpringBootPluginClassLoader)((Object)classLoader)).loadClassFromDependencies(className);
                    if (clazz == null) continue;
                    return clazz;
                }
                return classLoader.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    protected URL findResourceFromDependencies(String name) {
        if (!name.endsWith(".class")) {
            return null;
        }
        return super.findResourceFromDependencies(name);
    }

    protected Collection<URL> findResourcesFromDependencies(String name) throws IOException {
        if (!name.endsWith(".class")) {
            return Collections.emptyList();
        }
        return super.findResourcesFromDependencies(name);
    }
}

