/*
 * Decompiled with CFR 0.152.
 */
package org.kiwitcms.java.junit;

import java.util.HashMap;
import java.util.List;
import net.minidev.json.JSONObject;
import org.kiwitcms.java.api.RpcClient;
import org.kiwitcms.java.config.Config;
import org.kiwitcms.java.model.Build;
import org.kiwitcms.java.model.Priority;
import org.kiwitcms.java.model.TestCase;
import org.kiwitcms.java.model.TestExecution;
import org.kiwitcms.java.model.TestExecutionStatus;
import org.kiwitcms.java.model.TestMethod;
import org.kiwitcms.java.model.TestRun;
import org.kiwitcms.java.model.Version;

public class TestDataEmitter {
    private static Integer productId;
    private static Integer planId;
    private static Integer runId;
    private RpcClient client;
    private TestCase[] casesInTestRun;
    Config config = Config.getInstance();

    public TestDataEmitter() {
        this.client = new RpcClient();
        this.client.login(this.config.getUsername(), this.config.getPassword());
    }

    public int getProductId() {
        String productName = this.config.getProduct();
        if (productId == null) {
            productId = this.client.getProductId(productName);
        }
        if (productId == null) {
            productId = this.client.createNewProduct(productName).getId();
        }
        return productId;
    }

    public void closeSession() {
        this.client.logout();
    }

    public int getPlanId() {
        if (planId == null) {
            TestRun run;
            Integer confRunId = this.config.getRunId();
            if (confRunId != null && (run = this.client.getRun(confRunId)) != null) {
                planId = run.getPlan();
                return planId;
            }
            int productId = this.getProductId();
            int versionId = this.getVersion(productId);
            String name = String.format("[JUnit] Plan for %s (%s)", this.config.getProduct(), this.config.getProductVersion());
            planId = this.client.getTestPlanId(name, productId);
            if (planId < 0) {
                planId = this.client.createNewTP(productId, name, versionId).getId();
            }
        }
        return planId;
    }

    public int getTestRunId() {
        if (runId == null) {
            Integer testRun = this.config.getRunId();
            if (testRun != null) {
                runId = this.client.getRun(testRun).getId();
            }
            if (runId == null) {
                runId = this.client.createNewRun(this.getBuild(this.getVersion(this.getProductId())), this.config.getUsername(), this.getPlanId(), String.format("[JUnit] Results for %s, %s, %s", this.config.getProduct(), this.config.getProductVersion(), this.config.getBuild())).getId();
            }
        }
        this.casesInTestRun = this.client.getRunIdTestCases(runId);
        return runId;
    }

    public void addTestResultsToRun(int runId, List<TestMethod> tests) {
        int productId = this.getProductId();
        int categoryId = this.getAvailableCategoryId(productId);
        int priorityId = this.getAvailablePriorityId();
        int testPlanId = this.getPlanId();
        for (TestMethod test : tests) {
            TestExecution[] executions;
            TestCase testCase = this.client.getOrCreateTestCase(productId, categoryId, priorityId, test.getSummary());
            this.client.addTestCaseToPlan(testPlanId, testCase.getCaseId());
            for (TestExecution testExecution : executions = this.client.addTestCaseToRunId(runId, testCase.getCaseId())) {
                this.client.updateTestExecution(testExecution.getTcRunId(), this.getTestExecutionStatusId(test.result));
            }
        }
    }

    private int getTestExecutionStatusId(String result) {
        TestExecutionStatus status = null;
        switch (result) {
            case "PASS": {
                status = this.client.getTestExecutionStatus("PASSED", "__gt");
                break;
            }
            case "FAIL": {
                status = this.client.getTestExecutionStatus("FAILED", "__lt");
                break;
            }
            default: {
                status = this.client.getTestExecutionStatus(result, "");
            }
        }
        return status.getId();
    }

    public int getBuild(int versionId) {
        String confBuild = this.config.getBuild();
        HashMap<String, Object> filter = new HashMap<String, Object>();
        filter.put("version", versionId);
        if (confBuild != null) {
            filter.put("name", confBuild);
            Build[] existingBuilds = this.client.getBuilds(filter);
            if (existingBuilds.length > 0) {
                return existingBuilds[0].getId();
            }
            Build newBuild = this.client.createBuild(confBuild, versionId);
            if (newBuild != null) {
                return newBuild.getId();
            }
        }
        return this.client.getBuilds(filter)[0].getId();
    }

    public int getVersion(int productId) {
        String confVersion = this.config.getProductVersion();
        HashMap<String, Object> filter = new HashMap<String, Object>();
        filter.put("product", productId);
        if (confVersion != null) {
            filter.put("value", confVersion);
            Version[] existingVersions = this.client.getVersions(filter);
            if (existingVersions.length > 0) {
                return existingVersions[0].getId();
            }
            Version newVersion = this.client.createProductVersion(confVersion, productId);
            if (newVersion != null) {
                return newVersion.getId();
            }
        }
        return this.client.getVersions(filter)[0].getId();
    }

    public int getAvailablePriorityId() {
        HashMap<String, Object> filter = new HashMap<String, Object>();
        filter.put("is_active", "True");
        Priority[] existingPriorities = this.client.getPriority(filter);
        return existingPriorities[0].getId();
    }

    public int getAvailableCategoryId(int productId) {
        HashMap<String, Object> filter = new HashMap<String, Object>();
        filter.put("product", productId);
        Object id = ((JSONObject)this.client.getCategory(filter).get(0)).get((Object)"id");
        return Integer.parseInt(String.valueOf(id));
    }
}

