/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.metadata.client.widget;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.inject.Inject;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.kie.workbench.common.widgets.metadata.client.widget.TagWidgetView;
import org.kie.workbench.common.widgets.metadata.client.widget.TagWidgetViewImpl;

public class TagWidget
implements IsWidget {
    private Metadata data;
    private TagWidgetView view;
    private boolean readOnly;

    @Inject
    public void setView(TagWidgetView view) {
        this.view = view;
        view.setPresenter(this);
    }

    public void setContent(Metadata d, boolean readOnly) {
        this.data = d;
        this.readOnly = readOnly;
        this.view.setReadOnly(readOnly);
        this.loadData();
    }

    public void onAddTags(String text) {
        if (text != null) {
            String[] tags;
            for (String tag : tags = text.split(" ")) {
                if (this.data.getTags().contains(tag)) continue;
                this.data.addTag(tag);
                this.view.addTag(tag, this.readOnly);
            }
        }
    }

    public void onRemoveTag(String tag) {
        this.data.getTags().remove(tag);
        this.loadData();
    }

    public void loadData() {
        this.view.clear();
        for (String tag : this.data.getTags()) {
            this.view.addTag(tag, this.readOnly);
        }
    }

    public Widget asWidget() {
        if (this.view == null) {
            this.initView();
        }
        return this.view.asWidget();
    }

    private void initView() {
        this.setView(new TagWidgetViewImpl());
    }
}

