/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.metadata.client.widget;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import javax.inject.Inject;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.gwtbootstrap3.client.ui.NavTabs;
import org.gwtbootstrap3.client.ui.TabContent;
import org.gwtbootstrap3.client.ui.TabListItem;
import org.gwtbootstrap3.client.ui.TabPane;
import org.gwtbootstrap3.client.ui.TextArea;
import org.kie.workbench.common.widgets.client.discussion.DiscussionWidgetPresenter;
import org.kie.workbench.common.widgets.metadata.client.resources.i18n.MetadataConstants;
import org.kie.workbench.common.widgets.metadata.client.widget.MetadataWidget;
import org.kie.workbench.common.widgets.metadata.client.widget.OverviewScreenView;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.impl.LockInfo;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.editor.commons.client.history.VersionHistoryPresenter;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.mvp.ParameterizedCommand;

public class OverviewWidgetViewImpl
extends Composite
implements OverviewScreenView {
    private static final int VERSION_HISTORY_TAB = 0;
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    @UiField
    TextArea description;
    @UiField
    Label resourceType;
    @UiField
    Label projects;
    @UiField
    Label lastModifiedLabel;
    @UiField
    Label createdLabel;
    @UiField
    NavTabs navTabs;
    @UiField
    TabContent tabContent;
    @UiField(provided=true)
    DiscussionWidgetPresenter discussionArea;
    VersionHistoryPresenter versionHistory;
    MetadataWidget metadata;
    private OverviewScreenView.Presenter presenter;

    public OverviewWidgetViewImpl() {
    }

    @Inject
    public OverviewWidgetViewImpl(final MetadataWidget metadata, DiscussionWidgetPresenter discussionArea, final VersionHistoryPresenter versionHistory) {
        this.metadata = metadata;
        this.discussionArea = discussionArea;
        this.versionHistory = versionHistory;
        versionHistory.setOnCurrentVersionRefreshed((ParameterizedCommand)new ParameterizedCommand<VersionRecord>(){

            public void execute(VersionRecord record) {
                metadata.setNote(record.comment());
                OverviewWidgetViewImpl.this.setLastModified(record.author(), record.date());
            }
        });
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        final TabPane versionHistoryPane = new TabPane(){
            {
                this.add((IsWidget)versionHistory);
            }
        };
        final TabPane metadataPane = new TabPane(){
            {
                this.add((Widget)metadata);
            }
        };
        this.tabContent.add((Widget)versionHistoryPane);
        this.tabContent.add((Widget)metadataPane);
        this.navTabs.add((Widget)new TabListItem(MetadataConstants.INSTANCE.VersionHistory()){
            {
                super(text);
                this.addStyleName("uf-dropdown-tab-list-item");
                this.setDataTargetWidget((Widget)versionHistoryPane);
                this.setActive(true);
            }
        });
        this.navTabs.add((Widget)new TabListItem(MetadataConstants.INSTANCE.Metadata()){
            {
                super(text);
                this.addStyleName("uf-dropdown-tab-list-item");
                this.setDataTargetWidget((Widget)metadataPane);
            }
        });
        this.navTabs.getElement().setAttribute("data-uf-lock", "false");
        versionHistoryPane.setActive(true);
    }

    @Override
    public void setPresenter(OverviewScreenView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setReadOnly(boolean isReadOnly) {
        this.description.setEnabled(!isReadOnly);
    }

    @Override
    public void setVersionHistory(Path path) {
        this.versionHistory.init(path);
    }

    @Override
    public void setDescription(String description) {
        this.description.setText(description);
    }

    @UiHandler(value={"description"})
    public void onDescriptionChange(KeyUpEvent event) {
        this.presenter.onDescriptionEdited(this.description.getText());
    }

    @Override
    public void setResourceType(ClientResourceType type) {
        this.resourceType.setText(type.getDescription());
    }

    @Override
    public void setProject(String project) {
        this.projects.setText(project);
    }

    @Override
    public void setLastModified(String lastContributor, Date lastModified) {
        this.lastModifiedLabel.setText(MetadataConstants.INSTANCE.ByAOnB(lastContributor, DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_SHORT).format(lastModified)));
    }

    @Override
    public void setCreated(String creator, Date dateCreated) {
        this.createdLabel.setText(MetadataConstants.INSTANCE.ByAOnB(creator, DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_SHORT).format(dateCreated)));
    }

    @Override
    public void showVersionHistory() {
        ((TabListItem)this.navTabs.getWidget(0)).showTab();
    }

    @Override
    public void setMetadata(Metadata metadata, boolean isReadOnly) {
        this.metadata.setContent(metadata, isReadOnly);
        this.discussionArea.setContent(metadata);
    }

    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    public void hideBusyIndicator() {
        BusyPopup.close();
    }

    public Widget asWidget() {
        return super.asWidget();
    }

    @Override
    public void refresh(String version) {
        this.versionHistory.refresh(version);
    }

    @Override
    public void setForceUnlockHandler(Runnable handler) {
        this.metadata.setForceUnlockHandler(handler);
    }

    @Override
    public void setCurrentUser(String currentUser) {
        this.metadata.setCurrentUser(currentUser);
    }

    @Override
    public void setLockStatus(LockInfo lockInfo) {
        this.metadata.setLockStatus(lockInfo);
    }

    static interface Binder
    extends UiBinder<Widget, OverviewWidgetViewImpl> {
    }
}

