/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.metadata.client.widget;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jboss.errai.security.shared.api.identity.User;
import org.kie.workbench.common.widgets.metadata.client.widget.OverviewScreenView;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.impl.ForceUnlockEvent;
import org.uberfire.backend.vfs.impl.LockInfo;
import org.uberfire.client.workbench.type.ClientTypeRegistry;

@Dependent
public class OverviewWidgetPresenter
implements OverviewScreenView.Presenter,
IsWidget {
    private ClientTypeRegistry clientTypeRegistry;
    private Overview overview;
    private boolean isReadOnly = false;
    private OverviewScreenView view;
    private int originalHash;
    @Inject
    private Event<ForceUnlockEvent> lockReleaseEvent;
    @Inject
    User user;

    public OverviewWidgetPresenter() {
    }

    @Inject
    public OverviewWidgetPresenter(ClientTypeRegistry clientTypeRegistry, OverviewScreenView view) {
        this.view = view;
        view.setPresenter(this);
        this.clientTypeRegistry = clientTypeRegistry;
    }

    public void setContent(final Overview overview, ObservablePath path) {
        this.overview = overview;
        this.originalHash = this.overview.hashCode();
        this.view.setVersionHistory((Path)path);
        this.view.setResourceType(this.clientTypeRegistry.resolve((Path)path));
        this.view.setProject(overview.getProjectName());
        this.view.setMetadata(overview.getMetadata(), this.isReadOnly);
        this.view.setDescription(overview.getMetadata().getDescription());
        this.view.setLastModified(overview.getMetadata().getLastContributor(), overview.getMetadata().getLastModified());
        this.view.setCreated(overview.getMetadata().getCreator(), overview.getMetadata().getDateCreated());
        this.view.hideBusyIndicator();
        this.view.setForceUnlockHandler(new Runnable(){

            @Override
            public void run() {
                OverviewWidgetPresenter.this.lockReleaseEvent.fire((Object)new ForceUnlockEvent(overview.getMetadata().getPath()));
            }
        });
        this.view.setCurrentUser(this.user.getIdentifier());
    }

    @Override
    public void onDescriptionEdited(String description) {
        this.overview.getMetadata().setDescription(description);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void showVersionsTab() {
        this.view.showVersionHistory();
    }

    public void refresh(String version) {
        this.view.refresh(version);
    }

    public boolean isDirty() {
        if (this.overview == null) {
            return false;
        }
        return this.originalHash != this.overview.hashCode();
    }

    public void resetDirty() {
        if (this.overview != null) {
            this.originalHash = this.overview.hashCode();
        }
    }

    public void onForceLockRelease(Path path) {
        this.lockReleaseEvent.fire((Object)new ForceUnlockEvent(path));
    }

    void onLockChange(@Observes LockInfo lockInfo) {
        if (this.overview != null && this.overview.getMetadata() != null && lockInfo.getFile().equals(this.overview.getMetadata().getPath())) {
            this.overview.getMetadata().setLockInfo(lockInfo);
            this.view.setLockStatus(lockInfo);
        }
    }
}

