/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.metadata.client.widget;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.Widget;
import javax.inject.Inject;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.gwtbootstrap3.client.ui.FormControlStatic;
import org.gwtbootstrap3.client.ui.TextBox;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.widgets.metadata.client.resources.ImageResources;
import org.kie.workbench.common.widgets.metadata.client.resources.i18n.MetadataConstants;
import org.kie.workbench.common.widgets.metadata.client.widget.ExternalLinkPresenter;
import org.kie.workbench.common.widgets.metadata.client.widget.TagWidget;
import org.uberfire.backend.vfs.impl.LockInfo;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.ext.widgets.common.client.common.popups.YesNoCancelPopup;
import org.uberfire.mvp.Command;

public class MetadataWidget
extends Composite
implements HasBusyIndicator {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    @UiField
    TagWidget tags;
    @UiField
    FormControlStatic note;
    @UiField
    FormControlStatic uri;
    @UiField
    TextBox subject;
    @UiField
    TextBox type;
    @UiField(provided=true)
    ExternalLinkPresenter external;
    @UiField
    TextBox source;
    @UiField
    FormControlStatic lockedBy;
    @UiField
    PushButton unlock;
    private Metadata metadata = null;
    private boolean readOnly;
    private Runnable forceUnlockHandler;
    private String currentUser;
    private BusyIndicatorView busyIndicatorView;

    @Inject
    public MetadataWidget(BusyIndicatorView busyIndicatorView, ExternalLinkPresenter external) {
        this.external = external;
        this.busyIndicatorView = busyIndicatorView;
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
    }

    public void setContent(Metadata metadata, boolean readOnly) {
        this.metadata = (Metadata)PortablePreconditions.checkNotNull((String)"metadata", (Object)metadata);
        this.readOnly = readOnly;
        this.loadData();
    }

    public void setForceUnlockHandler(Runnable forceUnlockHandler) {
        this.forceUnlockHandler = forceUnlockHandler;
    }

    public void setCurrentUser(String currentUser) {
        this.currentUser = currentUser;
    }

    private void loadData() {
        this.tags.setContent(this.metadata, this.readOnly);
        this.note.setText(this.metadata.getCheckinComment());
        this.uri.setText(this.metadata.getRealPath().toURI());
        this.subject.setText(this.metadata.getSubject());
        this.subject.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                MetadataWidget.this.metadata.setSubject(MetadataWidget.this.subject.getText());
            }
        });
        this.type.setText(this.metadata.getType());
        this.type.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                MetadataWidget.this.metadata.setType(MetadataWidget.this.type.getText());
            }
        });
        this.external.setLink(this.metadata.getExternalRelation());
        this.external.addChangeCallback(new Callback<String>(){

            public void callback(String result) {
                MetadataWidget.this.metadata.setExternalRelation(result);
            }
        });
        this.source.setText(this.metadata.getExternalSource());
        this.source.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                MetadataWidget.this.metadata.setExternalSource(MetadataWidget.this.source.getText());
            }
        });
        this.setLockStatus(this.metadata.getLockInfo());
    }

    public void setLockStatus(LockInfo lockInfo) {
        this.lockedBy.setText(this.getLockStatusText(lockInfo));
        this.maybeShowForceUnlockButton(lockInfo);
    }

    String getLockStatusText(LockInfo lockInfo) {
        String lockStatusText = lockInfo.isLocked() ? (lockInfo.lockedBy().equals(this.currentUser) ? MetadataConstants.INSTANCE.LockedByHintOwned() : MetadataConstants.INSTANCE.LockedByHint() + " " + lockInfo.lockedBy()) : MetadataConstants.INSTANCE.UnlockedHint();
        return lockStatusText;
    }

    private void maybeShowForceUnlockButton(LockInfo lockInfo) {
        Image unlockImage = new Image(ImageResources.INSTANCE.unlock());
        this.unlock.setHTML("<span>" + unlockImage.toString() + " " + this.unlock.getText() + "</span>");
        this.unlock.getElement().setAttribute("data-uf-lock", "false");
        this.unlock.setVisible(lockInfo.isLocked());
        this.unlock.setEnabled(true);
    }

    @Deprecated
    public Metadata getContent() {
        return this.metadata;
    }

    public void showBusyIndicator(String message) {
        this.busyIndicatorView.showBusyIndicator(message);
    }

    public void hideBusyIndicator() {
        this.busyIndicatorView.hideBusyIndicator();
    }

    public void setNote(String text) {
        this.note.setText(text);
    }

    @UiHandler(value={"unlock"})
    public void onForceUnlock(ClickEvent e) {
        YesNoCancelPopup yesNoCancelPopup = YesNoCancelPopup.newYesNoCancelPopup((String)MetadataConstants.INSTANCE.ForceUnlockConfirmationTitle(), (String)MetadataConstants.INSTANCE.ForceUnlockConfirmationText(this.metadata.getLockInfo().lockedBy()), (Command)new Command(){

            public void execute() {
                MetadataWidget.this.forceUnlockHandler.run();
                MetadataWidget.this.unlock.setEnabled(false);
            }
        }, (Command)new Command(){

            public void execute() {
            }
        }, null);
        yesNoCancelPopup.setClosable(false);
        yesNoCancelPopup.show();
    }

    static interface Binder
    extends UiBinder<Widget, MetadataWidget> {
    }
}

