/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.metadata.client.widget;

import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Composite;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.TextInput;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.SinkNative;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.widgets.metadata.client.resources.i18n.MetadataConstants;
import org.kie.workbench.common.widgets.metadata.client.widget.ExternalLinkPresenter;
import org.kie.workbench.common.widgets.metadata.client.widget.ExternalLinkView;

@Dependent
@Templated
public class ExternalLinkViewImpl
extends Composite
implements ExternalLinkView {
    @Inject
    @DataField(value="link")
    Anchor link;
    @Inject
    @DataField(value="linkTextBox")
    TextInput linkTextBox;
    @Inject
    @DataField(value="editButton")
    Button editButton;
    private ExternalLinkPresenter presenter;

    @Override
    public void init(ExternalLinkPresenter presenter) {
        this.presenter = presenter;
        this.link.setTitle(MetadataConstants.INSTANCE.ExternalLinkTip());
    }

    @Override
    public void setEditModeVisibility(boolean editModeVisible) {
        this.linkTextBox.getStyle().setProperty("visibility", this.getVisibility(editModeVisible));
    }

    @Override
    public void setLinkModeVisibility(boolean linkModeVisible) {
        this.editButton.getStyle().setProperty("visibility", this.getVisibility(linkModeVisible));
        this.link.getStyle().setProperty("visibility", this.getVisibility(linkModeVisible));
        if (linkModeVisible) {
            this.editButton.getStyle().removeProperty("width");
            this.editButton.getStyle().removeProperty("border");
            this.editButton.getStyle().removeProperty("padding");
        } else {
            this.link.setInnerHTML("");
            this.link.getStyle().setProperty("width", "0px");
            this.editButton.getStyle().setProperty("width", "0px");
            this.editButton.getStyle().setProperty("border", "0px");
            this.editButton.getStyle().setProperty("padding", "0px");
        }
    }

    private String getVisibility(boolean visible) {
        if (visible) {
            return "visible";
        }
        return "hidden";
    }

    @Override
    public void setLink(String value) {
        this.link.setHref(value);
        this.link.setInnerHTML(value);
    }

    @Override
    public void setText(String value) {
        this.linkTextBox.setValue(value);
    }

    @Override
    public String getTextBoxText() {
        return this.linkTextBox.getValue();
    }

    @EventHandler(value={"linkTextBox"})
    @SinkNative(value=5632)
    public void onLinkTextBoxEvents(Event event) {
        if (event.getTypeInt() == 4096) {
            this.presenter.onTextChangeDone();
        } else {
            this.presenter.onTextChange(this.linkTextBox.getValue());
        }
    }

    @EventHandler(value={"editButton"})
    @SinkNative(value=1)
    public void onEdit(Event event) {
        this.presenter.onEdit();
    }
}

