/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.metadata.client.widget;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.inject.Inject;
import org.kie.workbench.common.widgets.metadata.client.widget.ExternalLinkView;
import org.uberfire.client.callbacks.Callback;

public class ExternalLinkPresenter
implements IsWidget {
    private ExternalLinkView view;
    private Callback<String> callback;

    @Inject
    public ExternalLinkPresenter(ExternalLinkView view) {
        this.view = view;
        this.view.init(this);
    }

    public void onEdit() {
        this.showEdit();
    }

    private void showEdit() {
        this.view.setLinkModeVisibility(false);
        this.view.setEditModeVisibility(true);
    }

    private void showLink() {
        this.view.setLinkModeVisibility(true);
        this.view.setEditModeVisibility(false);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void setLink(String text) {
        if (text == null || text.trim().isEmpty()) {
            this.view.setText("");
            this.showEdit();
        } else {
            this.showLink();
            this.view.setText(text);
            this.view.setLink(text);
        }
    }

    public void addChangeCallback(Callback<String> callback) {
        this.callback = callback;
    }

    public void onTextChange(String text) {
        if (this.callback == null) {
            throw new IllegalStateException("Callback is not set.");
        }
        this.callback.callback((Object)text);
    }

    public void onTextChangeDone() {
        this.view.setLink(this.view.getTextBoxText());
        this.showLink();
    }
}

