/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.metadata.client.validation;

import javax.inject.Inject;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.client.security.ProjectController;
import org.uberfire.client.promise.Promises;
import org.uberfire.ext.editor.commons.client.validation.ValidationErrorReason;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.client.validation.ValidatorCallback;
import org.uberfire.ext.editor.commons.client.validation.ValidatorWithReasonCallback;

public abstract class BaseAssetUpdateValidator
implements Validator {
    @Inject
    protected WorkspaceProjectContext workbenchContext;
    @Inject
    protected ProjectController projectController;
    @Inject
    protected Promises promises;

    public void validate(String value, ValidatorCallback callback) {
        this.workbenchContext.getActiveWorkspaceProject().ifPresent(activeProject -> this.projectController.canUpdateProject(activeProject).then(canUpdateProject -> {
            if (canUpdateProject.booleanValue()) {
                if (value != null) {
                    this.getFileNameValidator().validate(value, callback);
                } else {
                    callback.onSuccess();
                }
            } else if (callback instanceof ValidatorWithReasonCallback) {
                ((ValidatorWithReasonCallback)callback).onFailure(ValidationErrorReason.NOT_ALLOWED.name());
            } else {
                callback.onFailure();
            }
            return this.promises.resolve();
        }));
    }

    protected abstract Validator getFileNameValidator();
}

