/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.metadata.client.popups;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.NodeList;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.widgets.metadata.client.popups.SelectDocumentPopupPresenter;
import org.kie.workbench.common.widgets.metadata.client.popups.SelectDocumentPopupView;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;

@Dependent
@Templated
public class SelectDocumentPopupViewImpl
extends Composite
implements SelectDocumentPopupView {
    @DataField(value="documents-container")
    Div documentsContainer;
    private final BaseModal modal;
    private final TranslationService translationService;
    private final ModalFooterOKCancelButtons footer = new ModalFooterOKCancelButtons(this::onOK, this::onCancel);
    private SelectDocumentPopupPresenter presenter;

    @Inject
    public SelectDocumentPopupViewImpl(Div documentsContainer, TranslationService translationService) {
        this.documentsContainer = documentsContainer;
        this.translationService = translationService;
        this.modal = new BaseModal();
    }

    @PostConstruct
    void init() {
        this.modal.setTitle(this.getSelectDocumentViewTitle());
        this.modal.setBody((Widget)this);
        this.modal.add((Widget)this.footer);
        this.modal.addHiddenHandler(e -> this.onHidden());
    }

    public void init(SelectDocumentPopupPresenter presenter) {
        this.presenter = presenter;
    }

    private String getSelectDocumentViewTitle() {
        return this.translationService.format("SelectDocumentPopupViewImpl.Title", new Object[0]);
    }

    @Override
    public void clear() {
        NodeList documents = this.documentsContainer.getChildNodes();
        for (int i = 0; i < documents.getLength(); ++i) {
            Node document = documents.item(i);
            this.documentsContainer.removeChild(document);
        }
    }

    @Override
    public void addDocument(SelectDocumentPopupView.SelectableDocumentView document) {
        PortablePreconditions.checkNotNull((String)"document", (Object)document);
        this.documentsContainer.appendChild((Node)document.getElement());
    }

    @Override
    public void enableOKButton(boolean enabled) {
        this.footer.enableOkButton(enabled);
    }

    @Override
    public void show() {
        this.modal.show();
    }

    @Override
    public void hide() {
        this.modal.hide();
    }

    private void onOK() {
        this.presenter.onOK();
    }

    private void onCancel() {
        this.presenter.onCancel();
    }

    private void onHidden() {
        this.presenter.dispose();
    }
}

