/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.metadata.client.popups;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.widgets.metadata.client.KieMultipleDocumentEditorPresenter;
import org.kie.workbench.common.widgets.metadata.client.popups.SelectDocumentPopupPresenter;
import org.kie.workbench.common.widgets.metadata.client.popups.SelectDocumentPopupView;
import org.uberfire.backend.vfs.Path;
import org.uberfire.mvp.ParameterizedCommand;

@Dependent
public class SelectDocumentPopup
implements SelectDocumentPopupPresenter {
    private SelectDocumentPopupView view;
    private ManagedInstance<SelectDocumentPopupView.SelectableDocumentView> selectableDocumentProvider;
    private KieMultipleDocumentEditorPresenter presenter;
    private final Set<SelectDocumentPopupView.SelectableDocumentView> selectedDocuments = new HashSet<SelectDocumentPopupView.SelectableDocumentView>();
    private final List<SelectDocumentPopupView.SelectableDocumentView> selectableDocuments = new ArrayList<SelectDocumentPopupView.SelectableDocumentView>();

    @Inject
    public SelectDocumentPopup(SelectDocumentPopupView view, ManagedInstance<SelectDocumentPopupView.SelectableDocumentView> selectableDocumentProvider) {
        this.view = view;
        this.selectableDocumentProvider = selectableDocumentProvider;
    }

    @PostConstruct
    void init() {
        this.view.init(this);
    }

    @Override
    @PreDestroy
    public void dispose() {
        this.view.clear();
        this.selectedDocuments.clear();
        this.selectableDocuments.clear();
    }

    @Override
    public void setEditorPresenter(KieMultipleDocumentEditorPresenter presenter) {
        this.presenter = (KieMultipleDocumentEditorPresenter)PortablePreconditions.checkNotNull((String)"presenter", (Object)presenter);
    }

    @Override
    public void setDocuments(List<Path> paths) {
        PortablePreconditions.checkNotNull((String)"paths", paths);
        this.dispose();
        for (Path path : paths) {
            SelectDocumentPopupView.SelectableDocumentView document = this.makeSelectableDocument(path);
            this.selectableDocuments.add(document);
            this.view.addDocument(document);
        }
        this.view.enableOKButton(false);
    }

    @Override
    public void show() {
        this.view.show();
    }

    @Override
    public void onOK() {
        if (!this.selectedDocuments.isEmpty()) {
            ArrayList<Path> selectedDocumentPaths = new ArrayList<Path>();
            for (SelectDocumentPopupView.SelectableDocumentView selectableDocument : this.selectableDocuments) {
                if (!this.selectedDocuments.contains(selectableDocument)) continue;
                Path path = selectableDocument.getPath();
                selectedDocumentPaths.add(path);
            }
            this.presenter.onOpenDocumentsInEditor(selectedDocumentPaths);
        }
        this.view.hide();
        this.dispose();
    }

    @Override
    public void onCancel() {
        this.view.hide();
        this.dispose();
    }

    SelectDocumentPopupView.SelectableDocumentView makeSelectableDocument(Path path) {
        SelectDocumentPopupView.SelectableDocumentView selectableDocument = (SelectDocumentPopupView.SelectableDocumentView)this.selectableDocumentProvider.get();
        selectableDocument.setPath(path);
        selectableDocument.setDocumentSelectedCommand((ParameterizedCommand<Boolean>)((ParameterizedCommand)selected -> this.selectDocument(selectableDocument, (boolean)selected)));
        return selectableDocument;
    }

    void selectDocument(SelectDocumentPopupView.SelectableDocumentView document, boolean selected) {
        if (selected) {
            this.selectedDocuments.add(document);
        } else {
            this.selectedDocuments.remove(document);
        }
        this.view.enableOKButton(!this.selectedDocuments.isEmpty());
        for (SelectDocumentPopupView.SelectableDocumentView d : this.selectableDocuments) {
            d.setSelected(this.selectedDocuments.contains(d));
        }
    }
}

