/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.metadata.client.menu;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.widgets.metadata.client.KieDocument;
import org.kie.workbench.common.widgets.metadata.client.menu.RegisteredDocumentsMenuView;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.impl.BaseMenuCustom;

@Dependent
public class RegisteredDocumentsMenuBuilder
implements MenuFactory.CustomMenuBuilder,
RegisteredDocumentsMenuView.Presenter {
    private boolean isReadOnly;
    private Command newDocumentCommand;
    private Command openDocumentCommand;
    private ParameterizedCommand<KieDocument> activateDocumentCommand;
    private ParameterizedCommand<KieDocument> removeDocumentCommand;
    private RegisteredDocumentsMenuView view;
    private ManagedInstance<RegisteredDocumentsMenuView.DocumentMenuItem> documentMenuItemProvider;
    private Map<KieDocument, RegisteredDocumentsMenuView.DocumentMenuItem> registeredDocuments = new HashMap<KieDocument, RegisteredDocumentsMenuView.DocumentMenuItem>();

    @Inject
    public RegisteredDocumentsMenuBuilder(RegisteredDocumentsMenuView view, ManagedInstance<RegisteredDocumentsMenuView.DocumentMenuItem> documentMenuItemProvider) {
        this.view = view;
        this.documentMenuItemProvider = documentMenuItemProvider;
    }

    @PostConstruct
    void setup() {
        this.view.init(this);
        this.view.enableNewDocumentButton(false);
        this.view.enableOpenDocumentButton(false);
        this.isReadOnly = false;
    }

    @Override
    public void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
        this.view.setReadOnly(isReadOnly);
        this.registeredDocuments.values().stream().forEach(e -> e.setReadOnly(isReadOnly));
    }

    @Override
    @PreDestroy
    public void dispose() {
        this.view.clear();
        this.registeredDocuments.clear();
    }

    public void push(MenuFactory.CustomMenuBuilder element) {
    }

    public MenuItem build() {
        return new BaseMenuCustom<IsWidget>(){

            public IsWidget build() {
                return ElementWrapperWidget.getWidget((HTMLElement)RegisteredDocumentsMenuBuilder.this.view.getElement());
            }

            public boolean isEnabled() {
                return RegisteredDocumentsMenuBuilder.this.view.isEnabled();
            }

            public void setEnabled(boolean enabled) {
                RegisteredDocumentsMenuBuilder.this.view.setEnabled(enabled);
            }
        };
    }

    @Override
    public void onOpenDocument() {
        if (this.isReadOnly) {
            return;
        }
        if (this.openDocumentCommand != null) {
            this.openDocumentCommand.execute();
        }
    }

    @Override
    public void onNewDocument() {
        if (this.isReadOnly) {
            return;
        }
        if (this.newDocumentCommand != null) {
            this.newDocumentCommand.execute();
        }
    }

    @Override
    public void registerDocument(KieDocument document) {
        RegisteredDocumentsMenuView.DocumentMenuItem documentMenuItem = this.makeDocumentMenuItem(document);
        this.registeredDocuments.put(document, documentMenuItem);
        this.view.addDocument(documentMenuItem);
    }

    @Override
    public void deregisterDocument(KieDocument document) {
        RegisteredDocumentsMenuView.DocumentMenuItem documentMenuItem = this.registeredDocuments.remove(document);
        this.documentMenuItemProvider.destroy((Object)documentMenuItem);
        this.view.deleteDocument(documentMenuItem);
    }

    @Override
    public void onActivateDocument(KieDocument document) {
        if (this.activateDocumentCommand != null) {
            this.activateDocumentCommand.execute((Object)document);
        }
    }

    @Override
    public void onRemoveDocument(KieDocument document) {
        if (this.isReadOnly) {
            return;
        }
        if (this.removeDocumentCommand != null) {
            this.removeDocumentCommand.execute((Object)document);
        }
    }

    @Override
    public void setNewDocumentCommand(Command newDocumentCommand) {
        this.newDocumentCommand = (Command)PortablePreconditions.checkNotNull((String)"newDocumentCommand", (Object)newDocumentCommand);
        this.view.enableNewDocumentButton(true);
    }

    @Override
    public void setOpenDocumentCommand(Command openDocumentCommand) {
        this.openDocumentCommand = (Command)PortablePreconditions.checkNotNull((String)"openDocumentCommand", (Object)openDocumentCommand);
        this.view.enableOpenDocumentButton(true);
    }

    @Override
    public void setActivateDocumentCommand(ParameterizedCommand<KieDocument> activateDocumentCommand) {
        this.activateDocumentCommand = (ParameterizedCommand)PortablePreconditions.checkNotNull((String)"activateDocumentCommand", activateDocumentCommand);
    }

    @Override
    public void setRemoveDocumentCommand(ParameterizedCommand<KieDocument> removeDocumentCommand) {
        this.removeDocumentCommand = (ParameterizedCommand)PortablePreconditions.checkNotNull((String)"removeDocumentCommand", removeDocumentCommand);
    }

    @Override
    public void activateDocument(KieDocument document) {
        for (Map.Entry<KieDocument, RegisteredDocumentsMenuView.DocumentMenuItem> e : this.registeredDocuments.entrySet()) {
            e.getValue().setActive(e.getKey().equals(document));
        }
    }

    RegisteredDocumentsMenuView.DocumentMenuItem makeDocumentMenuItem(KieDocument document) {
        RegisteredDocumentsMenuView.DocumentMenuItem documentMenuItem = (RegisteredDocumentsMenuView.DocumentMenuItem)this.documentMenuItemProvider.get();
        documentMenuItem.setName(document.getCurrentPath().getFileName());
        documentMenuItem.setRemoveDocumentCommand(() -> this.onRemoveDocument(document));
        documentMenuItem.setActivateDocumentCommand(() -> this.onActivateDocument(document));
        documentMenuItem.setReadOnly(document.isReadOnly());
        return documentMenuItem;
    }
}

