/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.metadata.client.menu;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.widgets.metadata.client.menu.RegisteredDocumentsMenuView;
import org.uberfire.mvp.Command;

@Templated
public class DocumentMenuItemImpl
implements RegisteredDocumentsMenuView.DocumentMenuItem {
    private static final String ACTIVE_CSS_CLASS = "kie-document-active";
    private static final String INACTIVE_CSS_CLASS = "kie-document-inactive";
    private static final String VISIBLE_CSS_CLASS = "kie-close-visible";
    private static final String HIDDEN_CSS_CLASS = "kie-close-hidden";
    private String name;
    private Command activateDocumentCommand;
    private Command removeDocumentCommand;
    @Inject
    @DataField(value="kie-document-name")
    Div kieDocumentName;
    @Inject
    @DataField(value="kie-document-registration")
    Div kieDocumentRegistration;
    @Inject
    @DataField(value="kie-document-close")
    Div kieDocumentClose;

    public HTMLElement getElement() {
        return this.kieDocumentRegistration;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.kieDocumentName.setInnerHTML(this.getSafeHtml(name).asString());
    }

    private SafeHtml getSafeHtml(String message) {
        SafeHtmlBuilder shb = new SafeHtmlBuilder();
        shb.appendEscaped(message);
        return shb.toSafeHtml();
    }

    @Override
    public void setActivateDocumentCommand(Command activateDocumentCommand) {
        this.activateDocumentCommand = (Command)PortablePreconditions.checkNotNull((String)"activateDocumentCommand", (Object)activateDocumentCommand);
    }

    @Override
    public void setRemoveDocumentCommand(Command removeDocumentCommand) {
        this.removeDocumentCommand = (Command)PortablePreconditions.checkNotNull((String)"removeDocumentCommand", (Object)removeDocumentCommand);
    }

    @Override
    public void setActive(boolean isActive) {
        if (isActive) {
            this.kieDocumentRegistration.setClassName(ACTIVE_CSS_CLASS);
        } else {
            this.kieDocumentRegistration.setClassName(INACTIVE_CSS_CLASS);
        }
    }

    @Override
    public void setReadOnly(boolean isReadOnly) {
        if (isReadOnly) {
            this.kieDocumentClose.setClassName(HIDDEN_CSS_CLASS);
        } else {
            this.kieDocumentClose.setClassName(VISIBLE_CSS_CLASS);
        }
    }

    @EventHandler(value={"kie-document-name"})
    public void onClickFileName(ClickEvent e) {
        if (this.activateDocumentCommand != null) {
            this.activateDocumentCommand.execute();
        }
    }

    @EventHandler(value={"kie-document-close"})
    public void onClickClose(ClickEvent e) {
        if (this.removeDocumentCommand != null) {
            this.removeDocumentCommand.execute();
        }
    }
}

