/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.metadata.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.IsWidget;
import elemental2.promise.Promise;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.client.security.ProjectController;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.guvnor.structure.repositories.RepositoryRemovedEvent;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.security.shared.api.identity.User;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.soup.project.datamodel.imports.Imports;
import org.kie.workbench.common.widgets.client.callbacks.CommandBuilder;
import org.kie.workbench.common.widgets.client.callbacks.CommandDrivenErrorCallback;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.docks.DockPlaceHolderBase;
import org.kie.workbench.common.widgets.client.docks.DockPlaceHolderBaseView;
import org.kie.workbench.common.widgets.client.docks.DockPlaceHolderPlace;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.kie.workbench.common.widgets.client.source.ViewDRLSourceWidget;
import org.kie.workbench.common.widgets.configresource.client.widget.bound.ImportsWidgetPresenter;
import org.kie.workbench.common.widgets.metadata.client.KieDocument;
import org.kie.workbench.common.widgets.metadata.client.KieEditorView;
import org.kie.workbench.common.widgets.metadata.client.KieMultipleDocumentEditorLockSyncHelper;
import org.kie.workbench.common.widgets.metadata.client.KieMultipleDocumentEditorPresenter;
import org.kie.workbench.common.widgets.metadata.client.KieMultipleDocumentEditorQualifier;
import org.kie.workbench.common.widgets.metadata.client.KieMultipleDocumentEditorWrapperView;
import org.kie.workbench.common.widgets.metadata.client.menu.RegisteredDocumentsMenuBuilder;
import org.kie.workbench.common.widgets.metadata.client.validation.AssetUpdateValidator;
import org.kie.workbench.common.widgets.metadata.client.widget.OverviewWidgetPresenter;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.AbstractWorkbenchActivity;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.client.promise.Promises;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.ext.editor.commons.client.BaseEditorView;
import org.uberfire.ext.editor.commons.client.file.popups.SavePopUpPresenter;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.ext.editor.commons.client.menu.DownloadMenuItemBuilder;
import org.uberfire.ext.editor.commons.client.menu.HasLockSyncMenuStateHelper;
import org.uberfire.ext.editor.commons.client.menu.MenuItems;
import org.uberfire.ext.editor.commons.client.resources.i18n.CommonConstants;
import org.uberfire.ext.editor.commons.client.validation.DefaultFileNameValidator;
import org.uberfire.ext.editor.commons.client.validation.ValidationErrorReason;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.client.validation.ValidatorCallback;
import org.uberfire.ext.editor.commons.client.validation.ValidatorWithReasonCallback;
import org.uberfire.ext.editor.commons.version.events.RestoreEvent;
import org.uberfire.ext.widgets.common.client.common.ConcurrentChangePopup;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;

public abstract class KieMultipleDocumentEditor<D extends KieDocument>
implements KieMultipleDocumentEditorPresenter<D> {
    protected KieMultipleDocumentEditorWrapperView kieEditorWrapperView;
    protected OverviewWidgetPresenter overviewWidget;
    protected ImportsWidgetPresenter importsWidget;
    protected Event<NotificationEvent> notificationEvent;
    protected Event<ChangeTitleWidgetEvent> changeTitleEvent;
    protected WorkspaceProjectContext workbenchContext;
    protected SavePopUpPresenter savePopUpPresenter;
    protected DownloadMenuItemBuilder downloadMenuItemBuilder;
    protected FileMenuBuilder fileMenuBuilder;
    protected VersionRecordManager versionRecordManager;
    protected RegisteredDocumentsMenuBuilder registeredDocumentsMenuBuilder;
    protected DefaultFileNameValidator fileNameValidator;
    protected AssetUpdateValidator assetUpdateValidator;
    protected ProjectController projectController;
    protected Event<NotificationEvent> notification;
    protected Promises promises;
    protected BaseEditorView editorView;
    protected ViewDRLSourceWidget sourceWidget = (ViewDRLSourceWidget)GWT.create(ViewDRLSourceWidget.class);
    private MenuItem saveMenuItem;
    private MenuItem versionMenuItem;
    private MenuItem registeredDocumentsMenuItem;
    private MenuItem downloadMenuItem;
    protected PlaceManager placeManager;
    protected Menus menus;
    protected D activeDocument = null;
    protected final Set<D> documents = new HashSet<D>();
    protected boolean saveWithComments = true;
    protected boolean showDocks = false;
    private final MayCloseHandler DEFAULT_MAY_CLOSE_HANDLER = this::doMayClose;
    private final MayCloseHandler EXCEPTION_MAY_CLOSE_HANDLER = (originalHashCode, currentHashCode) -> true;
    private MayCloseHandler mayCloseHandler = this.DEFAULT_MAY_CLOSE_HANDLER;

    KieMultipleDocumentEditor() {
    }

    public KieMultipleDocumentEditor(KieEditorView editorView) {
        this.editorView = editorView;
    }

    @PostConstruct
    protected void setupMenuBar() {
        this.makeMenuBar();
        this.kieEditorWrapperView.init(this);
    }

    @Inject
    protected void setKieEditorWrapperView(@KieMultipleDocumentEditorQualifier KieMultipleDocumentEditorWrapperView kieEditorWrapperView) {
        this.kieEditorWrapperView = kieEditorWrapperView;
        this.kieEditorWrapperView.setPresenter(this);
    }

    @Inject
    protected void setOverviewWidget(OverviewWidgetPresenter overviewWidget) {
        this.overviewWidget = overviewWidget;
    }

    @Inject
    protected void setSavePopUpPresenter(SavePopUpPresenter savePopUpPresenter) {
        this.savePopUpPresenter = savePopUpPresenter;
    }

    @Inject
    protected void setDownloadMenuItemBuilder(DownloadMenuItemBuilder downloadMenuItemBuilder) {
        this.downloadMenuItemBuilder = downloadMenuItemBuilder;
    }

    @Inject
    protected void setImportsWidget(ImportsWidgetPresenter importsWidget) {
        this.importsWidget = importsWidget;
    }

    @Inject
    protected void setNotificationEvent(Event<NotificationEvent> notificationEvent) {
        this.notificationEvent = notificationEvent;
    }

    @Inject
    protected void setChangeTitleEvent(Event<ChangeTitleWidgetEvent> changeTitleEvent) {
        this.changeTitleEvent = changeTitleEvent;
    }

    @Inject
    protected void setWorkbenchContext(WorkspaceProjectContext workbenchContext) {
        this.workbenchContext = workbenchContext;
    }

    @Inject
    protected void setVersionRecordManager(VersionRecordManager versionRecordManager) {
        this.versionRecordManager = versionRecordManager;
        this.versionRecordManager.setShowMoreCommand(() -> {
            this.kieEditorWrapperView.selectOverviewTab();
            this.overviewWidget.showVersionsTab();
        });
    }

    @Inject
    protected void setFileMenuBuilder(FileMenuBuilder fileMenuBuilder) {
        this.fileMenuBuilder = fileMenuBuilder;
    }

    @Inject
    protected void setRegisteredDocumentsMenuBuilder(RegisteredDocumentsMenuBuilder registeredDocumentsMenuBuilder) {
        this.registeredDocumentsMenuBuilder = registeredDocumentsMenuBuilder;
    }

    @Inject
    protected void setFileNameValidator(DefaultFileNameValidator fileNameValidator) {
        this.fileNameValidator = fileNameValidator;
    }

    @Inject
    protected void setAssetUpdateValidator(AssetUpdateValidator assetUpdateValidator) {
        this.assetUpdateValidator = assetUpdateValidator;
    }

    @Inject
    protected void setProjectController(ProjectController projectController) {
        this.projectController = projectController;
    }

    @Inject
    protected void setNotification(Event<NotificationEvent> notification) {
        this.notification = notification;
    }

    @Inject
    protected void setPromises(Promises promises) {
        this.promises = promises;
    }

    @Inject
    protected void setPlaceManager(PlaceManager placeManager) {
        this.placeManager = placeManager;
    }

    @Override
    public void registerDocument(D document) {
        PortablePreconditions.checkNotNull((String)"document", document);
        if (this.documents.contains(document)) {
            return;
        }
        this.documents.add(document);
        this.registeredDocumentsMenuBuilder.registerDocument((KieDocument)document);
        ObservablePath path = document.getLatestPath();
        path.onRename(() -> this.refresh(document));
        path.onConcurrentRename(info -> this.doConcurrentRename(document, (ObservablePath.OnConcurrentRenameEvent)info));
        path.onDelete(() -> {
            this.enableMenus(false);
            this.removeDocument(document);
            this.deregisterDocument(document);
        });
        path.onConcurrentDelete(info -> this.doConcurrentDelete(document, (ObservablePath.OnConcurrentDelete)info));
        path.onConcurrentUpdate(eventInfo -> document.setConcurrentUpdateSessionInfo((ObservablePath.OnConcurrentUpdateEvent)eventInfo));
    }

    protected void registerDock(String id, IsWidget widget) {
        DockPlaceHolderPlace placeRequest = new DockPlaceHolderPlace(id);
        this.registerDock((PlaceRequest)placeRequest, widget);
    }

    protected void registerDock(PlaceRequest placeRequest, IsWidget widget) {
        this.placeManager.registerOnOpenCallback(placeRequest, () -> {
            if (this.showDocks) {
                this.setDockWidget(placeRequest, widget);
            }
        });
    }

    protected void setDockWidget(PlaceRequest placeRequest, IsWidget widget) {
        Optional<DockPlaceHolderBase> dockPlaceHolder = this.getDockPlaceHolder(placeRequest);
        if (dockPlaceHolder.isPresent()) {
            dockPlaceHolder.get().setView(widget);
        }
    }

    private Optional<DockPlaceHolderBase> getDockPlaceHolder(PlaceRequest placeRequest) {
        if (Objects.equals(PlaceStatus.OPEN, this.placeManager.getStatus(placeRequest))) {
            AbstractWorkbenchActivity panelActivity = (AbstractWorkbenchActivity)this.placeManager.getActivity(placeRequest);
            return Optional.of(((DockPlaceHolderBaseView)panelActivity.getWidget()).getPresenter());
        }
        return Optional.empty();
    }

    void doConcurrentRename(D document, ObservablePath.OnConcurrentRenameEvent info) {
        ConcurrentChangePopup.newConcurrentRename((Path)info.getSource(), (Path)info.getTarget(), (User)info.getIdentity(), (Command)this.getConcurrentRenameOnIgnoreCommand(), (Command)this.getConcurrentRenameOnReopenCommand(document)).show();
    }

    Command getConcurrentRenameOnIgnoreCommand() {
        return () -> this.enableMenus(false);
    }

    Command getConcurrentRenameOnReopenCommand(D document) {
        return () -> {
            document.setConcurrentUpdateSessionInfo(null);
            this.refresh(document);
        };
    }

    void doConcurrentDelete(D document, ObservablePath.OnConcurrentDelete info) {
        ConcurrentChangePopup.newConcurrentDelete((Path)info.getPath(), (User)info.getIdentity(), (Command)this.getConcurrentDeleteOnIgnoreCommand(), (Command)this.getConcurrentDeleteOnClose(document)).show();
    }

    Command getConcurrentDeleteOnIgnoreCommand() {
        return () -> this.enableMenus(false);
    }

    Command getConcurrentDeleteOnClose(D document) {
        return () -> {
            this.enableMenus(false);
            this.removeDocument(document);
            this.deregisterDocument(document);
        };
    }

    @Override
    public void deregisterDocument(D document) {
        PortablePreconditions.checkNotNull((String)"document", document);
        if (!this.documents.contains(document)) {
            return;
        }
        this.registeredDocumentsMenuBuilder.deregisterDocument((KieDocument)document);
        document.getLatestPath().dispose();
        this.documents.remove(document);
    }

    private void refresh(D document) {
        String documentTitle = this.getDocumentTitle(document);
        this.editorView.refreshTitle(documentTitle);
        this.editorView.showBusyIndicator(CommonConstants.INSTANCE.Loading());
        this.refreshDocument(document);
        PlaceRequest placeRequest = document.getPlaceRequest();
        this.changeTitleEvent.fire((Object)new ChangeTitleWidgetEvent(placeRequest, documentTitle, this.getTitleWidget(document)));
    }

    @Override
    public void activateDocument(D document, Overview overview, AsyncPackageDataModelOracle dmo, Imports imports, boolean isReadOnly) {
        PortablePreconditions.checkNotNull((String)"document", document);
        PortablePreconditions.checkNotNull((String)"overview", (Object)overview);
        PortablePreconditions.checkNotNull((String)"dmo", document);
        PortablePreconditions.checkNotNull((String)"imports", (Object)imports);
        if (!this.documents.contains(document)) {
            throw new IllegalArgumentException("Document has not been registered.");
        }
        this.activeDocument = document;
        this.registeredDocumentsMenuBuilder.activateDocument((KieDocument)document);
        this.initialiseVersionManager(document);
        this.initialiseKieEditorTabs(document, overview, dmo, imports, isReadOnly);
    }

    @Override
    public D getActiveDocument() {
        return this.activeDocument;
    }

    protected void initialiseVersionManager(D document) {
        String version = document.getVersion();
        ObservablePath path = document.getLatestPath();
        this.versionRecordManager.init(version, path, versionRecord -> {
            this.versionRecordManager.setVersion(versionRecord.id());
            document.setVersion(versionRecord.id());
            document.setCurrentPath(this.versionRecordManager.getCurrentPath());
            document.setReadOnly(!this.versionRecordManager.isLatest(versionRecord));
            this.refreshDocument(document);
        });
    }

    protected void initialiseKieEditorTabs(D document, Overview overview, AsyncPackageDataModelOracle dmo, Imports imports, boolean isReadOnly) {
        this.kieEditorWrapperView.clear();
        this.kieEditorWrapperView.addMainEditorPage((IsWidget)this.editorView);
        this.kieEditorWrapperView.addOverviewPage(this.overviewWidget, () -> this.overviewWidget.refresh(this.versionRecordManager.getVersion()));
        this.kieEditorWrapperView.addSourcePage(this.sourceWidget);
        this.kieEditorWrapperView.addImportsTab((IsWidget)this.importsWidget);
        this.overviewWidget.setContent(overview, document.getLatestPath());
        this.importsWidget.setContent(dmo, imports, isReadOnly);
    }

    @Override
    public IsWidget getWidget() {
        return this.kieEditorWrapperView.asWidget();
    }

    @Override
    public IsWidget getTitleWidget(D document) {
        PortablePreconditions.checkNotNull((String)"document", document);
        this.editorView.refreshTitle(this.getDocumentTitle(document));
        return this.editorView.getTitleWidget();
    }

    @Override
    public void getMenus(Consumer<Menus> menusConsumer) {
        this.makeMenuBar().then(v -> {
            menusConsumer.accept(this.menus);
            return this.promises.resolve();
        });
    }

    @Override
    public void onClose() {
        ArrayList<D> documents = new ArrayList<D>(this.documents);
        documents.stream().forEach(this::deregisterDocument);
        this.versionRecordManager.clear();
        this.activeDocument = null;
    }

    @Override
    public void onSourceTabSelected() {
        this.onSourceTabSelected(this.getActiveDocument());
    }

    @Override
    public void updateSource(String source) {
        this.sourceWidget.setContent(source);
    }

    @Override
    public void onEditTabSelected() {
    }

    @Override
    public void onEditTabUnselected() {
    }

    @Override
    public void onOverviewSelected() {
    }

    @Override
    public boolean mayClose(Integer originalHashCode, Integer currentHashCode) {
        return this.mayCloseHandler.mayClose(originalHashCode, currentHashCode);
    }

    protected void setMayCloseHandler(MayCloseHandler mayCloseHandler) {
        this.mayCloseHandler = mayCloseHandler;
    }

    protected boolean doMayClose(Integer originalHashCode, Integer currentHashCode) {
        return !this.isDirty(originalHashCode, currentHashCode) && !this.overviewWidget.isDirty();
    }

    protected boolean isDirty(Integer originalHashCode, Integer currentHashCode) {
        if (originalHashCode == null) {
            return currentHashCode != null;
        }
        return !originalHashCode.equals(currentHashCode);
    }

    @Override
    public Promise<Void> makeMenuBar() {
        if (this.menus == null) {
            this.fileMenuBuilder.setLockSyncMenuStateHelper((HasLockSyncMenuStateHelper.LockSyncMenuStateHelper)new KieMultipleDocumentEditorLockSyncHelper(this));
            if (this.workbenchContext.getActiveWorkspaceProject().isPresent()) {
                WorkspaceProject activeProject = (WorkspaceProject)this.workbenchContext.getActiveWorkspaceProject().get();
                return this.projectController.canUpdateProject(activeProject).then(canUpdateProject -> {
                    if (canUpdateProject.booleanValue()) {
                        this.fileMenuBuilder.addSave(this.getSaveMenuItem()).addCopy(() -> this.getActiveDocument().getCurrentPath(), (Validator)this.assetUpdateValidator).addRename(() -> this.getActiveDocument().getLatestPath(), (Validator)this.assetUpdateValidator).addDelete(() -> this.getActiveDocument().getLatestPath(), (Validator)this.assetUpdateValidator);
                    }
                    this.addDownloadMenuItem(this.fileMenuBuilder);
                    this.menus = this.fileMenuBuilder.addValidate(() -> this.onValidate(this.getActiveDocument())).addNewTopLevelMenu(this.getRegisteredDocumentsMenuItem()).addNewTopLevelMenu(this.getVersionManagerMenuItem()).build();
                    return this.promises.resolve();
                });
            }
        }
        return this.promises.resolve();
    }

    protected void addDownloadMenuItem(FileMenuBuilder menuBuilder) {
        menuBuilder.addNewTopLevelMenu(this.downloadMenuItem());
    }

    private MenuItem downloadMenuItem() {
        if (this.downloadMenuItem == null) {
            this.downloadMenuItem = this.downloadMenuItemBuilder.build(() -> this.getActiveDocument().getLatestPath());
        }
        return this.downloadMenuItem;
    }

    protected MenuItem getSaveMenuItem() {
        if (this.saveMenuItem == null) {
            ParameterizedCommand onSave = withComments -> {
                this.saveWithComments = withComments;
                this.saveAction();
            };
            this.saveMenuItem = this.versionRecordManager.newSaveMenuItem(onSave);
        }
        return this.saveMenuItem;
    }

    protected void saveAction() {
        this.assetUpdateValidator.validate(null, (ValidatorCallback)new ValidatorWithReasonCallback(){

            public void onFailure(String reason) {
                if (ValidationErrorReason.NOT_ALLOWED.name().equals(reason)) {
                    KieMultipleDocumentEditor.this.showError(KieMultipleDocumentEditor.this.kieEditorWrapperView.getNotAllowedSavingMessage());
                } else {
                    KieMultipleDocumentEditor.this.showError(KieMultipleDocumentEditor.this.kieEditorWrapperView.getUnexpectedErrorWhileSavingMessage());
                }
            }

            public void onSuccess() {
                KieMultipleDocumentEditor.this.doSave();
            }

            public void onFailure() {
                KieMultipleDocumentEditor.this.showError(KieMultipleDocumentEditor.this.kieEditorWrapperView.getUnexpectedErrorWhileSavingMessage());
            }
        });
    }

    private void showError(String error) {
        this.notification.fire((Object)new NotificationEvent(error, NotificationEvent.NotificationType.ERROR));
    }

    protected MenuItem getRegisteredDocumentsMenuItem() {
        if (this.registeredDocumentsMenuItem == null) {
            this.registeredDocumentsMenuItem = this.registeredDocumentsMenuBuilder.build();
            this.registeredDocumentsMenuBuilder.setOpenDocumentCommand(this::openDocumentInEditor);
        }
        return this.registeredDocumentsMenuItem;
    }

    protected MenuItem getVersionManagerMenuItem() {
        if (this.versionMenuItem == null) {
            this.versionMenuItem = this.versionRecordManager.buildMenu();
        }
        return this.versionMenuItem;
    }

    protected void doSave() {
        D document = this.getActiveDocument();
        if (document == null) {
            return;
        }
        boolean isReadOnly = document.isReadOnly();
        if (isReadOnly) {
            if (this.versionRecordManager.isCurrentLatest()) {
                this.editorView.alertReadOnly();
            } else {
                this.versionRecordManager.restoreToCurrentVersion(this.saveWithComments);
            }
            return;
        }
        this.doSaveCheckForAndHandleConcurrentUpdate(document);
    }

    protected void doSaveCheckForAndHandleConcurrentUpdate(D document) {
        ObservablePath.OnConcurrentUpdateEvent concurrentUpdateSessionInfo = document.getConcurrentUpdateSessionInfo();
        if (concurrentUpdateSessionInfo != null) {
            this.showConcurrentUpdatePopup(document);
        } else {
            this.doSave(document);
        }
    }

    void showConcurrentUpdatePopup(D document) {
        ObservablePath.OnConcurrentUpdateEvent concurrentUpdateSessionInfo = document.getConcurrentUpdateSessionInfo();
        ConcurrentChangePopup.newConcurrentUpdate((Path)concurrentUpdateSessionInfo.getPath(), (User)concurrentUpdateSessionInfo.getIdentity(), () -> this.doSave(document), () -> {}, () -> {
            document.setConcurrentUpdateSessionInfo(null);
            this.refresh(document);
        }).show();
    }

    void doSave(D document) {
        if (this.saveWithComments) {
            this.savePopUpPresenter.show((Path)document.getCurrentPath(), this.getSaveCommand(document));
        } else {
            this.getSaveCommand(document).execute((Object)"");
        }
    }

    ParameterizedCommand<String> getSaveCommand(D document) {
        return commitMessage -> {
            this.editorView.showSaving();
            this.onSave(document, (String)commitMessage);
            document.setConcurrentUpdateSessionInfo(null);
        };
    }

    void onRestore(@Observes RestoreEvent event) {
        if (event == null || event.getPath() == null) {
            return;
        }
        if (this.versionRecordManager.getCurrentPath() == null) {
            return;
        }
        if (this.versionRecordManager.getCurrentPath().equals(event.getPath())) {
            this.activeDocument.setVersion(null);
            this.activeDocument.setLatestPath(this.versionRecordManager.getPathToLatest());
            this.activeDocument.setCurrentPath(this.versionRecordManager.getPathToLatest());
            this.initialiseVersionManager(this.activeDocument);
            this.activeDocument.setReadOnly(false);
            this.refreshDocument(this.activeDocument);
            this.notificationEvent.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemRestored()));
        }
    }

    void onRepositoryRemoved(@Observes RepositoryRemovedEvent event) {
        Optional.ofNullable(this.workbenchContext).flatMap(context -> context.getActiveWorkspaceProject()).filter(proj -> event.getRepository() != null && proj.getRepository().equals(event.getRepository())).ifPresent(repo -> this.enableMenus(false));
    }

    protected void enableMenus(boolean enabled) {
        this.getSaveMenuItem().setEnabled(enabled);
        this.getVersionManagerMenuItem().setEnabled(enabled);
        this.enableMenuItem(enabled, MenuItems.COPY);
        this.enableMenuItem(enabled, MenuItems.RENAME);
        this.enableMenuItem(enabled, MenuItems.DELETE);
        this.enableMenuItem(enabled, MenuItems.VALIDATE);
    }

    protected void enableMenuItem(boolean enabled, MenuItems menuItem) {
        this.getMenus(menus -> {
            if (menus.getItemsMap().containsKey(menuItem)) {
                ((MenuItem)menus.getItemsMap().get(menuItem)).setEnabled(enabled);
            }
        });
    }

    protected void openDocumentInEditor() {
        this.getAvailableDocumentPaths((Callback<List<Path>>)((Callback)allPaths -> {
            for (KieDocument document : this.documents) {
                allPaths.remove(document.getLatestPath());
            }
            if (allPaths.isEmpty()) {
                this.kieEditorWrapperView.showNoAdditionalDocuments();
            } else {
                this.kieEditorWrapperView.showAdditionalDocuments((List<Path>)allPaths);
            }
        }));
    }

    protected CommandDrivenErrorCallback getNoSuchFileExceptionErrorCallback() {
        return new CommandDrivenErrorCallback((HasBusyIndicator)this.editorView, new CommandBuilder().addNoSuchFileException((HasBusyIndicator)this.editorView, this.kieEditorWrapperView.getMultiPage(), this.menus).addFileSystemNotFoundException((HasBusyIndicator)this.editorView, this.kieEditorWrapperView.getMultiPage(), this.menus).build()){

            public boolean error(Message message, Throwable throwable) {
                KieMultipleDocumentEditor.this.mayCloseHandler = KieMultipleDocumentEditor.this.EXCEPTION_MAY_CLOSE_HANDLER;
                return super.error(message, throwable);
            }
        };
    }

    protected CommandDrivenErrorCallback getCouldNotGenerateSourceErrorCallback() {
        return new CommandDrivenErrorCallback((HasBusyIndicator)this.editorView, new CommandBuilder().addSourceCodeGenerationFailedException((HasBusyIndicator)this.editorView, this.sourceWidget).build());
    }

    protected RemoteCallback<Path> getSaveSuccessCallback(D document, int currentHashCode) {
        return path -> {
            this.editorView.hideBusyIndicator();
            this.versionRecordManager.reloadVersions(path);
            this.notificationEvent.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemSavedSuccessfully()));
            document.setOriginalHashCode(currentHashCode);
            this.overviewWidget.resetDirty();
        };
    }

    public static interface MayCloseHandler {
        public boolean mayClose(Integer var1, Integer var2);
    }
}

