/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.metadata.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.IsWidget;
import elemental2.promise.Promise;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.client.security.ProjectController;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.guvnor.messageconsole.client.console.widget.button.AlertsButtonMenuItemBuilder;
import org.guvnor.structure.repositories.RepositoryRemovedEvent;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.kie.workbench.common.widgets.client.callbacks.CommandBuilder;
import org.kie.workbench.common.widgets.client.callbacks.CommandDrivenErrorCallback;
import org.kie.workbench.common.widgets.client.docks.DefaultEditorDock;
import org.kie.workbench.common.widgets.client.docks.DockPlaceHolderBaseView;
import org.kie.workbench.common.widgets.client.docks.DockPlaceHolderPlace;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.kie.workbench.common.widgets.client.source.ViewDRLSourceWidget;
import org.kie.workbench.common.widgets.metadata.client.KieEditorView;
import org.kie.workbench.common.widgets.metadata.client.KieEditorWrapperView;
import org.kie.workbench.common.widgets.metadata.client.validation.AssetUpdateValidator;
import org.kie.workbench.common.widgets.metadata.client.widget.OverviewWidgetPresenter;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.AbstractWorkbenchActivity;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.client.workbench.events.AbstractPlaceEvent;
import org.uberfire.client.workbench.events.PlaceGainFocusEvent;
import org.uberfire.client.workbench.events.PlaceHiddenEvent;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.client.workbench.widgets.multipage.Page;
import org.uberfire.ext.editor.commons.client.BaseEditor;
import org.uberfire.ext.editor.commons.client.BaseEditorView;
import org.uberfire.ext.editor.commons.client.file.popups.CopyPopUpPresenter;
import org.uberfire.ext.editor.commons.client.file.popups.RenamePopUpPresenter;
import org.uberfire.ext.editor.commons.client.file.popups.SavePopUpPresenter;
import org.uberfire.ext.editor.commons.client.menu.MenuItems;
import org.uberfire.ext.editor.commons.client.validation.ValidationErrorReason;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.client.validation.ValidatorCallback;
import org.uberfire.ext.editor.commons.client.validation.ValidatorWithReasonCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.MenuItem;

public abstract class KieEditor<T>
extends BaseEditor<T, Metadata>
implements KieEditorWrapperView.KieEditorWrapperPresenter {
    private final MayCloseHandler EXCEPTION_MAY_CLOSE_HANDLER = new MayCloseHandler(){

        @Override
        public boolean mayClose(Object object) {
            return true;
        }
    };
    @Inject
    protected KieEditorWrapperView kieView;
    @Inject
    protected OverviewWidgetPresenter overviewWidget;
    private final MayCloseHandler DEFAULT_MAY_CLOSE_HANDLER;
    @Inject
    protected FileMenuBuilder fileMenuBuilder;
    @Inject
    protected WorkspaceProjectContext workbenchContext;
    @Inject
    protected SavePopUpPresenter savePopUpPresenter;
    @Inject
    protected RenamePopUpPresenter renamePopUpPresenter;
    @Inject
    protected CopyPopUpPresenter copyPopUpPresenter;
    @Inject
    protected ProjectController projectController;
    @Inject
    protected AssetUpdateValidator assetUpdateValidator;
    @Inject
    protected AlertsButtonMenuItemBuilder alertsButtonMenuItemBuilder;
    protected Metadata metadata;
    @Inject
    protected DefaultEditorDock docks;
    @Inject
    protected PerspectiveManager perspectiveManager;
    private ViewDRLSourceWidget sourceWidget;
    private MayCloseHandler mayCloseHandler = this.DEFAULT_MAY_CLOSE_HANDLER = new MayCloseHandler(){

        @Override
        public boolean mayClose(Object object) {
            if (object != null) {
                return KieEditor.this.mayClose(object.hashCode());
            }
            return true;
        }
    };

    protected KieEditor() {
    }

    protected KieEditor(KieEditorView baseView) {
        super((BaseEditorView)baseView);
    }

    protected void init(ObservablePath path, PlaceRequest place, ClientResourceType type) {
        this.init(path, place, type, true);
    }

    protected void init(ObservablePath path, PlaceRequest place, ClientResourceType type, boolean addFileChangeListeners) {
        this.init(path, place, type, addFileChangeListeners, true, new MenuItems[0]);
    }

    protected void init(ObservablePath path, PlaceRequest place, ClientResourceType type, MenuItems ... menuItems) {
        this.init(path, place, type, true, false, menuItems);
    }

    protected void init(ObservablePath path, PlaceRequest place, ClientResourceType type, boolean addFileChangeListeners, boolean displayShowMoreVersions, MenuItems ... menuItems) {
        this.kieView.setPresenter(this);
        super.init(path, place, type, addFileChangeListeners, displayShowMoreVersions, menuItems);
    }

    public void onShowDiagramEditorDocks(@Observes PlaceGainFocusEvent event) {
        if (this.verifyEventIdentifier((AbstractPlaceEvent)event)) {
            if (!this.docks.isSetup()) {
                this.docks.setup(this.perspectiveManager.getCurrentPerspective().getIdentifier(), (PlaceRequest)new DefaultPlaceRequest("org.kie.guvnor.explorer"));
            }
            this.showDocks();
        }
    }

    public void onHideDocks(@Observes PlaceHiddenEvent event) {
        if (this.verifyEventIdentifier((AbstractPlaceEvent)event)) {
            this.hideDocks();
        }
    }

    public void showDocks() {
        this.docks.show();
    }

    public void hideDocks() {
        this.docks.hide();
    }

    public boolean verifyEventIdentifier(AbstractPlaceEvent event) {
        return Objects.equals(this.getEditorIdentifier(), event.getPlace().getIdentifier()) && Objects.equals(this.place, event.getPlace());
    }

    protected abstract String getEditorIdentifier();

    protected void showVersions() {
        this.selectOverviewTab();
        this.overviewWidget.showVersionsTab();
    }

    protected void createOriginalHash(Object object) {
        if (object != null) {
            this.setOriginalHash(object.hashCode());
        }
    }

    public void setOriginalHash(Integer originalHash) {
        super.setOriginalHash(originalHash);
        this.overviewWidget.resetDirty();
    }

    public boolean mayClose(Object object) {
        return this.mayCloseHandler.mayClose(object);
    }

    protected CommandDrivenErrorCallback getNoSuchFileExceptionErrorCallback() {
        return new CommandDrivenErrorCallback((HasBusyIndicator)this.baseView, new CommandBuilder().addNoSuchFileException((HasBusyIndicator)this.baseView, this.kieView.getMultiPage(), this.menus).addFileSystemNotFoundException((HasBusyIndicator)this.baseView, this.kieView.getMultiPage(), this.menus).build()){

            public boolean error(Message message, Throwable throwable) {
                KieEditor.this.mayCloseHandler = KieEditor.this.EXCEPTION_MAY_CLOSE_HANDLER;
                return super.error(message, throwable);
            }
        };
    }

    protected CommandDrivenErrorCallback getCouldNotGenerateSourceErrorCallback() {
        return new CommandDrivenErrorCallback((HasBusyIndicator)this.baseView, new CommandBuilder().addSourceCodeGenerationFailedException((HasBusyIndicator)this.baseView, this.sourceWidget).build());
    }

    protected void addSourcePage() {
        this.sourceWidget = (ViewDRLSourceWidget)GWT.create(ViewDRLSourceWidget.class);
        this.kieView.addSourcePage(this.sourceWidget);
    }

    protected void addPage(Page page) {
        this.kieView.addPage(page);
    }

    protected void resetEditorPages(Overview overview) {
        this.overviewWidget.setContent(overview, this.versionRecordManager.getPathToLatest());
        this.resetMetadata(overview);
        this.kieView.clear();
        this.kieView.addMainEditorPage((IsWidget)this.baseView);
        this.kieView.addOverviewPage(this.overviewWidget, () -> this.overviewWidget.refresh(this.versionRecordManager.getVersion()));
    }

    protected void resetEditorPagesOnLoadError(Overview overview) {
        this.resetEditorPages(overview);
    }

    protected void resetMetadata(Overview overview) {
        this.metadata = overview.getMetadata();
        if (Optional.ofNullable(this.metadata).isPresent()) {
            this.setMetadataOriginalHash(this.metadata.hashCode());
        }
    }

    @OnClose
    public void onClose() {
        this.kieView.clear();
    }

    protected void addImportsTab(IsWidget importsWidget) {
        this.kieView.addImportsTab(importsWidget);
    }

    protected Promise<Void> makeMenuBar() {
        if (this.workbenchContext.getActiveWorkspaceProject().isPresent()) {
            WorkspaceProject activeProject = (WorkspaceProject)this.workbenchContext.getActiveWorkspaceProject().get();
            return this.projectController.canUpdateProject(activeProject).then(canUpdateProject -> {
                if (canUpdateProject.booleanValue()) {
                    this.addSave(this.fileMenuBuilder);
                    this.addCopy(this.fileMenuBuilder);
                    this.addRename(this.fileMenuBuilder);
                    this.addDelete(this.fileMenuBuilder);
                }
                this.addDownloadMenuItem(this.fileMenuBuilder);
                this.addCommonActions(this.fileMenuBuilder);
                return this.promises.resolve();
            });
        }
        return this.promises.resolve();
    }

    public void addDownloadMenuItem(FileMenuBuilder fileMenuBuilder) {
        fileMenuBuilder.addNewTopLevelMenu(this.downloadMenuItem());
    }

    protected void addSave(FileMenuBuilder fileMenuBuilder) {
        ParameterizedCommand onSave = withComments -> {
            this.saveWithComments = withComments;
            this.saveAction();
        };
        fileMenuBuilder.addSave(this.versionRecordManager.newSaveMenuItem(onSave));
    }

    protected void addCopy(FileMenuBuilder fileMenuBuilder) {
        fileMenuBuilder.addCopy((Path)this.versionRecordManager.getCurrentPath(), (Validator)this.assetUpdateValidator);
    }

    protected void addRename(FileMenuBuilder fileMenuBuilder) {
        Optional<Caller> saveAndRenameServiceCaller = Optional.ofNullable(this.getSaveAndRenameServiceCaller());
        if (saveAndRenameServiceCaller.isPresent()) {
            fileMenuBuilder.addRename(this.getSaveAndRename());
        } else {
            fileMenuBuilder.addRename((Path)this.versionRecordManager.getPathToLatest(), (Validator)this.assetUpdateValidator);
        }
    }

    protected void addDelete(FileMenuBuilder fileMenuBuilder) {
        fileMenuBuilder.addDelete((Path)this.versionRecordManager.getPathToLatest(), (Validator)this.assetUpdateValidator);
    }

    protected void addCommonActions(FileMenuBuilder fileMenuBuilder) {
        fileMenuBuilder.addValidate(this.getValidateCommand()).addNewTopLevelMenu(this.versionRecordManager.buildMenu()).addNewTopLevelMenu(this.alertsButtonMenuItemBuilder.build());
    }

    Command getSaveActionCommand() {
        return this::saveAction;
    }

    protected Supplier<Metadata> getMetadataSupplier() {
        return () -> this.metadata;
    }

    public Validator getRenameValidator() {
        return this.assetUpdateValidator;
    }

    protected void saveAction() {
        this.assetUpdateValidator.validate(null, (ValidatorCallback)new ValidatorWithReasonCallback(){

            public void onFailure(String reason) {
                if (ValidationErrorReason.NOT_ALLOWED.name().equals(reason)) {
                    KieEditor.this.showError(KieEditor.this.kieView.getNotAllowedSavingMessage());
                } else {
                    KieEditor.this.showError(KieEditor.this.kieView.getUnexpectedErrorWhileSavingMessage());
                }
            }

            public void onSuccess() {
                KieEditor.this.onSave();
            }

            public void onFailure() {
                KieEditor.this.showError(KieEditor.this.kieView.getUnexpectedErrorWhileSavingMessage());
            }
        });
    }

    protected void onSave() {
        super.onSave();
    }

    private void showError(String error) {
        this.notification.fire((Object)new NotificationEvent(error, NotificationEvent.NotificationType.ERROR));
    }

    protected void buildMenuBar() {
        if (this.fileMenuBuilder != null) {
            this.menus = this.fileMenuBuilder.build();
        }
    }

    protected boolean isEditorTabSelected() {
        return this.kieView.isEditorTabSelected();
    }

    protected boolean isOverviewTabSelected() {
        return this.kieView.isOverviewTabSelected();
    }

    protected int getSelectedTabIndex() {
        return this.kieView.getSelectedTabIndex();
    }

    public void setSelectedTab(int index) {
        this.kieView.setSelectedTab(index);
    }

    protected void selectOverviewTab() {
        this.kieView.selectOverviewTab();
    }

    protected void selectEditorTab() {
        this.kieView.selectEditorTab();
    }

    protected void updateSource(String source) {
        this.sourceWidget.setContent(source);
    }

    public IsWidget getWidget() {
        return this.kieView.asWidget();
    }

    public void onRepositoryRemoved(@Observes RepositoryRemovedEvent event) {
        Optional.ofNullable(this.workbenchContext).flatMap(context -> context.getActiveWorkspaceProject()).filter(proj -> event.getRepository() != null && proj.getRepository().equals(event.getRepository())).ifPresent(proj -> {
            for (MenuItem mi : this.menus.getItemsMap().values()) {
                mi.setEnabled(false);
            }
        });
    }

    public boolean mayClose(Integer currentHash) {
        return !this.isDirty(currentHash) && !this.overviewWidget.isDirty();
    }

    protected void save() {
        ParameterizedCommand command = commitMessage -> {
            this.baseView.showSaving();
            this.save((String)commitMessage);
            this.concurrentUpdateSessionInfo = null;
        };
        if (this.saveWithComments) {
            this.savePopUpPresenter.show((Path)this.versionRecordManager.getCurrentPath(), command);
        } else {
            command.execute((Object)"");
        }
        this.concurrentUpdateSessionInfo = null;
    }

    protected void save(String commitMessage) {
    }

    protected void registerDock(String id, IsWidget widget) {
        DockPlaceHolderPlace placeRequest = new DockPlaceHolderPlace(id);
        this.placeManager.registerOnOpenCallback((PlaceRequest)placeRequest, () -> {
            if (this.getDockPresenter((PlaceRequest)placeRequest).isPresent()) {
                this.getDockPresenter((PlaceRequest)placeRequest).get().setWidget(widget);
            }
        });
    }

    private Optional<DockPlaceHolderBaseView> getDockPresenter(PlaceRequest placeRequest) {
        if (PlaceStatus.OPEN.equals((Object)this.placeManager.getStatus(placeRequest))) {
            AbstractWorkbenchActivity panelActivity = (AbstractWorkbenchActivity)this.placeManager.getActivity(placeRequest);
            return Optional.of((DockPlaceHolderBaseView)panelActivity.getWidget());
        }
        return Optional.empty();
    }

    @Override
    public void onOverviewSelected() {
    }

    @Override
    public void onSourceTabSelected() {
    }

    @Override
    public void onEditTabSelected() {
    }

    @Override
    public void onEditTabUnselected() {
    }

    public void addTabBarWidget(IsWidget customWidget) {
        this.kieView.addTabBarWidget(customWidget);
    }

    private static interface MayCloseHandler {
        public boolean mayClose(Object var1);
    }
}

