/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.search.component;

import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.kie.workbench.common.widgets.client.search.common.EditorSearchIndex;
import org.kie.workbench.common.widgets.client.search.common.Searchable;
import org.uberfire.client.mvp.UberElemental;

@Dependent
public class SearchBarComponent<T extends Searchable> {
    private final View view;
    private EditorSearchIndex<T> editorSearchIndex;

    @Inject
    public SearchBarComponent(View view) {
        this.view = view;
    }

    @PostConstruct
    void setup() {
        this.view.init(this);
    }

    public void init(EditorSearchIndex<T> editorSearchIndex) {
        this.editorSearchIndex = editorSearchIndex;
    }

    public View getView() {
        return this.view;
    }

    public void disableSearch() {
        this.view.disableSearch();
    }

    void search(String term) {
        if (!term.isEmpty()) {
            this.getEditorSearchIndex().search(term);
        }
        this.updateViewNumber();
    }

    void nextResult() {
        this.getEditorSearchIndex().nextResult();
        this.updateViewNumber();
    }

    void previousResult() {
        this.getEditorSearchIndex().previousResult();
        this.updateViewNumber();
    }

    void closeIndex() {
        this.editorSearchIndex().ifPresent(EditorSearchIndex::close);
        this.updateViewNumber();
    }

    void updateViewNumber() {
        int currentResultNumber = this.editorSearchIndex().map(EditorSearchIndex::getCurrentResultNumber).orElse(0);
        int totalOfResultsNumber = this.editorSearchIndex().map(EditorSearchIndex::getTotalOfResultsNumber).orElse(0);
        this.view.setCurrentResultNumber(currentResultNumber);
        this.view.setTotalOfResultsNumber(totalOfResultsNumber);
    }

    private EditorSearchIndex<T> getEditorSearchIndex() {
        return this.editorSearchIndex().orElseThrow(UnsupportedOperationException::new);
    }

    private Optional<EditorSearchIndex<T>> editorSearchIndex() {
        return Optional.ofNullable(this.editorSearchIndex);
    }

    public static interface View
    extends UberElemental<SearchBarComponent>,
    IsElement {
        public void setCurrentResultNumber(Integer var1);

        public void setTotalOfResultsNumber(Integer var1);

        public void disableSearch();
    }
}

