/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.popups.launcher;

import com.google.common.base.Strings;
import com.google.gwt.user.client.ui.Composite;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Element;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.NodeList;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.widgets.client.popups.launcher.AppLauncherItemView;
import org.kie.workbench.common.widgets.client.popups.launcher.AppLauncherPresenter;

@Dependent
@Templated(stylesheet="AppLauncherView.css")
public class AppLauncherView
extends Composite
implements AppLauncherPresenter.AppLauncherView {
    @Inject
    private ManagedInstance<AppLauncherItemView> appLauncherItemViews;
    @Inject
    @DataField(value="left-column")
    private Div leftColumn;
    @Inject
    @DataField(value="right-column")
    private Div rightColumn;

    @Override
    public void addAppLauncher(String name, String url, String iconClass) {
        AppLauncherItemView app = (AppLauncherItemView)this.appLauncherItemViews.get();
        app.setName(name);
        app.setIcon(Strings.isNullOrEmpty((String)iconClass) ? "fa-cube" : iconClass);
        app.setURL(url);
        if (this.leftColumn.getChildNodes().getLength() == this.rightColumn.getChildNodes().getLength()) {
            this.leftColumn.appendChild((Node)app.getElement());
        } else {
            this.rightColumn.appendChild((Node)app.getElement());
        }
    }

    @Override
    public void removeAllAppLauncher() {
        this.appLauncherItemViews.destroyAll();
        this.removeAllNodes((Element)this.leftColumn);
        this.removeAllNodes((Element)this.rightColumn);
    }

    public void removeAllNodes(Element element) {
        NodeList nodeList = element.getChildNodes();
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            element.removeChild(nodeList.item(0));
        }
    }
}

