/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.popups.copy;

import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.model.Package;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.gwtbootstrap3.client.ui.Label;
import org.gwtbootstrap3.client.ui.ModalFooter;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.widgets.client.handlers.PackageListBox;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.client.file.popups.CommonModalBuilder;
import org.uberfire.ext.editor.commons.client.file.popups.CopyPopUpPresenter;
import org.uberfire.ext.editor.commons.client.file.popups.commons.ToggleCommentPresenter;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.GenericModalFooter;
import org.uberfire.mvp.Command;

@Dependent
@Templated
public class CopyPopupWithPackageView
implements CopyPopUpPresenter.View,
IsElement {
    @Inject
    @DataField(value="body")
    Div body;
    @Inject
    @DataField(value="newNameTextBox")
    TextBox newNameTextBox;
    @Inject
    @DataField(value="newNameLabel")
    Label newNameLabel;
    @Inject
    @DataField(value="error")
    Div error;
    @Inject
    @DataField(value="errorMessage")
    Span errorMessage;
    @Inject
    @DataField(value="packageListBox")
    PackageListBox packageListBox;
    @Inject
    @DataField(value="packageHelpInline")
    HelpBlock packageHelpInline;
    @Inject
    TranslationService translationService;
    @Inject
    WorkspaceProjectContext context;
    CopyPopUpPresenter presenter;
    BaseModal modal;
    Button copyButton;

    public void init(CopyPopUpPresenter presenter) {
        this.presenter = presenter;
        this.modalSetup();
        this.setupComment();
    }

    public void show() {
        this.errorSetup();
        this.packageListBoxSetup();
        this.newNameTextBoxSetup();
        this.modal.show();
    }

    public void hide() {
        this.modal.hide();
    }

    public void handleDuplicatedFileName() {
        this.showError(this.translate("CopyPopUpView.FileAlreadyExists", this.newNameTextBox.getValue()));
    }

    public void handleInvalidFileName() {
        this.showError(this.translate("CopyPopUpView.InvalidFileName", this.newNameTextBox.getValue()));
    }

    public Path getTargetPath() {
        if (this.thereIsAnActiveProject()) {
            String path = this.presenter.getPath().toURI();
            Package selectedPackage = this.packageListBox.getSelectedPackage();
            if (path.contains("src/main/resources")) {
                return selectedPackage.getPackageMainResourcesPath();
            }
            if (path.contains("src/main/java")) {
                return selectedPackage.getPackageMainSrcPath();
            }
            if (path.contains("src/test/resources")) {
                return selectedPackage.getPackageTestResourcesPath();
            }
            if (path.contains("src/test/java")) {
                return selectedPackage.getPackageTestSrcPath();
            }
        }
        return null;
    }

    public String getPackageName() {
        if (this.packageListBox.getSelectedPackage() != null) {
            return this.packageListBox.getSelectedPackage().getPackageName();
        }
        return null;
    }

    public void handleCopyNotAllowed() {
        this.showError(this.translate("CopyPopUpView.CopyNotAllowed", new Object[0]));
    }

    private void modalSetup() {
        this.newNameLabel.setText(this.translate("CopyPopUpView.NewName", new Object[0]));
        this.modal = new CommonModalBuilder().addHeader(this.translate("CopyPopUpView.MakeACopy", new Object[0])).addBody((HTMLElement)this.body).addFooter(this.footer()).build();
    }

    private ModalFooter footer() {
        GenericModalFooter footer = new GenericModalFooter();
        footer.addButton(this.translate("CopyPopUpView.Cancel", new Object[0]), this.cancelCommand(), ButtonType.DEFAULT);
        footer.add((Widget)this.copyButton());
        return footer;
    }

    Button copyButton() {
        if (this.copyButton == null) {
            this.copyButton = this.button(this.translate("CopyPopUpView.MakeACopy", new Object[0]), this.copyCommand(), ButtonType.PRIMARY);
        }
        return this.copyButton;
    }

    Button button(String text, Command command, ButtonType type) {
        Button button = new Button(text, event -> command.execute());
        button.setType(type);
        return button;
    }

    private String translate(String key, Object ... args) {
        return this.translationService.format(key, args);
    }

    private Command copyCommand() {
        return () -> this.presenter.copy(this.newNameTextBox.getValue());
    }

    private void newNameTextBoxSetup() {
        this.newNameTextBox.setValue((Object)"");
    }

    private void errorSetup() {
        this.error.setHidden(true);
    }

    private void showError(String errorMessage) {
        this.errorMessage.setTextContent(errorMessage);
        this.error.setHidden(false);
    }

    private Command cancelCommand() {
        return () -> this.presenter.cancel();
    }

    void packageListBoxSetup() {
        String path = this.presenter.getPath().toURI();
        if (this.thereIsAnActiveProject() && this.isAProjectResource(path)) {
            this.copyButton().setEnabled(false);
            this.packageListBox.setUp(true, () -> this.copyButton.setEnabled(true));
        }
    }

    private void setupComment() {
        this.body.appendChild((Node)this.toggleCommentPresenter().getViewElement());
    }

    private ToggleCommentPresenter toggleCommentPresenter() {
        return this.presenter.getToggleCommentPresenter();
    }

    boolean isAProjectResource(String path) {
        return path.contains("src/main/resources") || path.contains("src/main/java") || path.contains("src/test/resources") || path.contains("src/test/java");
    }

    boolean thereIsAnActiveProject() {
        return this.context.getActiveModule().isPresent();
    }
}

