/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.handlers;

import com.google.gwt.core.client.Callback;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.LinkedList;
import java.util.List;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.kie.workbench.common.services.shared.validation.ValidationService;
import org.kie.workbench.common.widgets.client.handlers.NewResourceHandler;
import org.kie.workbench.common.widgets.client.handlers.NewResourcePresenter;
import org.kie.workbench.common.widgets.client.handlers.NewResourceSuccessEvent;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.editor.commons.client.validation.ValidatorWithReasonCallback;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.type.ResourceTypeDefinition;

public abstract class DefaultNewResourceHandler
implements NewResourceHandler {
    protected final List<Pair<String, ? extends IsWidget>> extensions = new LinkedList<Pair<String, ? extends IsWidget>>();
    @Inject
    protected WorkspaceProjectContext context;
    @Inject
    protected Caller<KieModuleService> moduleService;
    @Inject
    protected Caller<ValidationService> validationService;
    @Inject
    protected PlaceManager placeManager;
    @Inject
    protected Event<NotificationEvent> notificationEvent;
    @Inject
    protected Event<NewResourceSuccessEvent> newResourceSuccessEvent;
    @Inject
    protected BusyIndicatorView busyIndicatorView;

    DefaultNewResourceHandler(WorkspaceProjectContext context, Caller<KieModuleService> moduleService, Caller<ValidationService> validationService, PlaceManager placeManager, Event<NotificationEvent> notificationEvent, BusyIndicatorView busyIndicatorView) {
        this.context = context;
        this.moduleService = moduleService;
        this.validationService = validationService;
        this.placeManager = placeManager;
        this.notificationEvent = notificationEvent;
        this.busyIndicatorView = busyIndicatorView;
    }

    public DefaultNewResourceHandler() {
    }

    @Override
    public List<Pair<String, ? extends IsWidget>> getExtensions() {
        return this.extensions;
    }

    @Override
    public void validate(final String baseFileName, final ValidatorWithReasonCallback callback) {
        String fileName = this.buildFileName(baseFileName, this.getResourceType());
        ((ValidationService)this.validationService.call((RemoteCallback)new RemoteCallback<Boolean>(){

            public void callback(Boolean response) {
                if (Boolean.TRUE.equals(response)) {
                    callback.onSuccess();
                } else {
                    callback.onFailure(CommonConstants.INSTANCE.InvalidFileName0(baseFileName));
                }
            }
        })).isFileNameValid(fileName);
    }

    @Override
    public void acceptContext(Callback<Boolean, Void> callback) {
        callback.onSuccess((Object)(this.context != null && this.context.getActiveModule().isPresent() ? 1 : 0));
    }

    @Override
    public Command getCommand(final NewResourcePresenter newResourcePresenter) {
        return new Command(){

            public void execute() {
                newResourcePresenter.show(DefaultNewResourceHandler.this);
            }
        };
    }

    protected String buildFileName(String baseFileName, ResourceTypeDefinition resourceType) {
        String extension;
        String suffix = resourceType.getSuffix();
        String prefix = resourceType.getPrefix();
        String string = extension = suffix != null && !"".equals(suffix) ? "." + resourceType.getSuffix() : "";
        if (baseFileName.endsWith(extension)) {
            return prefix + baseFileName;
        }
        return prefix + baseFileName + extension;
    }

    protected void notifySuccess() {
        this.notificationEvent.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemCreatedSuccessfully(), NotificationEvent.NotificationType.SUCCESS));
    }

    protected RemoteCallback<Path> getSuccessCallback(final NewResourcePresenter presenter) {
        return new RemoteCallback<Path>(){

            public void callback(Path path) {
                DefaultNewResourceHandler.this.busyIndicatorView.hideBusyIndicator();
                presenter.complete();
                DefaultNewResourceHandler.this.notifySuccess();
                DefaultNewResourceHandler.this.newResourceSuccessEvent.fire((Object)new NewResourceSuccessEvent(path));
                DefaultNewResourceHandler.this.placeManager.goTo(path);
            }
        };
    }

    @Override
    public boolean canCreate() {
        return true;
    }
}

