/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.datamodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kie.workbench.common.widgets.client.datamodel.OracleUtils;

public class CEPOracle {
    private static final String[] WINDOW_CEP_OPERATORS = new String[]{"over window:time", "over window:length"};
    private static final String[] SIMPLE_CEP_OPERATORS = new String[]{"after", "before", "coincides"};
    private static final String[] COMPLEX_CEP_OPERATORS = new String[]{"during", "finishes", "finishedby", "includes", "meets", "metby", "overlaps", "overlappedby", "starts", "startedby"};
    private static final String[] SIMPLE_CEP_CONNECTIVES = new String[]{"|| after", "|| before", "|| coincides", "&& after", "&& before", "&& coincides"};
    private static final String[] COMPLEX_CEP_CONNECTIVES = new String[]{"|| during", "|| finishes", "|| finishedby", "|| includes", "|| meets", "|| metby", "|| overlaps", "|| overlappedby", "|| starts", "|| startedby", "&& during", "&& finishes", "&& finishedby", "&& includes", "&& meets", "&& metby", "&& overlaps", "&& overlappedby", "&& starts", "&& startedby"};
    private static final Map<String, List<Integer>> CEP_OPERATORS_PARAMETERS = new HashMap<String, List<Integer>>();

    public static boolean isCEPOperator(String operator) {
        if (operator == null) {
            return false;
        }
        String[] operators = OracleUtils.joinArrays(SIMPLE_CEP_OPERATORS, COMPLEX_CEP_OPERATORS, SIMPLE_CEP_CONNECTIVES, COMPLEX_CEP_CONNECTIVES);
        for (int i = 0; i < operators.length; ++i) {
            if (!operator.equals(operators[i])) continue;
            return true;
        }
        return false;
    }

    public static List<Integer> getCEPOperatorParameterSets(String operator) {
        ArrayList<Integer> sets = new ArrayList<Integer>();
        if (operator == null) {
            return sets;
        }
        if (operator.startsWith("|| ") || operator.startsWith("&& ")) {
            operator = operator.substring(3);
        }
        if (!CEP_OPERATORS_PARAMETERS.containsKey(operator)) {
            return sets;
        }
        return CEP_OPERATORS_PARAMETERS.get(operator);
    }

    public static List<String> getCEPWindowOperators() {
        return Arrays.asList(WINDOW_CEP_OPERATORS);
    }

    public static boolean isCEPWindowOperator(String operator) {
        if (operator == null) {
            return false;
        }
        for (String cepWindowOperator : WINDOW_CEP_OPERATORS) {
            if (!operator.equals(cepWindowOperator)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCEPWindowOperatorTime(String operator) {
        if (operator == null) {
            return false;
        }
        return WINDOW_CEP_OPERATORS[0].equals(operator);
    }

    public static boolean isCEPWindowOperatorLength(String operator) {
        if (operator == null) {
            return false;
        }
        return WINDOW_CEP_OPERATORS[1].equals(operator);
    }

    static {
        CEP_OPERATORS_PARAMETERS.put("after", Arrays.asList(0, 1, 2));
        CEP_OPERATORS_PARAMETERS.put("before", Arrays.asList(0, 1, 2));
        CEP_OPERATORS_PARAMETERS.put("coincides", Arrays.asList(0, 1, 2));
        CEP_OPERATORS_PARAMETERS.put("during", Arrays.asList(0, 1, 2, 4));
        CEP_OPERATORS_PARAMETERS.put("finishes", Arrays.asList(0, 1));
        CEP_OPERATORS_PARAMETERS.put("finishedby", Arrays.asList(0, 1));
        CEP_OPERATORS_PARAMETERS.put("includes", Arrays.asList(0, 1, 2, 4));
        CEP_OPERATORS_PARAMETERS.put("meets", Arrays.asList(0, 1));
        CEP_OPERATORS_PARAMETERS.put("metby", Arrays.asList(0, 1));
        CEP_OPERATORS_PARAMETERS.put("overlaps", Arrays.asList(0, 1, 2));
        CEP_OPERATORS_PARAMETERS.put("overlappedby", Arrays.asList(0, 1, 2));
        CEP_OPERATORS_PARAMETERS.put("starts", Arrays.asList(0, 1));
        CEP_OPERATORS_PARAMETERS.put("startedby", Arrays.asList(0, 1));
    }
}

