/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.datamodel;

import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.workbench.models.datamodel.oracle.DSLActionSentence;
import org.drools.workbench.models.datamodel.oracle.DSLConditionSentence;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.kie.soup.project.datamodel.imports.HasImports;
import org.kie.soup.project.datamodel.oracle.ExtensionKind;
import org.kie.workbench.common.services.datamodel.model.PackageDataModelOracleBaselinePayload;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.uberfire.backend.vfs.Path;

@ApplicationScoped
public class AsyncPackageDataModelOracleFactory {
    @Inject
    private SyncBeanManager iocManager;

    public AsyncPackageDataModelOracle makeAsyncPackageDataModelOracle(Path resourcePath, PackageDataModelOracleBaselinePayload payload) {
        AsyncPackageDataModelOracle oracle = (AsyncPackageDataModelOracle)this.iocManager.lookupBean(AsyncPackageDataModelOracle.class, new Annotation[0]).getInstance();
        this.populate(oracle, payload);
        oracle.init(resourcePath);
        oracle.filter();
        return oracle;
    }

    public AsyncPackageDataModelOracle makeAsyncPackageDataModelOracle(Path resourcePath, HasImports hasImports, PackageDataModelOracleBaselinePayload payload) {
        AsyncPackageDataModelOracle oracle = (AsyncPackageDataModelOracle)this.iocManager.lookupBean(AsyncPackageDataModelOracle.class, new Annotation[0]).getInstance();
        this.populate(oracle, payload);
        oracle.init(resourcePath);
        oracle.filter(hasImports.getImports());
        return oracle;
    }

    public void destroy(AsyncPackageDataModelOracle oracle) {
        this.iocManager.destroyBean((Object)oracle);
    }

    private void populate(AsyncPackageDataModelOracle oracle, PackageDataModelOracleBaselinePayload payload) {
        oracle.setModuleName(payload.getModuleName());
        oracle.addModelFields(payload.getModelFields());
        oracle.addFieldParametersType(payload.getFieldParametersType());
        oracle.addEventTypes(payload.getEventTypes());
        oracle.addTypeSources(payload.getTypeSources());
        oracle.addSuperTypes(payload.getSuperTypes());
        oracle.addTypeAnnotations(payload.getTypeAnnotations());
        oracle.addTypeFieldsAnnotations(payload.getTypeFieldsAnnotations());
        oracle.addJavaEnumDefinitions(payload.getJavaEnumDefinitions());
        oracle.addMethodInformation(payload.getMethodInformation());
        oracle.addCollectionTypes(payload.getCollectionTypes());
        oracle.setPackageName(payload.getPackageName());
        oracle.addWorkbenchEnumDefinitions(payload.getWorkbenchEnumDefinitions());
        oracle.addDslConditionSentences(payload.getPackageElements((ExtensionKind)DSLConditionSentence.INSTANCE));
        oracle.addDslActionSentences(payload.getPackageElements((ExtensionKind)DSLActionSentence.INSTANCE));
        oracle.addGlobals(payload.getGlobals());
    }
}

