/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.cards.frame;

import elemental2.dom.HTMLElement;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.kie.workbench.common.widgets.client.cards.CardComponent;
import org.kie.workbench.common.widgets.client.cards.CardsGridComponent;
import org.uberfire.client.mvp.UberElemental;

public class CardFrameComponent {
    private final View view;
    private CardComponent card;
    private CardsGridComponent grid;

    @Inject
    public CardFrameComponent(View view) {
        this.view = view;
    }

    @PostConstruct
    void setup() {
        this.getView().init(this);
    }

    public void initialize(CardsGridComponent grid, CardComponent card) {
        this.grid = grid;
        this.card = card;
        this.refreshView();
    }

    public HTMLElement getElement() {
        return this.getView().getElement();
    }

    public void refreshView() {
        this.getView().setupToggleTitle(this.isToggleTitleEnabled());
        this.getView().setUUID(this.getCard().getUUID());
        this.getView().setIcon(this.getCard().getIcon().getCssName());
        this.getView().setTitle(this.getCard().getTitle());
        this.getView().setContent(this.getCard().getContent());
        this.getView().enableReadOnlyMode();
    }

    void changeTitle() {
        if (this.getCard().onTitleChanged().apply(this.getView().getTitle()).booleanValue()) {
            this.refreshView();
        }
    }

    boolean isToggleTitleEnabled() {
        return this.getCard().onTitleChanged() != CardComponent.DEFAULT_FUNCTION;
    }

    public void enableEditMode() {
        this.getGrid().enableReadOnlyModeForAllCards();
        this.getView().enableEditMode();
    }

    public void enableReadOnlyMode() {
        this.refreshView();
    }

    public View getView() {
        return this.view;
    }

    CardComponent getCard() {
        return this.card;
    }

    CardsGridComponent getGrid() {
        return this.grid;
    }

    public static interface View
    extends UberElemental<CardFrameComponent>,
    IsElement {
        public void setUUID(String var1);

        public void setIcon(String var1);

        public void setTitle(String var1);

        public void setContent(HTMLElement var1);

        public String getTitle();

        public void enableReadOnlyMode();

        public void enableEditMode();

        public void setupToggleTitle(boolean var1);
    }
}

