/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.callbacks;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.HashMap;
import java.util.Map;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.services.shared.source.SourceGenerationFailedException;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.kie.workbench.common.widgets.client.source.ViewDRLSourceWidget;
import org.kie.workbench.common.widgets.client.widget.NoSuchFileWidget;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.workbench.widgets.multipage.MultiPageEditor;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;
import org.uberfire.java.nio.file.FileSystemNotFoundException;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;

public class CommandBuilder {
    private final Map<Class<? extends Throwable>, Command> commands = new HashMap<Class<? extends Throwable>, Command>();

    public CommandBuilder add(Class<? extends Throwable> throwable, Command command) {
        PortablePreconditions.checkNotNull((String)"throwable", throwable);
        PortablePreconditions.checkNotNull((String)"command", (Object)command);
        this.commands.put(throwable, command);
        return this;
    }

    public CommandBuilder addNoSuchFileException(final HasBusyIndicator view, final Callback<IsWidget> callback) {
        this.add(NoSuchFileException.class, new Command(){

            public void execute() {
                callback.callback((Object)new NoSuchFileWidget());
                view.hideBusyIndicator();
            }
        });
        return this;
    }

    public CommandBuilder addNoSuchFileException(final HasBusyIndicator view, final MultiPageEditor editor) {
        this.add(NoSuchFileException.class, new Command(){

            public void execute() {
                editor.clear();
                editor.addWidget((IsWidget)new NoSuchFileWidget(), CommonConstants.INSTANCE.NoSuchFileTabTitle());
                view.hideBusyIndicator();
            }
        });
        return this;
    }

    public CommandBuilder addNoSuchFileException(final HasBusyIndicator view, final MultiPageEditor editor, final Menus menus) {
        this.add(NoSuchFileException.class, new Command(){

            public void execute() {
                editor.clear();
                editor.addWidget((IsWidget)new NoSuchFileWidget(), CommonConstants.INSTANCE.NoSuchFileTabTitle());
                CommandBuilder.this.disableMenuItems(menus);
                view.hideBusyIndicator();
            }
        });
        return this;
    }

    public CommandBuilder addNoSuchFileException(final HasBusyIndicator view, final Menus menus) {
        this.add(NoSuchFileException.class, new Command(){

            public void execute() {
                CommandBuilder.this.disableMenuItems(menus);
                view.hideBusyIndicator();
            }
        });
        return this;
    }

    public CommandBuilder addFileSystemNotFoundException(final HasBusyIndicator view, final MultiPageEditor editor, final Menus menus) {
        this.add(FileSystemNotFoundException.class, new Command(){

            public void execute() {
                editor.clear();
                editor.addWidget((IsWidget)new NoSuchFileWidget(), CommonConstants.INSTANCE.NoSuchFileTabTitle());
                CommandBuilder.this.disableMenuItems(menus);
                view.hideBusyIndicator();
            }
        });
        return this;
    }

    public CommandBuilder addFileSystemNotFoundException(final HasBusyIndicator view, final Menus menus) {
        this.add(FileSystemNotFoundException.class, new Command(){

            public void execute() {
                CommandBuilder.this.disableMenuItems(menus);
                view.hideBusyIndicator();
            }
        });
        return this;
    }

    public CommandBuilder addSourceCodeGenerationFailedException(final HasBusyIndicator view, final ViewDRLSourceWidget sourceWidget) {
        this.add(SourceGenerationFailedException.class, new Command(){

            public void execute() {
                sourceWidget.clearContent();
                view.hideBusyIndicator();
                ErrorPopup.showMessage((String)CommonConstants.INSTANCE.FailedToGenerateSource());
            }
        });
        return this;
    }

    private void disableMenuItems(Menus menus) {
        for (MenuItem mi : menus.getItemsMap().values()) {
            mi.setEnabled(false);
        }
    }

    public Map<Class<? extends Throwable>, Command> build() {
        return this.commands;
    }
}

